/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.texture.Textures;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;

public class CoverDetectorEnergyAdvanced
extends CoverBehavior
implements CoverWithUI,
ITickable,
IControllable {
    public long minEU = 0L;
    public long maxEU = 32L;
    private int outputAmount = 0;
    private boolean inverted = false;
    private boolean isEnabled = true;

    public CoverDetectorEnergyAdvanced(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null) != null;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.DETECTOR_ENERGY_ADVANCED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_73660_a() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L || !this.isEnabled) {
            return;
        }
        IEnergyContainer energyContainer = this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
        if (energyContainer != null && energyContainer.getEnergyCapacity() > 0L) {
            this.compareValue(energyContainer.getEnergyStored(), this.maxEU, this.minEU);
            this.setRedstoneSignalOutput(this.outputAmount);
        }
    }

    private void compareValue(long value, long maxValue, long minValue) {
        if (value >= maxValue) {
            this.outputAmount = this.inverted ? 15 : 0;
        } else if (value <= minValue) {
            this.outputAmount = this.inverted ? 0 : 15;
        }
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        int PADDING = 5;
        int SIZE = 18;
        WidgetGroup group = new WidgetGroup();
        group.addWidget(new LabelWidget(10, 8, "cover.advanced_energy_detector.label", new Object[0]));
        group.addWidget(new LabelWidget(10, 5 + SIZE + PADDING, "cover.advanced_energy_detector.invert_label", new Object[0]));
        group.addWidget(new CycleButtonWidget(72, 5 + SIZE, 4 * SIZE, SIZE, this::isInverted, this::setInverted, "cover.advanced_energy_detector.normal", "cover.advanced_energy_detector.inverted").setTooltipHoverString("cover.advanced_energy_detector.invert_tooltip"));
        group.addWidget(new LabelWidget(10, 5 + 2 * (SIZE + PADDING), "cover.advanced_energy_detector.max", new Object[0]));
        group.addWidget(new ImageWidget(68, 2 * (SIZE + PADDING), 4 * SIZE, SIZE, GuiTextures.DISPLAY));
        group.addWidget(new TextFieldWidget2(72, 5 + 2 * (SIZE + PADDING), 4 * SIZE, SIZE, this::getMaxValue, this::setMaxValue).setMaxLength(19).setAllowedChars(Pattern.compile(".[0-9]*")).setPostFix(" EU"));
        group.addWidget(new LabelWidget(10, 5 + 3 * (SIZE + PADDING), "cover.advanced_energy_detector.min", new Object[0]));
        group.addWidget(new ImageWidget(68, 3 * (SIZE + PADDING), 4 * SIZE, SIZE, GuiTextures.DISPLAY));
        group.addWidget(new TextFieldWidget2(72, 5 + 3 * (SIZE + PADDING), 4 * SIZE, SIZE, this::getMinValue, this::setMinValue).setMaxLength(19).setAllowedChars(Pattern.compile(".[0-9]*")).setPostFix(" EU"));
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 108).widget(group).build(this, player);
    }

    private String getMinValue() {
        return String.valueOf(this.minEU);
    }

    private String getMaxValue() {
        return String.valueOf(this.maxEU);
    }

    private void setMinValue(String val) {
        try {
            long c = Long.parseLong(val);
            this.minEU = Math.min(this.maxEU - 1L, c);
        }
        catch (NumberFormatException e) {
            GTLog.logger.warn((Object)e);
            this.minEU = Math.max(this.maxEU - 1L, 0L);
        }
    }

    private void setMaxValue(String val) {
        try {
            long c = Long.parseLong(val);
            this.maxEU = Math.max(this.minEU + 1L, c);
        }
        catch (NumberFormatException e) {
            GTLog.logger.warn((Object)e);
            this.maxEU = Math.max(this.minEU + 1L, 2048L);
        }
    }

    private boolean isInverted() {
        return this.inverted;
    }

    private void setInverted(boolean b) {
        this.inverted = b;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74772_a("maxEU", this.maxEU);
        tagCompound.func_74772_a("minEU", this.minEU);
        tagCompound.func_74768_a("outputAmount", this.outputAmount);
        tagCompound.func_74757_a("inverted", this.inverted);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        return tagCompound;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.minEU = tagCompound.func_74763_f("minEU");
        this.maxEU = tagCompound.func_74763_f("maxEU");
        this.outputAmount = tagCompound.func_74762_e("outputAmount");
        this.inverted = tagCompound.func_74767_n("inverted");
        this.isEnabled = tagCompound.func_74767_n("isEnabled");
    }

    @Override
    public void writeInitialSyncData(@Nonnull PacketBuffer packetBuffer) {
        packetBuffer.writeLong(this.minEU);
        packetBuffer.writeLong(this.maxEU);
        packetBuffer.writeInt(this.outputAmount);
        packetBuffer.writeBoolean(this.inverted);
        packetBuffer.writeBoolean(this.isEnabled);
    }

    @Override
    public void readInitialSyncData(@Nonnull PacketBuffer packetBuffer) {
        this.minEU = packetBuffer.readLong();
        this.maxEU = packetBuffer.readLong();
        this.outputAmount = packetBuffer.readInt();
        this.inverted = packetBuffer.readBoolean();
        this.isEnabled = packetBuffer.readBoolean();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isEnabled = isActivationAllowed;
        this.setRedstoneSignalOutput(0);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }
}

