/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.math.IntMath;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.DistributionMode;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.filter.FluidFilterContainer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CoverPump
extends CoverBehavior
implements CoverWithUI,
ITickable,
IControllable {
    public final int tier;
    public final int maxFluidTransferRate;
    protected int transferRate;
    protected PumpMode pumpMode;
    protected ManualImportExportMode manualImportExportMode = ManualImportExportMode.DISABLED;
    protected DistributionMode distributionMode;
    protected int fluidLeftToTransferLastSecond;
    private CoverableFluidHandlerWrapper fluidHandlerWrapper;
    protected boolean isWorkingAllowed = true;
    protected FluidFilterContainer fluidFilter;
    protected BucketMode bucketMode;

    public CoverPump(ICoverable coverHolder, EnumFacing attachedSide, int tier, int mbPerTick) {
        super(coverHolder, attachedSide);
        this.tier = tier;
        this.maxFluidTransferRate = mbPerTick;
        this.fluidLeftToTransferLastSecond = this.transferRate = mbPerTick;
        this.pumpMode = PumpMode.EXPORT;
        this.distributionMode = DistributionMode.INSERT_FIRST;
        this.bucketMode = BucketMode.MILLI_BUCKET;
        this.fluidFilter = new FluidFilterContainer((IDirtyNotifiable)this, this::shouldShowTip);
    }

    protected boolean shouldShowTip() {
        return false;
    }

    public void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
        this.coverHolder.markDirty();
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + (amount *= this.bucketMode == BucketMode.BUCKET ? 1000 : 1)), (int)1, (int)this.maxFluidTransferRate));
    }

    public void setPumpMode(PumpMode pumpMode) {
        this.pumpMode = pumpMode;
        this.writeUpdateData(1, buf -> buf.func_179249_a((Enum)pumpMode));
        this.coverHolder.markDirty();
    }

    public PumpMode getPumpMode() {
        return this.pumpMode;
    }

    public void setBucketMode(BucketMode bucketMode) {
        this.bucketMode = bucketMode;
        if (this.bucketMode == BucketMode.BUCKET) {
            this.setTransferRate(this.transferRate / 1000 * 1000);
        }
        this.coverHolder.markDirty();
    }

    public BucketMode getBucketMode() {
        return this.bucketMode;
    }

    public ManualImportExportMode getManualImportExportMode() {
        return this.manualImportExportMode;
    }

    protected void setManualImportExportMode(ManualImportExportMode manualImportExportMode) {
        this.manualImportExportMode = manualImportExportMode;
        this.coverHolder.markDirty();
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilter;
    }

    public void func_73660_a() {
        long timer = this.coverHolder.getOffsetTimer();
        if (this.isWorkingAllowed && this.fluidLeftToTransferLastSecond > 0) {
            this.fluidLeftToTransferLastSecond -= this.doTransferFluids(this.fluidLeftToTransferLastSecond);
        }
        if (timer % 20L == 0L) {
            this.fluidLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferFluids(int transferLimit) {
        BlockPos pos = this.coverHolder.getPos().func_177972_a(this.attachedSide);
        TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s(pos);
        IFluidHandler fluidHandler = tileEntity == null ? null : (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
        IFluidHandler myFluidHandler = (IFluidHandler)this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide);
        if (fluidHandler == null || myFluidHandler == null) {
            return 0;
        }
        return this.doTransferFluidsInternal(myFluidHandler, fluidHandler, transferLimit);
    }

    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        if (this.pumpMode == PumpMode.IMPORT) {
            return GTTransferUtils.transferFluids(fluidHandler, myFluidHandler, transferLimit, this.fluidFilter::testFluidStack);
        }
        if (this.pumpMode == PumpMode.EXPORT) {
            return GTTransferUtils.transferFluids(myFluidHandler, fluidHandler, transferLimit, this.fluidFilter::testFluidStack);
        }
        return 0;
    }

    protected boolean checkInputFluid(FluidStack fluidStack) {
        return this.fluidFilter.testFluidStack(fluidStack);
    }

    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        return builder.build(this, player);
    }

    protected String getUITitle() {
        return "cover.pump.title";
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), GTValues.VN[this.tier]));
        primaryGroup.addWidget(new ImageWidget(44, 20, 62, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new IncrementButtonWidget(136, 20, 30, 20, 1, 10, 100, 1000, this::adjustTransferRate).setDefaultTooltip().setShouldClientCallback(false));
        primaryGroup.addWidget(new IncrementButtonWidget(10, 20, 34, 20, -1, -10, -100, -1000, this::adjustTransferRate).setDefaultTooltip().setShouldClientCallback(false));
        TextFieldWidget2 textField = new TextFieldWidget2(45, 26, 60, 20, () -> this.bucketMode == BucketMode.BUCKET ? Integer.toString(this.transferRate / 1000) : Integer.toString(this.transferRate), val -> {
            if (val != null && !val.isEmpty()) {
                int amount = Integer.parseInt(val);
                if (this.bucketMode == BucketMode.BUCKET) {
                    amount = IntMath.saturatedMultiply((int)amount, (int)1000);
                }
                this.setTransferRate(amount);
            }
        }).setCentered(true).setNumbersOnly(1, this.bucketMode == BucketMode.BUCKET ? this.maxFluidTransferRate / 1000 : this.maxFluidTransferRate).setMaxLength(8);
        primaryGroup.addWidget(textField);
        primaryGroup.addWidget(new CycleButtonWidget(106, 20, 30, 20, BucketMode.class, this::getBucketMode, mode -> {
            if (mode != this.bucketMode) {
                this.setBucketMode((BucketMode)((Object)mode));
            }
        }));
        primaryGroup.addWidget(new CycleButtonWidget(10, 43, 75, 18, PumpMode.class, this::getPumpMode, this::setPumpMode));
        primaryGroup.addWidget(new CycleButtonWidget(7, 160, 116, 20, ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        this.fluidFilter.initUI(88, primaryGroup::addWidget);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 266).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 184);
        return this.buildUI(builder, player);
    }

    public Function<String, String> getTextFieldValidator(IntSupplier maxSupplier) {
        int min = 1;
        return val -> {
            int num;
            if (val.isEmpty()) {
                return String.valueOf(min);
            }
            int max = maxSupplier.getAsInt();
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException ignored) {
                return String.valueOf(max);
            }
            if (num < min) {
                return String.valueOf(min);
            }
            if (num > max) {
                return String.valueOf(max);
            }
            return val;
        };
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void readUpdateData(int id, PacketBuffer packetBuffer) {
        super.readUpdateData(id, packetBuffer);
        if (id == 1) {
            this.pumpMode = (PumpMode)packetBuffer.func_179257_a(PumpMode.class);
            this.coverHolder.scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.func_179249_a((Enum)this.pumpMode);
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.pumpMode = (PumpMode)packetBuffer.func_179257_a(PumpMode.class);
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public boolean shouldCoverInteractWithOutputside() {
        return true;
    }

    @Override
    public void onRemoved() {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, (IItemHandlerModifiable)this.fluidFilter.getFilterInventory());
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.coverHolder.getWorld(), (BlockPos)this.coverHolder.getPos(), (ItemStack)itemStack);
        }
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        if (this.pumpMode == PumpMode.EXPORT) {
            Textures.PUMP_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
        } else {
            Textures.PUMP_OVERLAY_INVERTED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (defaultValue == null) {
                return null;
            }
            IFluidHandler delegate = (IFluidHandler)defaultValue;
            if (this.fluidHandlerWrapper == null || this.fluidHandlerWrapper.delegate != delegate) {
                this.fluidHandlerWrapper = new CoverableFluidHandlerWrapper(delegate);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandlerWrapper);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingAllowed;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isWorkingAllowed = isActivationAllowed;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("PumpMode", this.pumpMode.ordinal());
        tagCompound.func_74768_a("DistributionMode", this.distributionMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.isWorkingAllowed);
        tagCompound.func_74768_a("ManualImportExportMode", this.manualImportExportMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.fluidFilter.serializeNBT());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.pumpMode = PumpMode.values()[tagCompound.func_74762_e("PumpMode")];
        this.distributionMode = DistributionMode.values()[tagCompound.func_74762_e("DistributionMode")];
        this.isWorkingAllowed = tagCompound.func_74767_n("WorkingAllowed");
        this.manualImportExportMode = ManualImportExportMode.values()[tagCompound.func_74762_e("ManualImportExportMode")];
        this.fluidFilter.deserializeNBT(tagCompound.func_74775_l("Filter"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[this.tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    private class CoverableFluidHandlerWrapper
    extends FluidHandlerDelegate {
        public CoverableFluidHandlerWrapper(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (CoverPump.this.pumpMode == PumpMode.EXPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return 0;
            }
            if (!CoverPump.this.checkInputFluid(resource) && CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return null;
            }
            if (CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED && !CoverPump.this.checkInputFluid(resource)) {
                return null;
            }
            return super.drain(resource, doDrain);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return null;
            }
            if (CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                FluidStack result = super.drain(maxDrain, false);
                if (result == null || result.amount <= 0 || !CoverPump.this.checkInputFluid(result)) {
                    return null;
                }
                return doDrain ? super.drain(maxDrain, true) : result;
            }
            return super.drain(maxDrain, doDrain);
        }
    }

    public static enum BucketMode implements IStringSerializable
    {
        BUCKET("cover.bucket.mode.bucket"),
        MILLI_BUCKET("cover.bucket.mode.milli_bucket");

        public final String localeName;

        private BucketMode(String localeName) {
            this.localeName = localeName;
        }

        @Nonnull
        public String func_176610_l() {
            return this.localeName;
        }
    }

    public static enum PumpMode implements IStringSerializable,
    IIOMode
    {
        IMPORT("cover.pump.mode.import"),
        EXPORT("cover.pump.mode.export");

        public final String localeName;

        private PumpMode(String localeName) {
            this.localeName = localeName;
        }

        @Nonnull
        public String func_176610_l() {
            return this.localeName;
        }

        @Override
        public boolean isImport() {
            return this == IMPORT;
        }
    }
}

