/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.cover.IFacadeCover;
import gregtech.client.renderer.handler.FacadeRenderer;
import gregtech.common.covers.facade.FacadeHelper;
import gregtech.common.items.behaviors.FacadeItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class CoverFacade
extends CoverBehavior
implements IFacadeCover {
    private ItemStack facadeStack = ItemStack.field_190927_a;
    private IBlockState facadeState = Blocks.field_150348_b.func_176223_P();

    public CoverFacade(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    public void setFacadeStack(ItemStack facadeStack) {
        this.facadeStack = facadeStack.func_77946_l();
        this.updateFacadeState();
    }

    @Override
    public boolean canAttach() {
        return true;
    }

    @Override
    public void onAttached(ItemStack itemStack) {
        super.onAttached(itemStack);
        this.setFacadeStack(FacadeItem.getFacadeStack(itemStack));
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        BlockRenderLayer oldLayer = MinecraftForgeClient.getRenderLayer();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        FacadeRenderer.renderBlockCover(renderState, translation, (IBlockAccess)this.coverHolder.getWorld(), this.coverHolder.getPos(), this.attachedSide.func_176745_a(), this.facadeState, plateBox, layer);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldLayer);
    }

    @Override
    public boolean canRenderInLayer(BlockRenderLayer renderLayer) {
        return true;
    }

    @Override
    public IBlockState getVisualState() {
        return this.facadeState;
    }

    @Override
    public ItemStack getPickItem() {
        ItemStack dropStack = this.getCoverDefinition().getDropItemStack();
        FacadeItem.setFacadeStack(dropStack, this.facadeStack);
        return dropStack;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeShort(Item.func_150891_b((Item)this.facadeStack.func_77973_b()));
        packetBuffer.writeShort(Items.field_151008_G.getDamage(this.facadeStack));
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        Item item = Item.func_150899_d((int)packetBuffer.readShort());
        short itemDamage = packetBuffer.readShort();
        this.facadeStack = new ItemStack(item, 1, (int)itemDamage);
        this.updateFacadeState();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("Facade", (NBTBase)this.facadeStack.func_77955_b(new NBTTagCompound()));
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.facadeStack = new ItemStack(tagCompound.func_74775_l("Facade"));
        this.updateFacadeState();
    }

    @Override
    public boolean canPipePassThrough() {
        return true;
    }

    private void updateFacadeState() {
        this.facadeState = FacadeHelper.lookupBlockForItem(this.facadeStack);
    }

    @Override
    public boolean shouldAutoConnect() {
        return false;
    }

    @Override
    public boolean canRenderBackside() {
        return false;
    }

    @Override
    public void renderCoverPlate(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
    }
}

