/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.block.IStateHarvestLevel;
import gregtech.api.block.VariantBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockSteamCasing
extends VariantBlock<SteamCasingType> {
    public BlockSteamCasing() {
        super(Material.field_151573_f);
        this.func_149663_c("steam_casing");
        this.func_149711_c(4.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.getState(SteamCasingType.BRONZE_HULL));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int ordinal = ((SteamCasingType)this.getState(stack)).ordinal();
        if (ordinal < 2) {
            tooltip.add(I18n.func_135052_a((String)"tile.steam_casing.bronze.tooltip", (Object[])new Object[0]));
        } else if (ordinal < 4) {
            tooltip.add(I18n.func_135052_a((String)"tile.steam_casing.steel.tooltip", (Object[])new Object[0]));
        } else {
            super.func_190948_a(stack, player, tooltip, advanced);
        }
    }

    public static enum SteamCasingType implements IStringSerializable,
    IStateHarvestLevel
    {
        BRONZE_HULL("bronze_hull", 1),
        BRONZE_BRICKS_HULL("bronze_bricks_hull", 1),
        STEEL_HULL("steel_hull", 2),
        STEEL_BRICKS_HULL("steel_bricks_hull", 2),
        PUMP_DECK("pump_deck", 1),
        WOOD_WALL("wood_wall", 0);

        private final String name;
        private final int harvestLevel;

        private SteamCasingType(String name, int harvestLevel) {
            this.name = name;
            this.harvestLevel = harvestLevel;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getHarvestLevel(IBlockState state) {
            return this.harvestLevel;
        }

        @Override
        public String getHarvestTool(IBlockState state) {
            return "wrench";
        }
    }
}

