/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.handler;

import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.ARApplication;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.client.utils.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TerminalARRenderer {
    public static ARApplication APP;
    public static int x;
    public static int y;
    public static int width;
    public static int height;
    public static EnumHand HELD_HAND;

    public static void renderHandEvent(RenderSpecificHandEvent event) {
        if (APP != null && event.getHand() == HELD_HAND) {
            event.setCanceled(true);
        }
    }

    public static void renderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (APP != null && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            int sWidth = event.getResolution().func_78326_a();
            int sHeight = event.getResolution().func_78328_b();
            width = (int)(304.0 * (double)sHeight / 256.0);
            height = (int)(0.8 * (double)sHeight);
            x = (sWidth - width) / 2;
            y = (sHeight - height) / 2;
            GlStateManager.func_179147_l();
            TerminalOSWidget.TERMINAL_FRAME.draw(x, y, width, height);
            GlStateManager.func_179084_k();
        }
    }

    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (APP != null) {
            RenderUtil.useScissor(x, y, width, height, () -> APP.drawARScreen(event));
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AbstractApplication app;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                if (APP != null) {
                    APP.onARClosed();
                    APP = null;
                }
                return;
            }
            HELD_HAND = EnumHand.MAIN_HAND;
            NBTTagCompound tag = player.func_184586_b(EnumHand.MAIN_HAND).func_179543_a("terminal");
            if (tag == null) {
                tag = player.func_184586_b(EnumHand.OFF_HAND).func_179543_a("terminal");
                HELD_HAND = EnumHand.OFF_HAND;
            }
            if (tag != null && tag.func_74764_b("_ar") && (app = TerminalRegistry.getApplication(tag.func_74779_i("_ar"))) instanceof ARApplication) {
                if (APP != app) {
                    if (APP != null) {
                        APP.onARClosed();
                    }
                    APP = (ARApplication)app;
                    APP.setAROpened(player.func_184586_b(HELD_HAND));
                    APP.onAROpened();
                }
                APP.tickAR((EntityPlayer)player);
                return;
            }
            if (APP != null) {
                APP.onARClosed();
                APP = null;
            }
        }
    }
}

