/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import codechicken.lib.vec.Vector3;
import gregtech.client.particle.GTParticle;
import gregtech.client.particle.IGTParticleHandler;
import gregtech.client.renderer.fx.LaserBeamRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GTLaserBeamParticle
extends GTParticle {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private ResourceLocation body;
    private ResourceLocation head;
    private Vector3 direction;
    private float beamHeight = 0.075f;
    private float headWidth;
    private float alpha = 1.0f;
    private float emit;
    private boolean doubleVertical;
    public static IGTParticleHandler HANDLER = new IGTParticleHandler(){
        float lastBrightnessX;
        float lastBrightnessY;

        @Override
        public void preDraw(BufferBuilder buffer) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179129_p();
        }

        @Override
        public void postDraw(BufferBuilder buffer) {
            GlStateManager.func_179089_o();
            GlStateManager.func_179101_C();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    };

    public GTLaserBeamParticle(World worldIn, Vector3 startPos, Vector3 endPos) {
        super(worldIn, startPos.x, startPos.y, startPos.z);
        this.setMotionless(true);
        this.setImmortal();
        this.setRenderRange(64);
        this.direction = endPos.copy().subtract(startPos);
    }

    @Override
    public boolean shouldRendered(Entity entityIn, float partialTicks) {
        if (this.squareRenderRange < 0) {
            return true;
        }
        Vec3d eyePos = entityIn.func_174824_e(partialTicks);
        return eyePos.func_186679_c(this.field_187126_f, this.field_187127_g, this.field_187128_h) <= (double)this.squareRenderRange || eyePos.func_186679_c(this.field_187126_f + this.direction.x, this.field_187127_g + this.direction.y, this.field_187128_h + this.direction.z) <= (double)this.squareRenderRange;
    }

    public GTLaserBeamParticle setBody(ResourceLocation body) {
        this.body = body;
        return this;
    }

    public GTLaserBeamParticle setHead(ResourceLocation head) {
        this.head = head;
        return this;
    }

    public GTLaserBeamParticle setStartPos(Vector3 startPos) {
        this.direction.add(this.field_187126_f, this.field_187127_g, this.field_187128_h).subtract(startPos);
        return this;
    }

    public GTLaserBeamParticle setEndPos(Vector3 endPos) {
        this.direction = endPos.copy().subtract(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        return this;
    }

    public GTLaserBeamParticle setBeamHeight(float beamHeight) {
        this.beamHeight = beamHeight;
        return this;
    }

    public GTLaserBeamParticle setHeadWidth(float headWidth) {
        this.headWidth = headWidth;
        return this;
    }

    public GTLaserBeamParticle setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public GTLaserBeamParticle setEmit(float emit) {
        this.emit = emit;
        return this;
    }

    public GTLaserBeamParticle setDoubleVertical(boolean doubleVertical) {
        this.doubleVertical = doubleVertical;
        return this;
    }

    public boolean func_187111_c() {
        return true;
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GlStateManager.func_179137_b((double)(this.field_187126_f - field_70556_an), (double)(this.field_187127_g - field_70554_ao), (double)(this.field_187128_h - field_70555_ap));
        Vector3 cameraDirection = null;
        if (!this.doubleVertical) {
            cameraDirection = new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h).subtract(new Vector3(entityIn.func_174824_e(partialTicks)));
        }
        TextureManager renderEngine = GTLaserBeamParticle.MINECRAFT.func_175598_ae().field_78724_e;
        ITextureObject bodyTexture = null;
        if (this.body != null && (bodyTexture = renderEngine.func_110581_b(this.body)) == null) {
            bodyTexture = new SimpleTexture(this.body);
            renderEngine.func_110579_a(this.body, bodyTexture);
        }
        ITextureObject headTexture = null;
        if (this.head != null && (headTexture = renderEngine.func_110581_b(this.head)) == null) {
            headTexture = new SimpleTexture(this.head);
            renderEngine.func_110579_a(this.head, headTexture);
        }
        float offset = -this.emit * ((float)GTLaserBeamParticle.MINECRAFT.field_71439_g.field_70173_aa + partialTicks);
        LaserBeamRenderer.renderRawBeam(bodyTexture == null ? -1 : bodyTexture.func_110552_b(), headTexture == null ? -1 : headTexture.func_110552_b(), this.direction, cameraDirection, this.beamHeight, this.headWidth, this.alpha, offset);
        GlStateManager.func_179137_b((double)(field_70556_an - this.field_187126_f), (double)(field_70554_ao - this.field_187127_g), (double)(field_70555_ap - this.field_187128_h));
    }

    @Override
    public IGTParticleHandler getGLHandler() {
        return HANDLER;
    }
}

