/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.modelfactories;

import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.StoneType;
import gregtech.client.model.ModelFactory;
import gregtech.client.model.customtexture.CustomTexture;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.blocks.BlockOre;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class OreBakedModel
implements IBakedModel {
    private static IBakedModel model;
    private final Map<StoneType, TextureAtlasSprite> stoneTypeModels = new Object2ObjectOpenHashMap();
    private final Table<StoneType, EnumFacing, BakedQuad> cacheBottom = Tables.newCustomTable((Map)Maps.newHashMap(), () -> Maps.newEnumMap(EnumFacing.class));
    private final Table<MaterialIconSet, EnumFacing, BakedQuad[]> cacheTop = Tables.newCustomTable((Map)Maps.newHashMap(), () -> Maps.newEnumMap(EnumFacing.class));
    private final ThreadLocal<TextureAtlasSprite> particle = ThreadLocal.withInitial(() -> Minecraft.func_71410_x().func_147117_R().func_174944_f());

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state != null) {
            BakedQuad[] bakedQuads;
            BlockOre ore = (BlockOre)state.func_177230_c();
            StoneType stoneType = (StoneType)state.func_177229_b((IProperty)ore.STONE_TYPE);
            MaterialIconSet materialIconSet = ore.field_149764_J.getMaterialIconSet();
            TextureAtlasSprite textureAtlasSprite = this.stoneTypeModels.computeIfAbsent(stoneType, type -> Minecraft.func_71410_x().field_175618_aM.func_184389_a(type.stone.get()).func_177554_e());
            this.particle.set(textureAtlasSprite);
            if (model == null) {
                model = new ModelFactory(ModelFactory.ModelTemplate.CUBE_2_LAYER_ALL_TINT_INDEX).bake();
            }
            BakedQuad bakedQuad = (BakedQuad)this.cacheBottom.get((Object)stoneType, (Object)side);
            if (side == null) {
                return Collections.emptyList();
            }
            if (bakedQuad == null) {
                bakedQuad = new BakedQuadRetextured((BakedQuad)model.func_188616_a(state, side, rand).get(0), textureAtlasSprite);
                this.cacheBottom.put((Object)stoneType, (Object)side, (Object)bakedQuad);
            }
            if ((bakedQuads = (BakedQuad[])this.cacheTop.get((Object)materialIconSet, (Object)side)) == null) {
                bakedQuads = new BakedQuad[]{new BakedQuadRetextured((BakedQuad)model.func_188616_a(state, side, rand).get(1), (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(MaterialIconType.ore.getBlockTexturePath(materialIconSet))), CustomTexture.rebake(15, 15, bakedQuads[0])};
                this.cacheTop.put((Object)materialIconSet, (Object)side, (Object)bakedQuads);
            }
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            boolean hasEmissive = ore.field_149764_J.getProperty(PropertyKey.ORE).isEmissive();
            boolean isEmissiveLayer = hasEmissive && (layer == BloomEffectUtil.getRealBloomLayer() || layer == null);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (!hasEmissive || !isEmissiveLayer || layer == null) {
                quads.add(bakedQuad);
            }
            if (hasEmissive && isEmissiveLayer) {
                quads.add(bakedQuads[1]);
            } else {
                quads.add(bakedQuads[0]);
            }
            return quads;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        ItemStack stack = (ItemStack)OreItemOverride.INSTANCE.stack.get();
        if (!stack.func_190926_b()) {
            BlockOre ore = (BlockOre)((ItemBlock)stack.func_77973_b()).func_179223_d();
            IBlockState oreState = ore.func_176223_P().func_177226_a((IProperty)ore.STONE_TYPE, (Comparable)ore.STONE_TYPE.getAllowedValues().get(stack.func_77960_j()));
            for (EnumFacing face : EnumFacing.field_82609_l) {
                quads.addAll(this.func_188616_a(oreState, face, rand));
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle.get();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation blockTransform = ModelFactory.getBlockTransform(cameraTransformType);
        return blockTransform == null ? super.handlePerspective(cameraTransformType) : Pair.of((Object)this, (Object)blockTransform.getMatrix());
    }

    public ItemOverrideList func_188617_f() {
        return OreItemOverride.INSTANCE;
    }

    private static class OreItemOverride
    extends ItemOverrideList {
        private static final OreItemOverride INSTANCE = new OreItemOverride();
        private final ThreadLocal<ItemStack> stack = ThreadLocal.withInitial(() -> ItemStack.field_190927_a);

        private OreItemOverride() {
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            this.stack.set(stack);
            return originalModel;
        }
    }
}

