/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.modelfactories;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.client.model.ModelFactory;
import gregtech.common.blocks.BlockCompressed;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class CompressedBlockBakedModel
implements IBakedModel {
    private final Map<MaterialIconSet, Map<EnumFacing, BakedQuad>> materialFaces = new Object2ObjectOpenHashMap();
    private final ThreadLocal<TextureAtlasSprite> particle = ThreadLocal.withInitial(() -> Minecraft.func_71410_x().func_147117_R().func_174944_f());

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side == null) {
            return quads;
        }
        if (state != null) {
            BakedQuad materialFaceQuad;
            Material material = (Material)state.func_177229_b((IProperty)((BlockCompressed)state.func_177230_c()).variantProperty);
            Object2ObjectOpenHashMap materialFace = this.materialFaces.get(material.getMaterialIconSet());
            if (materialFace == null) {
                materialFace = new Object2ObjectOpenHashMap();
                this.materialFaces.put(material.getMaterialIconSet(), (Map<EnumFacing, BakedQuad>)materialFace);
            }
            if ((materialFaceQuad = materialFace.get(side)) == null) {
                materialFaceQuad = ModelFactory.getBakery().func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), new BlockPartFace(side, 1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.0f, 16.0f, 16.0f}, 0)), (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(MaterialIconType.block.getBlockTexturePath(material.getMaterialIconSet())), side, ModelRotation.X0_Y0, null, true, true);
                materialFace.put(side, materialFaceQuad);
            }
            quads.add(materialFaceQuad);
            this.particle.set(materialFaceQuad.func_187508_a());
        } else {
            ItemStack stack = (ItemStack)CompressedBlockItemOverride.INSTANCE.stack.get();
            if (!stack.func_190926_b()) {
                BlockCompressed compressed = (BlockCompressed)((ItemBlock)stack.func_77973_b()).func_179223_d();
                IBlockState compressedState = compressed.func_176223_P().func_177226_a((IProperty)compressed.variantProperty, (Comparable)compressed.variantProperty.getAllowedValues().get(stack.func_77960_j()));
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    quads.addAll(this.func_188616_a(compressedState, face, rand));
                }
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle.get();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation blockTransform = ModelFactory.getBlockTransform(cameraTransformType);
        return blockTransform == null ? super.handlePerspective(cameraTransformType) : Pair.of((Object)this, (Object)blockTransform.getMatrix());
    }

    public ItemOverrideList func_188617_f() {
        return CompressedBlockItemOverride.INSTANCE;
    }

    private static class CompressedBlockItemOverride
    extends ItemOverrideList {
        private static final CompressedBlockItemOverride INSTANCE = new CompressedBlockItemOverride();
        private final ThreadLocal<ItemStack> stack = ThreadLocal.withInitial(() -> ItemStack.field_190927_a);

        private CompressedBlockItemOverride() {
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            this.stack.set(stack);
            return originalModel;
        }
    }
}

