/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import codechicken.lib.texture.TextureUtils;
import gregtech.api.fluids.MetaFluids;
import gregtech.api.items.metaitem.MetaOreDictItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.IBlockOre;
import gregtech.api.util.ModCompatibility;
import gregtech.client.model.customtexture.CustomTextureModelHandler;
import gregtech.client.model.customtexture.MetadataSectionCTM;
import gregtech.client.renderer.handler.FacadeRenderer;
import gregtech.client.renderer.handler.MetaTileEntityRenderer;
import gregtech.client.renderer.pipe.CableRenderer;
import gregtech.client.renderer.pipe.FluidPipeRenderer;
import gregtech.client.renderer.pipe.ItemPipeRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.CommonProxy;
import gregtech.common.ConfigHolder;
import gregtech.common.MetaEntities;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.BlockSurfaceRock;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ColorizerFoliage;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final IBlockColor COMPRESSED_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> ((Material)state.func_177229_b((IProperty)((BlockCompressed)state.func_177230_c()).variantProperty)).getMaterialRGB();
    public static final IItemColor COMPRESSED_ITEM_COLOR = (stack, tintIndex) -> {
        BlockCompressed block = (BlockCompressed)((ItemBlock)stack.func_77973_b()).func_179223_d();
        IBlockState state = block.func_176203_a(stack.func_77952_i());
        return ((Material)state.func_177229_b((IProperty)block.variantProperty)).getMaterialRGB();
    };
    public static final IBlockColor FRAME_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> ((Material)state.func_177229_b((IProperty)((BlockFrame)state.func_177230_c()).variantProperty)).getMaterialRGB();
    public static final IItemColor FRAME_ITEM_COLOR = (stack, tintIndex) -> {
        BlockFrame block = (BlockFrame)((ItemBlock)stack.func_77973_b()).func_179223_d();
        IBlockState state = block.func_176203_a(stack.func_77952_i());
        return ((Material)state.func_177229_b((IProperty)block.variantProperty)).getMaterialRGB();
    };
    public static final IBlockColor ORE_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> tintIndex == 1 ? ((BlockOre)state.func_177230_c()).field_149764_J.getMaterialRGB() : 0xFFFFFF;
    public static final IItemColor ORE_ITEM_COLOR = (stack, tintIndex) -> tintIndex == 1 ? ((BlockOre)((ItemBlock)stack.func_77973_b()).func_179223_d()).field_149764_J.getMaterialRGB() : 0xFFFFFF;
    public static final IBlockColor FOAM_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).field_193351_w;
    public static final IBlockColor SURFACE_ROCK_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> tintIndex == 1 ? ((Material)state.func_177229_b((IProperty)((BlockSurfaceRock)state.func_177230_c()).variantProperty)).getMaterialRGB() : -1;
    public static final IBlockColor RUBBER_LEAVES_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> ColorizerFoliage.func_77469_b();
    public static final IItemColor RUBBER_LEAVES_ITEM_COLOR = (stack, tintIndex) -> ColorizerFoliage.func_77469_b();
    public static final IBlockColor MACHINE_CASING_BLOCK_COLOR = (state, world, pos, tintIndex) -> state.func_177230_c() instanceof BlockMachineCasing && MetaBlocks.MACHINE_CASING.func_176201_c(state) == 0 ? 0xFFFFFF : ConfigHolder.client.defaultPaintingColor;
    public static final IItemColor MACHINE_CASING_ITEM_COLOR = (stack, tintIndex) -> stack.func_77952_i() == 0 && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockMachineCasing ? 0xFFFFFF : ConfigHolder.client.defaultPaintingColor;
    private static final String[] clearRecipes = new String[]{"quantum_tank", "quantum_chest", "super_chest", "super_tank", "drum.", "_tank", "fluid_cell"};

    @Override
    public void onPreLoad() {
        super.onPreLoad();
        SoundSystemConfig.setNumberNormalChannels((int)ConfigHolder.client.maxNumSounds);
        if (!Loader.isModLoaded((String)"ctm")) {
            Minecraft.func_71410_x().field_110452_an.func_110504_a((IMetadataSectionSerializer)new MetadataSectionCTM.Serializer(), MetadataSectionCTM.class);
            MinecraftForge.EVENT_BUS.register((Object)CustomTextureModelHandler.INSTANCE);
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)CustomTextureModelHandler.INSTANCE);
        }
        MetaTileEntityRenderer.preInit();
        CableRenderer.INSTANCE.preInit();
        FluidPipeRenderer.INSTANCE.preInit();
        ItemPipeRenderer.INSTANCE.preInit();
        MetaEntities.initRenderers();
        MetaFluids.initIconFluidSprites();
        TextureUtils.addIconRegister(MetaFluids::registerSprites);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.registerColors();
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        TerminalRegistry.initTerminalFiles();
        ModCompatibility.initCompat();
        FacadeRenderer.init();
    }

    public void registerColors() {
        MetaBlocks.registerColors();
        MetaItems.registerColors();
        ToolItems.registerColors();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        MetaBlocks.registerStateMappers();
        MetaBlocks.registerItemModels();
        MetaItems.registerModels();
        ToolItems.registerModels();
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Pre event) {
        for (MaterialIconSet set : MaterialIconSet.ICON_SETS.values()) {
            event.getMap().func_174942_a(MaterialIconType.ore.getBlockTexturePath(set));
            event.getMap().func_174942_a(MaterialIconType.block.getBlockTexturePath(set));
        }
        MetaBlocks.COMPRESSED.values().stream().distinct().forEach(c -> c.onTextureStitch(event));
        MetaBlocks.FRAMES.values().stream().distinct().forEach(f -> f.onTextureStitch(event));
        MetaBlocks.ORES.forEach(o -> o.onTextureStitch(event));
    }

    @SubscribeEvent
    public static void addMaterialFormulaHandler(@Nonnull ItemTooltipEvent event) {
        Block block;
        ItemStack itemStack = event.getItemStack();
        if (!(!(itemStack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d()) instanceof BlockFrame || block instanceof BlockCompressed || block instanceof IBlockOre || block instanceof IFluidBlock)) {
            return;
        }
        List<Object> tooltips = new ArrayList();
        UnificationEntry unificationEntry = OreDictUnifier.getUnificationEntry(itemStack);
        if (itemStack.func_77973_b() instanceof MetaOreDictItem) {
            MetaOreDictItem oreDictItem = (MetaOreDictItem)itemStack.func_77973_b();
            Optional optional = OreDictUnifier.getOreDictionaryNames(itemStack).stream().findFirst();
            if (optional.isPresent() && oreDictItem.OREDICT_TO_FORMULA.containsKey(optional.get()) && !oreDictItem.OREDICT_TO_FORMULA.get(optional.get()).isEmpty()) {
                tooltips.add(TextFormatting.YELLOW + oreDictItem.OREDICT_TO_FORMULA.get(optional.get()));
            }
        } else if (unificationEntry != null && unificationEntry.material != null) {
            if (unificationEntry.material.getChemicalFormula() != null && !unificationEntry.material.getChemicalFormula().isEmpty()) {
                tooltips.add(TextFormatting.YELLOW + unificationEntry.material.getChemicalFormula());
            }
        } else if (itemStack.func_77942_o()) {
            NBTTagCompound compound;
            tooltips = FluidTooltipUtil.getFluidTooltip(itemStack.func_77978_p().func_74779_i("FluidName"));
            if ((tooltips == null || tooltips.size() == 0) && (compound = itemStack.func_77978_p()) != null && compound.func_150297_b("Fluid", 10)) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Fluid"));
                tooltips = FluidTooltipUtil.getFluidTooltip(fluidStack);
            }
        } else if (itemStack.func_77973_b().equals(Items.field_151131_as)) {
            tooltips = FluidTooltipUtil.getWaterTooltip();
        } else if (itemStack.func_77973_b().equals(Items.field_151129_at)) {
            tooltips = FluidTooltipUtil.getLavaTooltip();
        }
        if (tooltips != null) {
            for (String string : tooltips) {
                if (string == null || string.isEmpty()) continue;
                event.getToolTip().add(string);
            }
        }
    }

    @SubscribeEvent
    public static void addNBTClearingTooltip(ItemTooltipEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null) {
            ItemStack stackResult;
            InventoryCrafting inv = null;
            InventoryCraftResult result = null;
            if (player.field_71070_bA instanceof ContainerWorkbench) {
                inv = ((ContainerWorkbench)player.field_71070_bA).field_75162_e;
                result = ((ContainerWorkbench)player.field_71070_bA).field_75160_f;
            } else if (player.field_71070_bA instanceof ContainerPlayer) {
                inv = ((ContainerPlayer)player.field_71070_bA).field_75181_e;
                result = ((ContainerPlayer)player.field_71070_bA).field_75179_f;
            }
            if (inv != null && (stackResult = result.func_70301_a(0)) == event.getItemStack() && !stackResult.func_190926_b() && ItemStack.func_179545_c((ItemStack)stackResult, (ItemStack)event.getItemStack())) {
                String unlocalizedName = stackResult.func_77977_a();
                String namespace = stackResult.func_77973_b().getRegistryName().func_110624_b();
                for (String key : clearRecipes) {
                    if (!unlocalizedName.contains(key) || !namespace.equals("gregtech")) continue;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack craftStack = inv.func_70301_a(i);
                        if (craftStack.func_190926_b() || craftStack.func_77969_a(stackResult) && craftStack.func_77942_o()) continue;
                        return;
                    }
                    event.getToolTip().add(I18n.func_135052_a((String)"gregtech.universal.clear_nbt_recipe.tooltip", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void cleanupDebugTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        boolean isAdvanced = event.getFlags().func_194127_a();
        List tooltip = event.getToolTip();
        if (isAdvanced) {
            if (stack.func_77973_b() instanceof IGTTool) {
                tooltip.remove(I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()}));
                tooltip.remove(net.minecraft.util.text.translation.I18n.func_74838_a((String)"endercore.tooltip.durability") + " " + (stack.func_77958_k() - stack.func_77952_i()) + "/" + stack.func_77958_k());
            }
            String nbtTags = null;
            String registryName = null;
            if (stack.func_77978_p() != null) {
                nbtTags = TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"item.nbt_tags", (Object[])new Object[]{stack.func_77978_p().func_150296_c().size()});
                tooltip.remove(nbtTags);
            }
            if (stack.func_77973_b().getRegistryName() != null) {
                registryName = TextFormatting.DARK_GRAY + stack.func_77973_b().getRegistryName().toString();
                tooltip.remove(registryName);
                tooltip.remove(stack.func_77973_b().getRegistryName().toString());
            }
            if (ClientProxy.hasActuallyAdvancedInfo(tooltip)) {
                int[] oreIds;
                if (TooltipHelper.isShiftDown() && (oreIds = OreDictionary.getOreIDs((ItemStack)event.getItemStack())).length > 0) {
                    tooltip.remove(net.minecraft.util.text.translation.I18n.func_74838_a((String)"endercore.tooltip.oreDictNames"));
                    for (int i : oreIds) {
                        tooltip.remove("  - " + OreDictionary.getOreName((int)i));
                    }
                }
            } else {
                if (nbtTags != null) {
                    tooltip.add(nbtTags);
                }
                if (registryName != null) {
                    tooltip.add(registryName);
                }
            }
        }
    }

    private static boolean hasActuallyAdvancedInfo(List<String> tooltip) {
        if (tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.actuallyadditions.extraInfo.desc", (Object[])new Object[0]) + ":")) {
            return true;
        }
        if (tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.actuallyadditions.ctrlForMoreInfo.desc", (Object[])new Object[0]))) {
            return true;
        }
        if (tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Advanced Info:")) {
            return true;
        }
        return tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Press CTRL for Advanced Info");
    }

    @Override
    public boolean isFancyGraphics() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }
}

