/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.hooks;

import com.google.common.collect.Lists;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ToolHelper;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class RecipeRepairItemHooks {
    public static boolean matches(InventoryCrafting inv) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack = (ItemStack)list.get(0);
            if (!stack.func_77973_b().isRepairable()) {
                return false;
            }
            if (stack.func_190916_E() != 1 || itemstack.func_190916_E() != 1) {
                return false;
            }
            if (itemstack.func_77973_b() != stack.func_77973_b()) {
                return false;
            }
            if (!(itemstack.func_77973_b() instanceof IGTTool) || !(stack.func_77973_b() instanceof IGTTool)) continue;
            IGTTool first = (IGTTool)itemstack.func_77973_b();
            IGTTool second = (IGTTool)stack.func_77973_b();
            if (first.isElectric() || second.isElectric()) {
                return false;
            }
            return first.getToolMaterial(itemstack) == second.getToolMaterial(stack);
        }
        return list.size() == 2;
    }

    public static ItemStack getCraftingResult(InventoryCrafting inv) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack = (ItemStack)list.get(0);
            if (itemstack.func_77973_b() != stack.func_77973_b()) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() != 1 || itemstack.func_190916_E() != 1) {
                return ItemStack.field_190927_a;
            }
            if (!stack.func_77973_b().isRepairable()) {
                return ItemStack.field_190927_a;
            }
            if (itemstack.func_77973_b() instanceof IGTTool && ((IGTTool)itemstack.func_77973_b()).isElectric()) {
                return ItemStack.field_190927_a;
            }
            if (!(stack.func_77973_b() instanceof IGTTool) || !((IGTTool)stack.func_77973_b()).isElectric()) continue;
            return ItemStack.field_190927_a;
        }
        if (list.size() == 2) {
            ItemStack first = (ItemStack)list.get(0);
            ItemStack second = (ItemStack)list.get(1);
            if (first.func_77973_b() == second.func_77973_b() && first.func_190916_E() == 1 && second.func_190916_E() == 1 && first.func_77973_b().isRepairable()) {
                int j = first.func_77958_k() - first.func_77952_i();
                int k = first.func_77958_k() - second.func_77952_i();
                int l = j + k + first.func_77958_k() * 5 / 100;
                int i1 = first.func_77958_k() - l;
                if (i1 < 0) {
                    i1 = 0;
                }
                if (first.func_77973_b() instanceof IGTTool && second.func_77973_b() instanceof IGTTool) {
                    IGTTool tool = (IGTTool)first.func_77973_b();
                    ItemStack output = tool.get(tool.getToolMaterial(first));
                    NBTTagCompound outputTag = ToolHelper.getToolTag(output);
                    outputTag.func_74768_a("Durability", i1);
                    return output;
                }
                return new ItemStack(first.func_77973_b(), 1, i1);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof IGTTool) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)ForgeHooks.getCraftingPlayer(), (ItemStack)stack, null);
                continue;
            }
            list.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return list;
    }
}

