/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.NotifiableFluidTankFromList;
import gregtech.api.recipes.FluidKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class OverlayedFluidHandler {
    private final OverlayedTank[] overlayedTanks;
    private final OverlayedTank[] originalTanks;
    private final IMultipleTankHandler overlayed;
    private boolean allowSameFluidFill = true;
    private final ObjectOpenHashSet<IFluidTankProperties> tankDeniesSameFluidFill = new ObjectOpenHashSet();
    private final Map<IMultipleTankHandler, ObjectOpenHashSet<FluidKey>> uniqueFluidMap = new Object2ObjectOpenHashMap();

    public OverlayedFluidHandler(IMultipleTankHandler toOverlay) {
        this.overlayedTanks = new OverlayedTank[toOverlay.getTankProperties().length];
        this.originalTanks = new OverlayedTank[toOverlay.getTankProperties().length];
        this.overlayed = toOverlay;
    }

    public void reset() {
        for (int i = 0; i < this.originalTanks.length; ++i) {
            if (this.originalTanks[i] == null) continue;
            this.overlayedTanks[i] = this.originalTanks[i].copy();
        }
        this.uniqueFluidMap.forEach((k, v) -> v.clear());
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.overlayed.getTankProperties();
    }

    private void initTank(int tank) {
        if (this.overlayedTanks[tank] == null) {
            IFluidTankProperties fluidTankProperties = this.overlayed.getTankProperties()[tank];
            this.originalTanks[tank] = new OverlayedTank(fluidTankProperties);
            this.overlayedTanks[tank] = new OverlayedTank(fluidTankProperties);
            if (!this.overlayed.allowSameFluidFill()) {
                this.allowSameFluidFill = false;
            }
            if (this.overlayed.getTankAt(tank) instanceof NotifiableFluidTankFromList) {
                NotifiableFluidTankFromList nftfl = (NotifiableFluidTankFromList)this.overlayed.getTankAt(tank);
                if (!nftfl.getFluidTankList().get().allowSameFluidFill()) {
                    this.tankDeniesSameFluidFill.add((Object)this.overlayed.getTankProperties()[tank]);
                    this.uniqueFluidMap.computeIfAbsent(nftfl.getFluidTankList().get(), list -> new ObjectOpenHashSet());
                }
            } else if (!this.allowSameFluidFill) {
                this.uniqueFluidMap.computeIfAbsent(this.overlayed, list -> new ObjectOpenHashSet());
            }
        }
    }

    public int insertStackedFluidKey(@Nonnull FluidKey toInsert, int amountToInsert) {
        int i;
        int insertedAmount = 0;
        for (i = 0; i < this.overlayedTanks.length; ++i) {
            NotifiableFluidTankFromList nftfl;
            this.initTank(i);
            OverlayedTank overlayedTank = this.overlayedTanks[i];
            if (!toInsert.equals(overlayedTank.getFluidKey()) || (!this.allowSameFluidFill || this.tankDeniesSameFluidFill.contains((Object)this.overlayed.getTankProperties()[i])) && (!(this.overlayed.getTankAt(i) instanceof NotifiableFluidTankFromList) ? !this.uniqueFluidMap.get(this.overlayed).add((Object)toInsert) : !this.uniqueFluidMap.get((nftfl = (NotifiableFluidTankFromList)this.overlayed.getTankAt(i)).getFluidTankList().get()).add((Object)toInsert))) continue;
            int spaceInTank = overlayedTank.getCapacity() - overlayedTank.getFluidAmount();
            int canInsertUpTo = Math.min(spaceInTank, amountToInsert);
            if (canInsertUpTo > 0) {
                insertedAmount += canInsertUpTo;
                overlayedTank.setFluidKey(toInsert);
                overlayedTank.setFluidAmount(overlayedTank.getFluidAmount() + canInsertUpTo);
                amountToInsert -= canInsertUpTo;
            }
            if (amountToInsert != 0) continue;
            return insertedAmount;
        }
        if (amountToInsert > 0) {
            int tanksLength = this.overlayedTanks.length;
            for (i = 0; i < tanksLength; ++i) {
                NotifiableFluidTankFromList nftfl;
                IMultipleTankHandler mth;
                OverlayedTank overlayedTank = this.overlayedTanks[i];
                if (overlayedTank.getFluidKey() != null || (!this.allowSameFluidFill || this.tankDeniesSameFluidFill.contains((Object)this.overlayed.getTankProperties()[i])) && (!((mth = this.overlayed).getTankAt(i) instanceof NotifiableFluidTankFromList) ? !this.uniqueFluidMap.get(mth).add((Object)toInsert) : !this.uniqueFluidMap.get((nftfl = (NotifiableFluidTankFromList)mth.getTankAt(i)).getFluidTankList().get()).add((Object)toInsert)) || !this.overlayed.getTankProperties()[i].canFillFluidType(new FluidStack(toInsert.getFluid(), amountToInsert))) continue;
                int canInsertUpTo = Math.min(overlayedTank.getCapacity(), amountToInsert);
                if (canInsertUpTo > 0) {
                    insertedAmount += canInsertUpTo;
                    overlayedTank.setFluidKey(toInsert);
                    overlayedTank.setFluidAmount(canInsertUpTo);
                    amountToInsert -= canInsertUpTo;
                }
                if (amountToInsert != 0) continue;
                return insertedAmount;
            }
        }
        return insertedAmount;
    }

    private static class OverlayedTank {
        private FluidKey fluidKey = null;
        private int fluidAmount = 0;
        private int capacity = 0;

        OverlayedTank(IFluidTankProperties property) {
            FluidStack stackToMirror = property.getContents();
            if (stackToMirror != null) {
                this.fluidKey = new FluidKey(stackToMirror);
                this.fluidAmount = stackToMirror.amount;
            }
            this.capacity = property.getCapacity();
        }

        OverlayedTank(FluidKey fluidKey, int fluidAmount, int capacity) {
            this.fluidKey = fluidKey;
            this.fluidAmount = fluidAmount;
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getFluidAmount() {
            return this.fluidAmount;
        }

        public FluidKey getFluidKey() {
            return this.fluidKey;
        }

        public void setFluidKey(FluidKey fluidKey) {
            this.fluidKey = fluidKey;
        }

        public void setFluidAmount(int fluidAmount) {
            this.fluidAmount = fluidAmount;
        }

        public OverlayedTank copy() {
            return new OverlayedTank(this.fluidKey, this.fluidAmount, this.capacity);
        }
    }
}

