/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleGeneratorMetaTileEntity;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTLog;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GTUtility {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final DecimalFormat TWO_PLACES_FORMAT = new DecimalFormat("#.##");
    private static TreeMap<Integer, String> romanNumeralConversions = new TreeMap();
    private static final NavigableMap<Long, Byte> tierByVoltage = new TreeMap<Long, Byte>();
    private static final Pattern UNDERSCORE_TO_SPACE;
    public static final Function<Integer, Integer> defaultTankSizeFunction;
    public static final Function<Integer, Integer> hvCappedTankSizeFunction;
    public static final Function<Integer, Integer> largeTankSizeFunction;
    public static final Function<Integer, Integer> steamGeneratorTankSizeFunction;
    public static final Function<Integer, Integer> genericGeneratorTankSizeFunction;

    public static Runnable combine(Runnable ... runnables) {
        return () -> {
            for (Runnable runnable : runnables) {
                if (runnable == null) continue;
                runnable.run();
            }
        };
    }

    public static Stream<Object> flatten(Object[] array) {
        return Arrays.stream(array).flatMap(o -> o instanceof Object[] ? GTUtility.flatten((Object[])o) : Stream.of(o));
    }

    public static void copyInventoryItems(IItemHandler src, IItemHandlerModifiable dest) {
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack itemStack = src.getStackInSlot(i);
            dest.setStackInSlot(i, itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l());
        }
    }

    public static <T> IntStream indices(T[] array) {
        int[] indices = new int[array.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return Arrays.stream(indices);
    }

    public static <T> String[] mapToString(T[] array, Function<T, String> mapper) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, Class<R> declaringClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        while (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != declaringClass) {
            if (type instanceof ParameterizedType) {
                type = ((Class)((ParameterizedType)type).getRawType()).getGenericSuperclass();
                continue;
            }
            type = ((Class)type).getGenericSuperclass();
        }
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static PotionEffect copyPotionEffect(PotionEffect sample) {
        PotionEffect potionEffect = new PotionEffect(sample.func_188419_a(), sample.func_76459_b(), sample.func_76458_c(), sample.func_82720_e(), sample.func_188418_e());
        potionEffect.setCurativeItems(sample.getCurativeItems());
        return potionEffect;
    }

    public static int convertRGBtoOpaqueRGBA_CL(int colorValue) {
        return GTUtility.convertRGBtoRGBA_CL(colorValue, 255);
    }

    public static int convertRGBtoRGBA_CL(int colorValue, int opacity) {
        return colorValue << 8 | opacity & 0xFF;
    }

    public static int convertOpaqueRGBA_CLtoRGB(int colorAlpha) {
        return colorAlpha >>> 8;
    }

    public static int convertRGBtoOpaqueRGBA_MC(int colorValue) {
        return GTUtility.convertRGBtoOpaqueRGBA_MC(colorValue, 255);
    }

    public static int convertRGBtoOpaqueRGBA_MC(int colorValue, int opacity) {
        return opacity << 24 | colorValue;
    }

    public static int convertOpaqueRGBA_MCtoRGB(int alphaColor) {
        return alphaColor & 0xFFFFFF;
    }

    public static int getActualItemDamageFromStack(ItemStack itemStack) {
        return Items.field_151008_G.getDamage(itemStack);
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots, boolean simulate) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.func_75214_a(itemStack) || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.func_77976_d(), slot.func_178170_b(stackInSlot));
            int amountToInsert = Math.min(itemStack.func_190916_E(), slotMaxStackSize - stackInSlot.func_190916_E());
            if (amountToInsert <= 0) continue;
            if (!simulate) {
                stackInSlot.func_190917_f(amountToInsert);
            }
            itemStack.func_190918_g(amountToInsert);
            slot.func_75218_e();
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.func_75214_a(itemStack) || slot.func_75216_d() || (amountToInsert = Math.min(itemStack.func_190916_E(), slot.func_178170_b(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.func_77979_a(amountToInsert);
            if (!simulate) {
                slot.func_75215_d(stackInSlot);
            }
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        return merged;
    }

    public static List<ItemStack> addStackToItemStackList(ItemStack stackToAdd, List<ItemStack> itemStackList) {
        if (!itemStackList.isEmpty()) {
            for (int i = 0; i < itemStackList.size(); ++i) {
                ItemStack stackInList = itemStackList.get(i);
                if (!ItemStackHashStrategy.comparingAllButCount().equals(stackInList, stackToAdd) || stackInList.func_190916_E() >= stackInList.func_77976_d()) continue;
                int insertable = stackInList.func_77976_d() - stackInList.func_190916_E();
                if (insertable >= stackToAdd.func_190916_E()) {
                    stackInList.func_190917_f(stackToAdd.func_190916_E());
                    stackToAdd = ItemStack.field_190927_a;
                } else {
                    stackInList.func_190917_f(insertable);
                    stackToAdd = stackToAdd.func_77946_l();
                    stackToAdd.func_190920_e(stackToAdd.func_190916_E() - insertable);
                }
                if (stackToAdd.func_190926_b()) break;
            }
            if (!stackToAdd.func_190926_b()) {
                itemStackList.add(stackToAdd);
            }
        } else {
            itemStackList.add(stackToAdd.func_77946_l());
        }
        return itemStackList;
    }

    public static boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState blockState = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos)) {
            return false;
        }
        if (!blockState.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player)) {
            return false;
        }
        int expToDrop = 0;
        if (!world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            expToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
            if (expToDrop == -1) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                return false;
            }
        }
        world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)blockState));
        boolean wasRemovedByPlayer = blockState.func_177230_c().removedByPlayer(blockState, world, pos, player, !player.field_71075_bZ.field_75098_d);
        if (wasRemovedByPlayer) {
            blockState.func_177230_c().func_176206_d(world, pos, blockState);
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemStack stackInHand = player.func_184614_ca();
                blockState.func_177230_c().func_180657_a(world, player, pos, blockState, tileEntity, stackInHand);
                if (expToDrop > 0) {
                    blockState.func_177230_c().func_180637_b(world, pos, expToDrop);
                }
            }
        }
        if (!world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, mc.field_71476_x.field_178784_b));
        }
        return wasRemovedByPlayer;
    }

    public static void writeItems(IItemHandler handler, String tagName, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a("Slot", i);
            handler.getStackInSlot(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, String tagName, NBTTagCompound tag) {
        if (tag.func_74764_b(tagName)) {
            NBTTagList tagList = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e("Slot");
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, new ItemStack(tagList.func_150305_b(i)));
            }
        }
    }

    public static boolean isBetweenInclusive(long start, long end, long value) {
        return start <= value && value <= end;
    }

    public static String capitalizeString(String string) {
        if (string != null && string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return "";
    }

    public static byte getTierByVoltage(long voltage) {
        if (voltage > GTValues.V[14]) {
            return 14;
        }
        return tierByVoltage.ceilingEntry(voltage).getValue();
    }

    public static byte getFloorTierByVoltage(long voltage) {
        if (voltage < GTValues.V[0]) {
            return 0;
        }
        return tierByVoltage.floorEntry(voltage).getValue();
    }

    public static BiomeDictionary.Type getBiomeTypeTagByName(String name) {
        Map byName = (Map)ReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (String[])new String[]{"byName"});
        return (BiomeDictionary.Type)byName.get(name);
    }

    public static List<Tuple<ItemStack, Integer>> getGrassSeedEntries() {
        ArrayList<Tuple<ItemStack, Integer>> result = new ArrayList<Tuple<ItemStack, Integer>>();
        try {
            Field seedListField = ForgeHooks.class.getDeclaredField("seedList");
            seedListField.setAccessible(true);
            Class<?> seedEntryClass = Class.forName("net.minecraftforge.common.ForgeHooks$SeedEntry");
            Field seedField = seedEntryClass.getDeclaredField("seed");
            seedField.setAccessible(true);
            List seedList = (List)seedListField.get(null);
            for (WeightedRandom.Item seedEntryObject : seedList) {
                ItemStack seedStack = (ItemStack)seedField.get(seedEntryObject);
                int chanceValue = seedEntryObject.field_76292_a;
                if (seedStack.func_190926_b()) continue;
                result.add((Tuple<ItemStack, Integer>)new Tuple((Object)seedStack, (Object)chanceValue));
            }
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to get forge grass seed list", (Throwable)exception);
        }
        return result;
    }

    public static <T> int getRandomItem(Random random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.nextInt(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    public static <T> int getRandomItem(List<? extends Map.Entry<Integer, T>> randomList, int size) {
        return GTUtility.getRandomItem(GTValues.RNG, randomList, size);
    }

    @Nullable
    public static EnumFacing determineWrenchingSide(EnumFacing facing, float x, float y, float z) {
        EnumFacing opposite = facing.func_176734_d();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)z < 0.25) {
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    return EnumFacing.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.SOUTH;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
        }
        return null;
    }

    public static List<ItemStack> itemHandlerToList(final IItemHandlerModifiable inputs) {
        return new AbstractList<ItemStack>(){

            @Override
            public ItemStack set(int index, ItemStack element) {
                ItemStack oldStack = inputs.getStackInSlot(index);
                inputs.setStackInSlot(index, element == null ? ItemStack.field_190927_a : element);
                return oldStack;
            }

            @Override
            public ItemStack get(int index) {
                return inputs.getStackInSlot(index);
            }

            @Override
            public int size() {
                return inputs.getSlots();
            }
        };
    }

    public static List<FluidStack> fluidHandlerToList(IMultipleTankHandler fluidInputs) {
        final List<IFluidTank> backedList = fluidInputs.getFluidTanks();
        return new AbstractList<FluidStack>(){

            @Override
            public FluidStack set(int index, FluidStack element) {
                IFluidTank fluidTank = (IFluidTank)backedList.get(index);
                FluidStack oldStack = fluidTank.getFluid();
                if (!(fluidTank instanceof FluidTank)) {
                    return oldStack;
                }
                ((FluidTank)backedList.get(index)).setFluid(element);
                return oldStack;
            }

            @Override
            public FluidStack get(int index) {
                return ((IFluidTank)backedList.get(index)).getFluid();
            }

            @Override
            public int size() {
                return backedList.size();
            }
        };
    }

    public static List<EntityPlayerMP> findPlayersUsing(MetaTileEntity metaTileEntity, double radius) {
        ArrayList<EntityPlayerMP> result = new ArrayList<EntityPlayerMP>();
        AxisAlignedBB box = new AxisAlignedBB(metaTileEntity.getPos()).func_72321_a(radius, radius, radius).func_72321_a(-radius, -radius, -radius);
        List entities = metaTileEntity.getWorld().func_72872_a(EntityPlayerMP.class, box);
        for (EntityPlayerMP player : entities) {
            if (!(player.field_71070_bA instanceof ModularUIContainer)) continue;
            ModularUI modularUI = ((ModularUIContainer)player.field_71070_bA).getModularUI();
            if (!(modularUI.holder instanceof IGregTechTileEntity) || ((IGregTechTileEntity)modularUI.holder).getMetaTileEntity() != metaTileEntity) continue;
            result.add(player);
        }
        return result;
    }

    public static <T> boolean iterableContains(Iterable<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static int amountOfNonNullElements(List<?> collection) {
        int amount = 0;
        for (Object object : collection) {
            if (object == null) continue;
            ++amount;
        }
        return amount;
    }

    public static int amountOfNonEmptyStacks(List<ItemStack> collection) {
        int amount = 0;
        for (ItemStack object : collection) {
            if (object == null || object.func_190926_b()) continue;
            ++amount;
        }
        return amount;
    }

    public static NBTTagCompound getOrCreateNbtCompound(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        return compound;
    }

    public static NonNullList<ItemStack> copyStackList(List<ItemStack> itemStacks) {
        Object[] stacks = new ItemStack[itemStacks.size()];
        for (int i = 0; i < itemStacks.size(); ++i) {
            stacks[i] = GTUtility.copy(itemStacks.get(i));
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
    }

    public static List<FluidStack> copyFluidList(List<FluidStack> fluidStacks) {
        Object[] stacks = new FluidStack[fluidStacks.size()];
        for (int i = 0; i < fluidStacks.size(); ++i) {
            stacks[i] = fluidStacks.get(i).copy();
        }
        return Lists.newArrayList((Object[])stacks);
    }

    public static ItemStack copy(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack copyAmount(int amount, ItemStack ... stacks) {
        ItemStack stack = GTUtility.copy(stacks);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount > 64) {
            amount = 64;
        } else if (amount == -1) {
            amount = 111;
        } else if (amount < 0) {
            amount = 0;
        }
        stack.func_190920_e(amount);
        return stack;
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        FluidStack stack = fluidStack.copy();
        stack.amount = amount;
        return stack;
    }

    public static <T extends Comparable<T>> IBlockState[] getAllPropertyValues(IBlockState blockState, IProperty<T> property) {
        Collection allowedValues = property.func_177700_c();
        IBlockState[] resultArray = new IBlockState[allowedValues.size()];
        int index = 0;
        for (Comparable propertyValue : allowedValues) {
            resultArray[index++] = blockState.func_177226_a(property, propertyValue);
        }
        return resultArray;
    }

    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList::builder, ImmutableList.Builder::add, (b1, b2) -> {
            b1.addAll((Iterable)b2.build());
            return b2;
        }, ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <M> M selectItemInList(int index, M replacement, List<M> list, Class<M> minClass) {
        if (list.isEmpty()) {
            return replacement;
        }
        M maybeResult = list.size() <= index ? list.get(list.size() - 1) : (index < 0 ? list.get(0) : list.get(index));
        if (maybeResult != null) {
            return maybeResult;
        }
        return replacement;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    public static int getExplosionPower(long voltage) {
        return GTUtility.getTierByVoltage(voltage) + 1;
    }

    public static int getRedstonePower(World world, BlockPos blockPos, EnumFacing side) {
        IBlockState offsetState;
        BlockPos offsetPos = blockPos.func_177972_a(side);
        int worldPower = world.func_175651_c(offsetPos, side);
        if (worldPower < 15 && (offsetState = world.func_180495_p(offsetPos)).func_177230_c() instanceof BlockRedstoneWire) {
            int wirePower = (Integer)offsetState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            return Math.max(worldPower, wirePower);
        }
        return worldPower;
    }

    public static Comparator<ItemStack> createItemStackComparator() {
        return Comparator.comparing(it -> Item.field_150901_e.func_148757_b((Object)it.func_77973_b())).thenComparing(ItemStack::func_77952_i).thenComparing(ItemStack::func_77942_o).thenComparing(it -> -Objects.hashCode(it.func_77978_p())).thenComparing(it -> -it.func_190916_E());
    }

    public static boolean arePosEqual(BlockPos pos1, BlockPos pos2) {
        return pos1.func_177958_n() == pos2.func_177958_n() & pos1.func_177956_o() == pos2.func_177956_o() & pos1.func_177952_p() == pos2.func_177952_p();
    }

    public static boolean isCoverBehaviorItem(ItemStack itemStack) {
        return GTUtility.isCoverBehaviorItem(itemStack, null, null);
    }

    public static boolean isCoverBehaviorItem(ItemStack itemStack, @Nullable BooleanSupplier hasCoverSupplier, @Nullable Predicate<CoverDefinition> canPlaceCover) {
        Item item = itemStack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)itemStack.func_77973_b();
            Object valueItem = metaItem.getItem(itemStack);
            if (valueItem != null) {
                for (IItemBehaviour behaviour : ((MetaItem.MetaValueItem)valueItem).getBehaviours()) {
                    if (!(behaviour instanceof CoverPlaceBehavior)) continue;
                    return canPlaceCover == null || canPlaceCover.test(((CoverPlaceBehavior)behaviour).coverDefinition);
                }
            }
        } else if (item.getToolClasses(itemStack).contains("crowbar")) {
            return hasCoverSupplier == null || hasCoverSupplier.getAsBoolean();
        }
        return false;
    }

    public static int getDecompositionReductionRatio(FluidStack fluidInput, FluidStack fluidOutput, ItemStack input, ItemStack output) {
        int[] divisors = new int[]{2, 5, 10, 25, 50};
        int ratio = -1;
        for (int divisor : divisors) {
            if (!GTUtility.isFluidStackAmountDivisible(fluidInput, divisor) || !GTUtility.isFluidStackAmountDivisible(fluidOutput, divisor) || input != null && !GTUtility.isItemStackCountDivisible(input, divisor) || output != null && !GTUtility.isItemStackCountDivisible(output, divisor)) continue;
            ratio = divisor;
        }
        return Math.max(1, ratio);
    }

    public static boolean isFluidStackAmountDivisible(FluidStack fluidStack, int divisor) {
        return fluidStack.amount % divisor == 0 && fluidStack.amount % divisor != fluidStack.amount && fluidStack.amount / divisor != 0;
    }

    public static boolean isItemStackCountDivisible(ItemStack itemStack, int divisor) {
        return itemStack.func_190916_E() % divisor == 0 && itemStack.func_190916_E() % divisor != itemStack.func_190916_E() && itemStack.func_190916_E() / divisor != 0;
    }

    public static AxisAlignedBB rotateAroundYAxis(AxisAlignedBB aabb, EnumFacing from, EnumFacing to) {
        if (from == EnumFacing.UP || from == EnumFacing.DOWN || to == EnumFacing.UP || to == EnumFacing.DOWN) {
            throw new IllegalArgumentException("Either the second or third parameters were EnumFacing.DOWN or EnumFacing.UP.");
        }
        AxisAlignedBB rotatedAABB = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        while (from != to) {
            from = from.func_176746_e();
            rotatedAABB = new AxisAlignedBB(1.0 - rotatedAABB.field_72334_f, rotatedAABB.field_72338_b, rotatedAABB.field_72340_a, 1.0 - rotatedAABB.field_72339_c, rotatedAABB.field_72337_e, rotatedAABB.field_72336_d);
        }
        return rotatedAABB;
    }

    public static String romanNumeralString(int num) {
        int conversion;
        if (romanNumeralConversions.isEmpty()) {
            romanNumeralConversions.put(1000, "M");
            romanNumeralConversions.put(900, "CM");
            romanNumeralConversions.put(500, "D");
            romanNumeralConversions.put(400, "CD");
            romanNumeralConversions.put(100, "C");
            romanNumeralConversions.put(90, "XC");
            romanNumeralConversions.put(50, "L");
            romanNumeralConversions.put(40, "XL");
            romanNumeralConversions.put(10, "X");
            romanNumeralConversions.put(9, "IX");
            romanNumeralConversions.put(5, "V");
            romanNumeralConversions.put(4, "IV");
            romanNumeralConversions.put(1, "I");
        }
        if (num == (conversion = romanNumeralConversions.floorKey(num).intValue())) {
            return romanNumeralConversions.get(num);
        }
        return romanNumeralConversions.get(conversion) + GTUtility.romanNumeralString(num - conversion);
    }

    public static ItemStack toItem(IBlockState state) {
        return GTUtility.toItem(state, 1);
    }

    public static ItemStack toItem(IBlockState state, int amount) {
        return new ItemStack(state.func_177230_c(), amount, state.func_177230_c().func_176201_c(state));
    }

    public static boolean isOre(ItemStack item) {
        OrePrefix orePrefix = OreDictUnifier.getPrefix(item);
        return orePrefix != null && orePrefix.name().startsWith("ore");
    }

    public static long mean(@Nonnull long[] values) {
        if ((long)values.length == 0L) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public static double getMeanTickTime(@Nonnull World world) {
        return (double)GTUtility.mean(Objects.requireNonNull(world.func_73046_m()).field_71311_j) * 1.0E-6;
    }

    public static boolean isMachineValidForMachineHatch(ItemStack machineStack, String[] recipeMapBlacklist) {
        if (machineStack == null || machineStack.func_190926_b()) {
            return false;
        }
        MetaTileEntity machine = GTUtility.getMetaTileEntity(machineStack);
        if (machine instanceof WorkableTieredMetaTileEntity && !(machine instanceof SimpleGeneratorMetaTileEntity)) {
            return !GTUtility.findMachineInBlacklist(machine.getRecipeMap().getUnlocalizedName(), recipeMapBlacklist);
        }
        return false;
    }

    public static boolean findMachineInBlacklist(String unlocalizedName, String[] recipeMapBlacklist) {
        return Arrays.asList(recipeMapBlacklist).contains(unlocalizedName);
    }

    public static String toLowerCaseUnderscore(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && (Character.isUpperCase(string.charAt(i)) || Character.isDigit(string.charAt(i - 1)) ^ Character.isDigit(string.charAt(i)))) {
                result.append("_");
            }
            result.append(Character.toLowerCase(string.charAt(i)));
        }
        return result.toString();
    }

    public static String lowerUnderscoreToUpperCamel(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '_') continue;
            if (i == 0 || string.charAt(i - 1) == '_') {
                result.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    public static String formatNumbers(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(double number) {
        return NUMBER_FORMAT.format(number);
    }

    @Nonnull
    public static String formatNumber2Places(float number) {
        return TWO_PLACES_FORMAT.format(number);
    }

    public static boolean isPosChunkLoaded(World world, BlockPos pos) {
        return !world.func_72863_F().func_186025_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_76621_g();
    }

    public static MetaTileEntity getMetaTileEntity(IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof IGregTechTileEntity ? ((IGregTechTileEntity)te).getMetaTileEntity() : null;
    }

    public static MetaTileEntity getMetaTileEntity(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof MachineItemBlock)) {
            return null;
        }
        return GregTechAPI.MTE_REGISTRY.getObjectById(stack.func_77952_i());
    }

    public static boolean canSeeSunClearly(World world, BlockPos blockPos) {
        if (!world.func_175678_i(blockPos.func_177984_a())) {
            return false;
        }
        Biome biome = world.func_180494_b(blockPos.func_177984_a());
        if (world.func_72896_J() && (biome.func_76738_d() || biome.func_76746_c())) {
            return false;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (biomeTypes.contains(BiomeDictionary.Type.END)) {
            return false;
        }
        return world.func_72935_r();
    }

    public static MapColor getMapColor(int rgb) {
        MapColor color = MapColor.field_151646_E;
        int originalR = rgb >> 16 & 0xFF;
        int originalG = rgb >> 8 & 0xFF;
        int originalB = rgb & 0xFF;
        int distance = Integer.MAX_VALUE;
        for (MapColor mapColor : MapColor.field_76281_a) {
            int distB;
            int distG;
            int colorValue;
            if (mapColor == null || (colorValue = mapColor.field_76291_p) == 0) continue;
            int colorR = colorValue >> 16 & 0xFF;
            int colorG = colorValue >> 8 & 0xFF;
            int colorB = colorValue & 0xFF;
            int distR = Math.abs(originalR - colorR);
            int dist = distR * distR + (distG = Math.abs(originalG - colorG)) * distG + (distB = Math.abs(originalB - colorB)) * distB;
            if (dist >= distance) continue;
            distance = dist;
            color = mapColor;
        }
        return color;
    }

    public static boolean isBlockSnowLayer(@Nonnull IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150431_aC && (Integer)blockState.func_177229_b((IProperty)BlockSnow.field_176315_a) == 1;
    }

    public static boolean tryBreakSnowLayer(World world, BlockPos pos, @Nonnull IBlockState blockState, boolean playSound) {
        if (GTUtility.isBlockSnowLayer(blockState)) {
            world.func_175655_b(pos, false);
            if (playSound) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public static String convertUnderscoreToSpace(@Nonnull CharSequence sequence) {
        return UNDERSCORE_TO_SPACE.matcher(sequence).replaceAll(" ");
    }

    static {
        for (int i = 0; i < GTValues.V.length; ++i) {
            tierByVoltage.put(GTValues.V[i], (byte)i);
        }
        UNDERSCORE_TO_SPACE = Pattern.compile("_");
        defaultTankSizeFunction = tier -> {
            if (tier <= 1) {
                return 8000;
            }
            if (tier == 2) {
                return 12000;
            }
            if (tier == 3) {
                return 16000;
            }
            if (tier == 4) {
                return 32000;
            }
            return 64000;
        };
        hvCappedTankSizeFunction = tier -> {
            if (tier <= 1) {
                return 8000;
            }
            if (tier == 2) {
                return 12000;
            }
            return 16000;
        };
        largeTankSizeFunction = tier -> {
            if (tier <= 1) {
                return 32000;
            }
            if (tier == 2) {
                return 48000;
            }
            return 64000;
        };
        steamGeneratorTankSizeFunction = tier -> Math.min(16000 * (1 << tier - 1), 64000);
        genericGeneratorTankSizeFunction = tier -> Math.min(4000 * (1 << tier - 1), 16000);
    }
}

