/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class GTControlledRegistry<K, V>
extends RegistrySimple<K, V> {
    protected boolean frozen = true;
    protected final int maxId;
    protected final IntIdentityHashBiMap<V> underlyingIntegerMap = new IntIdentityHashBiMap(256);
    protected final Map<V, K> inverseObjectRegistry;

    public GTControlledRegistry(int maxId) {
        this.maxId = maxId;
        this.inverseObjectRegistry = ((BiMap)this.field_82596_a).inverse();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen!");
        }
        if (!this.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = true;
    }

    public void unfreeze() {
        if (!this.frozen) {
            throw new IllegalStateException("Registry is already unfrozen!");
        }
        if (!this.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = false;
    }

    private boolean checkActiveModContainerIsGregtech() {
        ModContainer container = Loader.instance().activeModContainer();
        return container != null && container.getModId().equals("gregtech");
    }

    public void register(int id, K key, V value) {
        if (id < 0 || id >= this.maxId) {
            throw new IndexOutOfBoundsException("Id is out of range: " + id);
        }
        super.func_82595_a(key, value);
        V objectWithId = this.getObjectById(id);
        if (objectWithId != null) {
            throw new IllegalArgumentException(String.format("Tried to reassign id %d to %s (%s), but it is already assigned to %s (%s)!", id, value, key, objectWithId, this.getNameForObject(objectWithId)));
        }
        this.underlyingIntegerMap.func_186814_a(value, id);
    }

    public void func_82595_a(@Nonnull K key, @Nonnull V value) {
        throw new UnsupportedOperationException("Use #register(int, String, T)");
    }

    public int getIdByObjectName(K key) {
        Object valueWithKey = this.func_82594_a(key);
        return valueWithKey == null ? 0 : this.getIDForObject(valueWithKey);
    }

    @Nonnull
    protected Map<K, V> func_148740_a() {
        return HashBiMap.create();
    }

    @Nullable
    public K getNameForObject(V value) {
        return this.inverseObjectRegistry.get(value);
    }

    public int getIDForObject(@Nullable V value) {
        return this.underlyingIntegerMap.func_186815_a(value);
    }

    @Nullable
    public V getObjectById(int id) {
        return (V)this.underlyingIntegerMap.func_186813_a(id);
    }

    @Nonnull
    public Iterator<V> iterator() {
        return this.underlyingIntegerMap.iterator();
    }
}

