/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.os;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.terminal.gui.widgets.AnimaWidgetGroup;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.gui.widgets.ColorWidget;
import gregtech.api.terminal.gui.widgets.TreeListWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.terminal.util.FileTree;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class TerminalDialogWidget
extends AnimaWidgetGroup {
    private static final IGuiTexture DIALOG_BACKGROUND = TextureArea.fullImage("textures/gui/terminal/terminal_dialog.png");
    private static final IGuiTexture OK_NORMAL = TextureArea.fullImage("textures/gui/terminal/icon/ok_normal.png");
    private static final IGuiTexture OK_HOVER = TextureArea.fullImage("textures/gui/terminal/icon/ok_hover.png");
    private static final IGuiTexture CANCEL_NORMAL = TextureArea.fullImage("textures/gui/terminal/icon/cancel_normal.png");
    private static final IGuiTexture CANCEL_HOVER = TextureArea.fullImage("textures/gui/terminal/icon/cancel_hover.png");
    private static final int HEIGHT = 128;
    private static final int WIDTH = 184;
    private final TerminalOSWidget os;
    private IGuiTexture background;
    private boolean isClient;
    private List<Widget> iNativeWidgets;
    boolean isClosed;

    public TerminalDialogWidget(TerminalOSWidget os, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.os = os;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public TerminalDialogWidget open() {
        this.os.openDialog(this);
        if (this.iNativeWidgets != null) {
            this.iNativeWidgets.forEach(this::addWidget);
        }
        if (this.isRemote()) {
            this.os.desktop.addTopWidget(this);
        }
        return this;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.os.closeDialog(this);
        if (this.isRemote()) {
            this.os.desktop.removeTopWidget(this);
        }
    }

    public TerminalDialogWidget setClientSide() {
        this.isClient = true;
        return this;
    }

    public TerminalDialogWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public TerminalDialogWidget addOkButton(Runnable callback) {
        this.addWidget(new CircleButtonWidget(92, 106, 12, 0, 24).setClickListener(cd -> {
            this.close();
            if (callback != null) {
                callback.run();
            }
        }).setColors(0, 0, 0).setIcon(OK_NORMAL).setHoverIcon(OK_HOVER));
        return this;
    }

    public TerminalDialogWidget addConfirmButton(Consumer<Boolean> result) {
        this.addWidget(new CircleButtonWidget(62, 106, 12, 0, 24).setClickListener(cd -> {
            this.close();
            if (result != null) {
                result.accept(true);
            }
        }).setColors(0, 0, 0).setIcon(OK_NORMAL).setHoverIcon(OK_HOVER));
        this.addWidget(new CircleButtonWidget(122, 106, 12, 0, 24).setClickListener(cd -> {
            this.close();
            if (result != null) {
                result.accept(false);
            }
        }).setColors(0, 0, 0).setIcon(CANCEL_NORMAL).setHoverIcon(CANCEL_HOVER));
        return this;
    }

    public TerminalDialogWidget addTitle(String title) {
        this.addWidget(new LabelWidget(92, 11, title, -1).setXCentered(true));
        return this;
    }

    public TerminalDialogWidget addInfo(String info) {
        this.addWidget(new LabelWidget(92, 64, info, -1).setWidth(168).setYCentered(true).setXCentered(true));
        return this;
    }

    public static TerminalDialogWidget createEmptyTemplate(TerminalOSWidget os) {
        Size size = os.getSize();
        return new TerminalDialogWidget(os, (size.width - 184) / 2, (size.height - 128) / 2, 184, 128).setBackground(DIALOG_BACKGROUND);
    }

    public static TerminalDialogWidget showInfoDialog(TerminalOSWidget os, String title, String info, Runnable callback) {
        return TerminalDialogWidget.createEmptyTemplate(os).addTitle(title).addInfo(info).addOkButton(callback);
    }

    public static TerminalDialogWidget showInfoDialog(TerminalOSWidget os, String title, String info) {
        return TerminalDialogWidget.createEmptyTemplate(os).addTitle(title).addInfo(info).addOkButton(null);
    }

    public static TerminalDialogWidget showConfirmDialog(TerminalOSWidget os, String title, String info, Consumer<Boolean> result) {
        return TerminalDialogWidget.createEmptyTemplate(os).addConfirmButton(result).addTitle(title).addInfo(info);
    }

    public static TerminalDialogWidget showTextFieldDialog(TerminalOSWidget os, String title, Predicate<String> validator, Consumer<String> result) {
        TextFieldWidget textFieldWidget = new TextFieldWidget(42, 49, 100, 20, new ColorRectTexture(0x2FFFFFFF), null, null).setValidator(validator);
        TerminalDialogWidget dialog = TerminalDialogWidget.createEmptyTemplate(os).addTitle(title).addConfirmButton(b -> {
            if (b.booleanValue()) {
                if (result != null) {
                    result.accept(textFieldWidget.getCurrentString());
                }
            } else if (result != null) {
                result.accept(null);
            }
        });
        dialog.addWidget(textFieldWidget);
        return dialog;
    }

    public static TerminalDialogWidget showColorDialog(TerminalOSWidget os, String title, Consumer<Integer> result, int startColor) {
        TerminalDialogWidget dialog = TerminalDialogWidget.createEmptyTemplate(os).addTitle(title);
        ColorWidget colorWidget = new ColorWidget(32, 29, 80, 10);
        colorWidget.setStartColor(startColor);
        dialog.addWidget(colorWidget);
        dialog.addConfirmButton(b -> {
            if (b.booleanValue()) {
                if (result != null) {
                    result.accept(colorWidget.getColor());
                }
            } else if (result != null) {
                result.accept(null);
            }
        });
        return dialog;
    }

    public static TerminalDialogWidget showFileDialog(TerminalOSWidget os, String title, File dir, boolean isSelector, Consumer<File> result) {
        Size size = os.getSize();
        TerminalDialogWidget dialog = new TerminalDialogWidget(os, 0, 0, size.width, size.height).setBackground(new ColorRectTexture(0x4F000000));
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return dialog.addInfo(I18n.func_135052_a((String)"terminal.dialog.error_path", (Object[])new Object[0]) + dir.getPath()).addOkButton(null);
        }
        AtomicReference<File> selected = new AtomicReference<File>();
        selected.set(dir);
        dialog.addWidget(new TreeListWidget<File, File>(0, 0, 130, size.height, new FileTree(dir), node -> selected.set((File)node.getKey())).setNodeTexture(GuiTextures.BORDERED_BACKGROUND).canSelectNode(true).setLeafTexture(GuiTextures.SLOT_DARKENED));
        int x = 130 + (size.width - 133 - 184) / 2;
        int y = (size.height - 128) / 2;
        dialog.addWidget(new ImageWidget(x, y, 184, 128, DIALOG_BACKGROUND));
        dialog.addWidget(new CircleButtonWidget(x + 92 - 30, y + 128 - 22, 12, 0, 24).setClickListener(cd -> {
            dialog.close();
            if (result != null) {
                result.accept((File)selected.get());
            }
        }).setColors(0, 0, 0).setIcon(OK_NORMAL).setHoverIcon(OK_HOVER));
        dialog.addWidget(new CircleButtonWidget(x + 92 + 30, y + 128 - 22, 12, 0, 24).setClickListener(cd -> {
            dialog.close();
            if (result != null) {
                result.accept(null);
            }
        }).setColors(0, 0, 0).setIcon(CANCEL_NORMAL).setHoverIcon(CANCEL_HOVER));
        if (isSelector) {
            dialog.addWidget(new SimpleTextWidget(x + 92, y + 64 - 5, "", -1, () -> {
                if (selected.get() != null) {
                    return ((File)selected.get()).toString();
                }
                return "terminal.dialog.no_file_selected";
            }, true).setWidth(168));
        } else {
            dialog.addWidget(new TextFieldWidget(x + 92 - 38, y + 64 - 10, 76, 20, new ColorRectTexture(0x4F000000), null, null).setTextResponder(res -> {
                File file = (File)selected.get();
                if (file == null) {
                    return;
                }
                if (file.isDirectory()) {
                    selected.set(new File(file, (String)res));
                } else {
                    selected.set(new File(file.getParent(), (String)res));
                }
            }, true).setTextSupplier(() -> {
                File file = (File)selected.get();
                if (file != null && !file.isDirectory()) {
                    return ((File)selected.get()).getName();
                }
                return "";
            }, true).setMaxStringLength(Integer.MAX_VALUE).setValidator(s -> true));
        }
        dialog.addWidget(new CircleButtonWidget(x + 17, y + 15, 10, 1, 16).setClickListener(cd -> {
            File file = (File)selected.get();
            if (file != null && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(file.isDirectory() ? file : file.getParentFile());
                }
                catch (IOException e) {
                    GTLog.logger.error("Error reading opening file " + file.getPath(), (Throwable)e);
                }
            }
        }).setColors(0, -1, 0).setHoverText("terminal.dialog.folder").setIcon(GuiTextures.ICON_LOAD));
        dialog.addWidget(new LabelWidget(x + 92, y + 11, title, -1).setXCentered(true));
        if (os.isRemote()) {
            os.menu.hideMenu();
        }
        return dialog.setClientSide();
    }

    public static TerminalDialogWidget showItemSelector(TerminalOSWidget os, String title, boolean cost, Predicate<ItemStack> filter, Consumer<ItemStack> result) {
        TerminalDialogWidget dialog = TerminalDialogWidget.createEmptyTemplate(os);
        dialog.addWidget(new LabelWidget(92, -7, title, -1).setShadow(true).setXCentered(true));
        InventoryPlayer inventoryPlayer = os.getModularUI().entityPlayer.field_71071_by;
        if (dialog.iNativeWidgets == null) {
            dialog.iNativeWidgets = new ArrayList<Widget>();
        }
        int x = 11;
        int y = 30;
        final SlotWidget[] selected = new SlotWidget[]{null};
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                final boolean pass = filter == null || filter.test(inventoryPlayer.func_70301_a(col + row * 9));
                SlotWidget slotWidget = new SlotWidget((IInventory)inventoryPlayer, col + row * 9, x + col * 18, (int)((double)y + (row == 0 ? -1.2 : (double)(row - 1)) * 18.0), false, false){

                    @Override
                    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
                        super.drawInBackground(mouseX, mouseY, partialTicks, context);
                        if (selected[0] == this) {
                            1.drawBorder(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height, -1, 1);
                        }
                    }

                    @Override
                    public boolean mouseClicked(int mouseX, int mouseY, int button) {
                        if (pass && this.isMouseOverElement(mouseX, mouseY)) {
                            selected[0] = selected[0] == this ? null : this;
                            this.writeClientAction(7, buffer -> buffer.writeBoolean(selected[0] == this));
                        }
                        return super.mouseClicked(mouseX, mouseY, button);
                    }

                    @Override
                    public void handleClientAction(int id, PacketBuffer buffer) {
                        if (id == 7) {
                            selected[0] = buffer.readBoolean() ? this : null;
                        }
                        super.readUpdateInfo(id, buffer);
                    }
                }.setBackgroundTexture(TerminalTheme.COLOR_B_1).setLocationInfo(true, false);
                slotWidget.setActive(pass);
                dialog.iNativeWidgets.add(slotWidget);
            }
        }
        dialog.addConfirmButton(confirm -> {
            if (result != null && confirm.booleanValue() && selected[0] != null && !selected[0].getHandle().func_75211_c().func_190926_b()) {
                ItemStack stack = selected[0].getHandle().func_75211_c().func_77946_l();
                if (cost) {
                    selected[0].getHandle().func_75211_c().func_190920_e(stack.func_190916_E() - 1);
                }
                stack.func_190920_e(1);
                result.accept(stack);
            }
        });
        return dialog;
    }

    @Override
    public void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        GlStateManager.func_179097_i();
        if (this.background != null) {
            this.background.draw(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
        }
        super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
        GlStateManager.func_179126_j();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible() || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return true;
    }

    @Override
    protected void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.isClient || this.isClosed) {
            return;
        }
        super.writeClientAction(id, packetBufferWriter);
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            if (buffer.readBoolean()) {
                this.close();
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        if (keyCode == 1 && this.interpolator == null) {
            this.writeClientAction(-1, buffer -> buffer.writeBoolean(true));
            this.close();
            return true;
        }
        return super.keyTyped(charTyped, keyCode);
    }

    public void onOSSizeUpdate(int width, int height) {
        this.setSelfPosition(Position.ORIGIN.add(new Position((width - this.getSize().width) / 2, (height - this.getSize().height) / 2)));
    }
}

