/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui;

import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.tab.ITabInfo;
import gregtech.api.gui.widgets.tab.TabListRenderer;
import gregtech.api.util.Position;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class CustomTabListRenderer
extends TabListRenderer {
    private final IGuiTexture unSelected;
    private final IGuiTexture selected;
    private final int width;
    private final int height;

    public CustomTabListRenderer(IGuiTexture unSelected, IGuiTexture selected, int width, int height) {
        this.unSelected = unSelected;
        this.selected = selected;
        this.width = width;
        this.height = height;
    }

    @Override
    public void renderTabs(ModularUI gui, Position offset, List<ITabInfo> tabInfos, int guiWidth, int guiHeight, int selectedTabIndex) {
        int y = offset.y - this.height;
        GlStateManager.func_179131_c((float)gui.getRColorForOverlay(), (float)gui.getGColorForOverlay(), (float)gui.getBColorForOverlay(), (float)1.0f);
        for (int i = 0; i < tabInfos.size(); ++i) {
            int x = offset.x + i * this.width;
            if (selectedTabIndex == i && this.selected != null) {
                tabInfos.get(i).renderTab(this.selected, x, y, this.width, this.height, true);
                GlStateManager.func_179131_c((float)gui.getRColorForOverlay(), (float)gui.getGColorForOverlay(), (float)gui.getBColorForOverlay(), (float)1.0f);
            }
            if (selectedTabIndex == i || this.unSelected == null) continue;
            tabInfos.get(i).renderTab(this.unSelected, x, y, this.width, this.height, false);
            GlStateManager.func_179131_c((float)gui.getRColorForOverlay(), (float)gui.getGColorForOverlay(), (float)gui.getBColorForOverlay(), (float)1.0f);
        }
    }

    @Override
    public int[] getTabPos(int guiWidth, int guiHeight, int tabIndex) {
        return new int[]{this.width * guiWidth, -this.height, this.width, this.height};
    }
}

