/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.app;

import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.gui.widgets.AnimaWidgetGroup;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.menu.IMenuComponent;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.items.behaviors.TerminalBehaviour;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractApplication
extends AnimaWidgetGroup {
    protected final String name;
    protected TerminalOSWidget os;
    protected boolean isClient;
    protected NBTTagCompound nbt;

    public AbstractApplication(String name) {
        super(Position.ORIGIN, new Size(333, 232));
        this.name = name;
    }

    public AbstractApplication setOs(TerminalOSWidget os) {
        this.os = os;
        return this;
    }

    public boolean canOpenMenuOnEdge() {
        return true;
    }

    public int getThemeColor() {
        return this.name.hashCode() | 0xFF000000;
    }

    public String getRegistryName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return "gregtech.terminal.app_name." + this.name;
    }

    public IGuiTexture getIcon() {
        return TextureArea.fullImage("textures/gui/terminal/" + this.name + "/icon.png");
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        if (I18n.func_188566_a((String)("terminal." + this.getRegistryName() + ".description"))) {
            return I18n.func_135052_a((String)("terminal." + this.getRegistryName() + ".description"), (Object[])new Object[0]).replaceAll("\\\\n", "\n");
        }
        return I18n.func_135052_a((String)"terminal.app_name.description", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiTexture getProfile() {
        if (ResourceHelper.isResourceExist("textures/gui/terminal/" + this.name + "/profile.png")) {
            return TextureArea.fullImage("textures/gui/terminal/" + this.name + "/profile.png");
        }
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiTexture getBanner() {
        if (ResourceHelper.isResourceExist("textures/gui/terminal/" + this.name + "/banner.png")) {
            return TextureArea.fullImage("textures/gui/terminal/" + this.name + "/banner.png");
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTierInformation(int tier) {
        if (I18n.func_188566_a((String)("terminal." + this.name + ".tier." + tier))) {
            return I18n.func_135052_a((String)("terminal." + this.name + ".tier." + tier), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"terminal.app_name.tier", (Object[])new Object[]{tier});
    }

    public AbstractApplication createAppInstance(TerminalOSWidget os, boolean isClient, NBTTagCompound nbt) {
        try {
            AbstractApplication app = (AbstractApplication)this.getClass().newInstance();
            app.isClient = isClient;
            app.nbt = nbt;
            return app;
        }
        catch (IllegalAccessException | InstantiationException e) {
            GTLog.logger.error("Error while create default app. {}", this.getClass(), (Object)e);
            return null;
        }
    }

    public AbstractApplication initApp() {
        return this;
    }

    public NBTTagCompound closeApp() {
        return null;
    }

    public boolean isBackgroundApp() {
        return false;
    }

    public boolean isClientSideApp() {
        return false;
    }

    public TerminalOSWidget getOs() {
        return this.os;
    }

    public List<IMenuComponent> getMenuComponents() {
        return Collections.emptyList();
    }

    public boolean canPlayerUse(EntityPlayer player) {
        return true;
    }

    public int getAppTier() {
        if (this.nbt != null) {
            if (TerminalBehaviour.isCreative(this.getOs().itemStack)) {
                return this.getMaxTier();
            }
            return Math.min(this.nbt.func_74762_e("_tier"), this.getMaxTier());
        }
        return 0;
    }

    public int getMaxTier() {
        return 0;
    }

    @Override
    protected void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (!this.isClientSideApp()) {
            super.writeClientAction(id, packetBufferWriter);
        }
    }

    protected void loadLocalConfig(Consumer<NBTTagCompound> reader) {
        if (this.isClient && reader != null) {
            NBTTagCompound nbt = null;
            try {
                nbt = CompressedStreamTools.func_74797_a((File)new File(TerminalRegistry.TERMINAL_PATH, String.format("config/%S.nbt", this.getRegistryName())));
            }
            catch (IOException e) {
                GTLog.logger.error("error while loading local nbt for {}", (Object)this.getRegistryName(), (Object)e);
            }
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            reader.accept(nbt);
        }
    }

    protected void saveLocalConfig(Consumer<NBTTagCompound> writer) {
        if (this.isClient && writer != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                writer.accept(nbt);
                if (!nbt.func_82582_d()) {
                    CompressedStreamTools.func_74793_a((NBTTagCompound)nbt, (File)new File(TerminalRegistry.TERMINAL_PATH, String.format("config/%S.nbt", this.getRegistryName())));
                }
            }
            catch (IOException e) {
                GTLog.logger.error("error while saving local nbt for {}", (Object)this.getRegistryName(), (Object)e);
            }
        }
    }

    public void onOSSizeUpdate(int width, int height) {
        this.setSelfPosition(Position.ORIGIN.add(new Position((width - this.getSize().width) / 2, (height - this.getSize().height) / 2)));
    }

    public boolean canLaunchConcurrently(AbstractApplication application) {
        return true;
    }
}

