/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import crafttweaker.CraftTweakerAPI;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.GasCollectorDimensionProperty;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GasCollectorRecipeBuilder
extends RecipeBuilder<GasCollectorRecipeBuilder> {
    public GasCollectorRecipeBuilder() {
    }

    public GasCollectorRecipeBuilder(Recipe recipe, RecipeMap<GasCollectorRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public GasCollectorRecipeBuilder(RecipeBuilder<GasCollectorRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public GasCollectorRecipeBuilder copy() {
        return new GasCollectorRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(@Nonnull String key, Object value) {
        if (key.equals("dimension")) {
            if (value instanceof Integer) {
                this.dimension((Integer)value);
            } else if (value instanceof List && !((List)value).isEmpty() && ((List)value).get(0) instanceof Integer) {
                IntList dimensionIDs = this.getDimensionIDs();
                if (dimensionIDs == IntLists.EMPTY_LIST) {
                    dimensionIDs = new IntArrayList();
                    this.applyProperty(GasCollectorDimensionProperty.getInstance(), (Object)dimensionIDs);
                }
                dimensionIDs.addAll((Collection)((List)value));
            } else {
                if (this.isCTRecipe) {
                    CraftTweakerAPI.logError((String)"Dimension for Gas Collector needs to be a Integer");
                    return false;
                }
                throw new IllegalArgumentException("Invalid Dimension Property Type!");
            }
            return true;
        }
        return super.applyProperty(key, value);
    }

    public GasCollectorRecipeBuilder dimension(int dimensionID) {
        IntList dimensionIDs = this.getDimensionIDs();
        if (dimensionIDs == IntLists.EMPTY_LIST) {
            dimensionIDs = new IntArrayList();
            this.applyProperty(GasCollectorDimensionProperty.getInstance(), (Object)dimensionIDs);
        }
        dimensionIDs.add(dimensionID);
        return this;
    }

    public IntList getDimensionIDs() {
        return this.recipePropertyStorage == null ? IntLists.EMPTY_LIST : (IntList)this.recipePropertyStorage.getRecipePropertyValue(GasCollectorDimensionProperty.getInstance(), IntLists.EMPTY_LIST);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(GasCollectorDimensionProperty.getInstance().getKey(), (Object)this.getDimensionIDs().toString()).toString();
    }
}

