/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.Material;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityPipeBase<PipeType extends Enum<PipeType>, NodeDataType>
extends SyncedTileEntityBase
implements IPipeTile<PipeType, NodeDataType> {
    protected final PipeCoverableImplementation coverableImplementation = new PipeCoverableImplementation(this);
    protected int paintingColor = -1;
    private int connections = 0;
    private int blockedConnections = 0;
    private NodeDataType cachedNodeData;
    private BlockPipe<PipeType, NodeDataType, ?> pipeBlock;
    private PipeType pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[0];
    @Nullable
    private Material frameMaterial;

    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType) {
        this.pipeBlock = pipeBlock;
        this.pipeType = pipeType;
        if (!this.func_145831_w().field_72995_K) {
            this.writeCustomData(-4, this::writePipeProperties);
        }
    }

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> tileEntity) {
        this.pipeType = tileEntity.getPipeType();
        this.paintingColor = tileEntity.getPaintingColor();
        this.connections = tileEntity.getConnections();
        if (tileEntity instanceof TileEntityPipeBase) {
            this.updates.putAll((Map)((TileEntityPipeBase)tileEntity).updates);
        }
        tileEntity.getCoverableImplementation().transferDataTo(this.coverableImplementation);
        this.setFrameMaterial(tileEntity.getFrameMaterial());
    }

    public abstract Class<PipeType> getPipeTypeClass();

    @Override
    @Nullable
    public Material getFrameMaterial() {
        return this.frameMaterial;
    }

    public void setFrameMaterial(@Nullable Material frameMaterial) {
        this.frameMaterial = frameMaterial;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.writeCustomData(-7, buf -> buf.func_150787_b(frameMaterial == null ? -1 : GregTechAPI.MATERIAL_REGISTRY.getIDForObject(frameMaterial)));
        }
    }

    @Override
    public boolean supportsTicking() {
        return this instanceof ITickable;
    }

    @Override
    public World getPipeWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.func_174877_v();
    }

    @Override
    public PipeCoverableImplementation getCoverableImplementation() {
        return this.coverableImplementation;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return true;
    }

    @Override
    public IPipeTile<PipeType, NodeDataType> setSupportsTicking() {
        if (this.supportsTicking()) {
            return this;
        }
        TileEntityPipeBase<PipeType, NodeDataType> newTile = this.getPipeBlock().createNewTileEntity(true);
        newTile.transferDataFrom(this);
        this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)newTile);
        return newTile;
    }

    @Override
    public BlockPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        if (this.pipeBlock == null) {
            Block block = this.getBlockState().func_177230_c();
            this.pipeBlock = block instanceof BlockPipe ? (BlockPipe)block : null;
        }
        return this.pipeBlock;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public int getBlockedConnections() {
        return this.canHaveBlockedFaces() ? this.blockedConnections : 0;
    }

    @Override
    public int getPaintingColor() {
        return this.isPainted() ? this.paintingColor : this.getDefaultPaintingColor();
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        if (!this.func_145831_w().field_72995_K) {
            ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.func_145831_w()))).updateMark(this.func_174877_v(), this.getCableMark());
            this.writeCustomData(-1, buffer -> buffer.writeInt(paintingColor));
            this.func_70296_d();
        }
    }

    @Override
    public boolean isPainted() {
        return this.paintingColor != -1;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return (this.connections & 1 << side.func_176745_a()) > 0;
    }

    @Override
    public void setConnection(EnumFacing side, boolean connected, boolean fromNeighbor) {
        if (!this.func_145831_w().field_72995_K) {
            if (this.isConnected(side) == connected) {
                return;
            }
            TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
            if (connected && tile instanceof IPipeTile && ((IPipeTile)tile).getPipeType().getClass() != this.getPipeType().getClass()) {
                return;
            }
            this.connections = this.withSideConnection(this.connections, side, connected);
            this.updateNetworkConnection(side, connected);
            this.writeCustomData(-2, buffer -> buffer.func_150787_b(this.connections));
            this.func_70296_d();
            if (!fromNeighbor && tile instanceof IPipeTile) {
                this.syncPipeConnections(side, (IPipeTile)tile);
            }
        }
    }

    private void syncPipeConnections(EnumFacing side, IPipeTile<?, ?> pipe) {
        EnumFacing oppositeSide = side.func_176734_d();
        boolean neighbourOpen = pipe.isConnected(oppositeSide);
        if (this.isConnected(side) == neighbourOpen) {
            return;
        }
        if (!neighbourOpen || pipe.getCoverableImplementation().getCoverAtSide(oppositeSide) == null) {
            pipe.setConnection(oppositeSide, !neighbourOpen, true);
        }
    }

    private void updateNetworkConnection(EnumFacing side, boolean connected) {
        Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.func_145831_w());
        ((WorldPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.func_174877_v(), side, !connected);
    }

    protected int withSideConnection(int blockedConnections, EnumFacing side, boolean connected) {
        int index = 1 << side.func_176745_a();
        if (connected) {
            return blockedConnections | index;
        }
        return blockedConnections & ~index;
    }

    @Override
    public void setFaceBlocked(EnumFacing side, boolean blocked) {
        if (!this.field_145850_b.field_72995_K && this.canHaveBlockedFaces()) {
            this.blockedConnections = this.withSideConnection(this.blockedConnections, side, blocked);
            this.writeCustomData(-6, buf -> buf.func_150787_b(this.blockedConnections));
            this.func_70296_d();
            Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.func_145831_w());
            Object net = ((WorldPipeNet)((Object)worldPipeNet)).getNetFromPos(this.field_174879_c);
            if (net != null) {
                ((PipeNet)net).onPipeConnectionsUpdate();
            }
        }
    }

    @Override
    public boolean isFaceBlocked(EnumFacing side) {
        return (this.blockedConnections & 1 << side.func_176745_a()) > 0;
    }

    @Override
    public PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    private int getCableMark() {
        return this.paintingColor == -1 ? 0 : this.paintingColor;
    }

    @Override
    public int getVisualConnections() {
        int connections = this.getConnections();
        float selfThickness = ((IPipeType)this.getPipeType()).getThickness();
        for (EnumFacing facing : EnumFacing.values()) {
            IPipeTile pipeTile;
            if (!this.isConnected(facing)) continue;
            TileEntity neighbourTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (neighbourTile instanceof IPipeTile && (pipeTile = (IPipeTile)neighbourTile).isConnected(facing.func_176734_d()) && ((IPipeType)pipeTile.getPipeType()).getThickness() < selfThickness) {
                connections |= 1 << facing.func_176745_a() + 6;
            }
            if (this.getCoverableImplementation().getCoverAtSide(facing) == null) continue;
            connections |= 1 << facing.func_176745_a() + 12;
        }
        return connections;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechTileCapabilities.CAPABILITY_COVERABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_COVERABLE.cast((Object)this.getCoverableImplementation());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public final <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        boolean isCoverable = capability == GregtechTileCapabilities.CAPABILITY_COVERABLE;
        CoverBehavior coverBehavior = facing == null ? null : this.coverableImplementation.getCoverAtSide(facing);
        T defaultValue = this.getPipeBlock() == null ? null : (T)this.getCapabilityInternal(capability, facing);
        if (isCoverable) {
            return defaultValue;
        }
        if (coverBehavior == null && facing != null) {
            return this.isConnected(facing) ? defaultValue : null;
        }
        if (coverBehavior != null) {
            return coverBehavior.getCapability(capability, defaultValue);
        }
        return defaultValue;
    }

    public final boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        BlockPipe<PipeType, NodeDataType, ?> pipeBlock = this.getPipeBlock();
        if (pipeBlock != null) {
            compound.func_74778_a("PipeBlock", pipeBlock.getRegistryName().toString());
        }
        compound.func_74768_a("PipeType", ((Enum)this.pipeType).ordinal());
        compound.func_74768_a("Connections", this.connections);
        compound.func_74768_a("BlockedConnections", this.blockedConnections);
        if (this.isPainted()) {
            compound.func_74768_a("InsulationColor", this.paintingColor);
        }
        compound.func_74778_a("FrameMaterial", this.frameMaterial == null ? "" : this.frameMaterial.toString());
        this.coverableImplementation.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        String frameMaterialName;
        super.func_145839_a(compound);
        if (compound.func_150297_b("PipeBlock", 8)) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("PipeBlock")));
            this.pipeBlock = block instanceof BlockPipe ? (BlockPipe)block : null;
        }
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[compound.func_74762_e("PipeType")];
        if (compound.func_74764_b("Connections")) {
            this.connections = compound.func_74762_e("Connections");
        } else if (compound.func_74764_b("BlockedConnectionsMap")) {
            this.connections = 0;
            NBTTagCompound blockedConnectionsTag = compound.func_74775_l("BlockedConnectionsMap");
            for (String attachmentTypeKey : blockedConnectionsTag.func_150296_c()) {
                int blockedConnections = blockedConnectionsTag.func_74762_e(attachmentTypeKey);
                this.connections |= blockedConnections;
            }
        }
        this.blockedConnections = compound.func_74762_e("BlockedConnections");
        if (compound.func_74764_b("InsulationColor")) {
            this.paintingColor = compound.func_74762_e("InsulationColor");
        }
        if (!(frameMaterialName = compound.func_74779_i("FrameMaterial")).isEmpty()) {
            this.frameMaterial = (Material)GregTechAPI.MATERIAL_REGISTRY.func_82594_a(frameMaterialName);
        }
        this.coverableImplementation.readFromNBT(compound);
    }

    public void onLoad() {
        super.onLoad();
        this.coverableImplementation.onLoad();
    }

    protected void writePipeProperties(PacketBuffer buf) {
        buf.func_150787_b(((Enum)this.pipeType).ordinal());
    }

    protected void readPipeProperties(PacketBuffer buf) {
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[buf.func_150792_a()];
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        this.writePipeProperties(buf);
        buf.func_150787_b(this.connections);
        buf.func_150787_b(this.blockedConnections);
        buf.writeInt(this.paintingColor);
        buf.func_150787_b(this.frameMaterial == null ? -1 : GregTechAPI.MATERIAL_REGISTRY.getIDForObject(this.frameMaterial));
        this.coverableImplementation.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.readPipeProperties(buf);
        this.connections = buf.func_150792_a();
        this.blockedConnections = buf.func_150792_a();
        this.paintingColor = buf.readInt();
        int frameMaterialId = buf.func_150792_a();
        this.frameMaterial = frameMaterialId < 0 ? null : (Material)GregTechAPI.MATERIAL_REGISTRY.getObjectById(frameMaterialId);
        this.coverableImplementation.readInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        if (discriminator == -1) {
            this.paintingColor = buf.readInt();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -2) {
            this.connections = buf.func_150792_a();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -3) {
            this.coverableImplementation.readCustomData(buf.func_150792_a(), buf);
        } else if (discriminator == -4) {
            this.readPipeProperties(buf);
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -6) {
            this.blockedConnections = buf.func_150792_a();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -7) {
            int frameMaterialId = buf.func_150792_a();
            this.frameMaterial = frameMaterialId < 0 ? null : (Material)GregTechAPI.MATERIAL_REGISTRY.getObjectById(frameMaterialId);
            this.scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeCoverCustomData(int id, Consumer<PacketBuffer> writer) {
        this.writeCustomData(-3, buffer -> {
            buffer.func_150787_b(id);
            writer.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        BlockPos pos = this.func_174877_v();
        this.func_145831_w().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        this.getPipeBlock().updateActiveNodeStatus(this.func_145831_w(), this.func_174877_v(), this);
    }

    @Override
    public void markAsDirty() {
        this.func_70296_d();
    }

    @Override
    public boolean isValidTile() {
        return !this.func_145837_r();
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void doExplosion(float explosionPower) {
        this.func_145831_w().func_175698_g(this.func_174877_v());
        if (!this.func_145831_w().field_72995_K) {
            ((WorldServer)this.func_145831_w()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 10, 0.2, 0.2, 0.2, 0.0, new int[0]);
        }
        this.func_145831_w().func_72876_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, explosionPower, false);
    }
}

