/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import com.google.common.base.Joiner;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.RelativeDirection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FactoryBlockPattern {
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    private final List<String[]> depth = new ArrayList<String[]>();
    private final List<int[]> aisleRepetitions = new ArrayList<int[]>();
    private final Map<Character, TraceabilityPredicate> symbolMap = new HashMap<Character, TraceabilityPredicate>();
    private int aisleHeight;
    private int rowWidth;
    private final RelativeDirection[] structureDir = new RelativeDirection[3];

    private FactoryBlockPattern(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir) {
        this.structureDir[0] = charDir;
        this.structureDir[1] = stringDir;
        this.structureDir[2] = aisleDir;
        int flags = 0;
        block5: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i]) {
                case UP: 
                case DOWN: {
                    flags |= 1;
                    continue block5;
                }
                case LEFT: 
                case RIGHT: {
                    flags |= 2;
                    continue block5;
                }
                case FRONT: 
                case BACK: {
                    flags |= 4;
                }
            }
        }
        if (flags != 7) {
            throw new IllegalArgumentException("Must have 3 different axes!");
        }
        this.symbolMap.put(Character.valueOf(' '), TraceabilityPredicate.ANY);
    }

    public FactoryBlockPattern aisleRepeatable(int minRepeat, int maxRepeat, String ... aisle) {
        if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
            if (this.depth.isEmpty()) {
                this.aisleHeight = aisle.length;
                this.rowWidth = aisle[0].length();
            }
            if (aisle.length != this.aisleHeight) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length + ")");
            }
            for (String s : aisle) {
                if (s.length() != this.rowWidth) {
                    throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + s.length() + ")");
                }
                for (char c0 : s.toCharArray()) {
                    if (this.symbolMap.containsKey(Character.valueOf(c0))) continue;
                    this.symbolMap.put(Character.valueOf(c0), null);
                }
            }
            this.depth.add(aisle);
            if (minRepeat > maxRepeat) {
                throw new IllegalArgumentException("Lower bound of repeat counting must smaller than upper bound!");
            }
            this.aisleRepetitions.add(new int[]{minRepeat, maxRepeat});
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public FactoryBlockPattern aisle(String ... aisle) {
        return this.aisleRepeatable(1, 1, aisle);
    }

    public FactoryBlockPattern setRepeatable(int minRepeat, int maxRepeat) {
        if (minRepeat > maxRepeat) {
            throw new IllegalArgumentException("Lower bound of repeat counting must smaller than upper bound!");
        }
        this.aisleRepetitions.set(this.aisleRepetitions.size() - 1, new int[]{minRepeat, maxRepeat});
        return this;
    }

    public FactoryBlockPattern setRepeatable(int repeatCount) {
        return this.setRepeatable(repeatCount, repeatCount);
    }

    public static FactoryBlockPattern start() {
        return new FactoryBlockPattern(RelativeDirection.RIGHT, RelativeDirection.UP, RelativeDirection.BACK);
    }

    public static FactoryBlockPattern start(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir) {
        return new FactoryBlockPattern(charDir, stringDir, aisleDir);
    }

    public FactoryBlockPattern where(char symbol, TraceabilityPredicate blockMatcher) {
        this.symbolMap.put(Character.valueOf(symbol), new TraceabilityPredicate(blockMatcher).sort());
        return this;
    }

    public BlockPattern build() {
        return new BlockPattern(this.makePredicateArray(), this.structureDir, (int[][])this.aisleRepetitions.toArray((T[])new int[this.aisleRepetitions.size()][]));
    }

    private TraceabilityPredicate[][][] makePredicateArray() {
        this.checkMissingPredicates();
        TraceabilityPredicate[][][] predicate = (TraceabilityPredicate[][][])Array.newInstance(TraceabilityPredicate.class, this.depth.size(), this.aisleHeight, this.rowWidth);
        for (int i = 0; i < this.depth.size(); ++i) {
            for (int j = 0; j < this.aisleHeight; ++j) {
                for (int k = 0; k < this.rowWidth; ++k) {
                    predicate[i][j][k] = this.symbolMap.get(Character.valueOf(this.depth.get(i)[j].charAt(k)));
                }
            }
        }
        return predicate;
    }

    private void checkMissingPredicates() {
        ArrayList<Character> list = new ArrayList<Character>();
        for (Map.Entry<Character, TraceabilityPredicate> entry : this.symbolMap.entrySet()) {
            if (entry.getValue() != null) continue;
            list.add(entry.getKey());
        }
        if (!list.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + COMMA_JOIN.join(list) + " are missing");
        }
    }
}

