/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.google.common.collect.ImmutableList;
import gregtech.api.items.toolitem.IGTToolDefinition;
import gregtech.api.items.toolitem.aoe.AoESymmetrical;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;

public class ToolDefinitionBuilder {
    private final List<IToolBehavior> behaviours = new ArrayList<IToolBehavior>();
    private int damagePerAction = 1;
    private int damagePerCraftingAction = 1;
    private boolean suitableForBlockBreaking = false;
    private boolean suitableForAttacking = false;
    private boolean suitableForCrafting = false;
    private int baseDurability = 0;
    private int baseQuality = 0;
    private float attackDamage = 0.0f;
    private float baseEfficiency = 4.0f;
    private float efficiencyMultiplier = 1.0f;
    private boolean isEnchantable;
    private BiPredicate<ItemStack, Enchantment> canApplyEnchantment;
    private float attackSpeed = 0.0f;
    private boolean sneakBypassUse = false;
    private Supplier<ItemStack> brokenStack = () -> ItemStack.field_190927_a;
    private AoESymmetrical aoeSymmetrical = AoESymmetrical.none();
    private final Set<Block> effectiveBlocks = new ObjectOpenHashSet();
    private final Set<Material> effectiveMaterials = new ObjectOpenHashSet();
    private Predicate<IBlockState> effectiveStates;

    public ToolDefinitionBuilder behaviors(IToolBehavior ... behaviours) {
        Collections.addAll(this.behaviours, behaviours);
        return this;
    }

    public ToolDefinitionBuilder damagePerAction(int damagePerAction) {
        this.damagePerAction = damagePerAction;
        return this;
    }

    public ToolDefinitionBuilder damagePerCraftingAction(int damagePerCraftingAction) {
        this.damagePerCraftingAction = damagePerCraftingAction;
        return this;
    }

    public ToolDefinitionBuilder blockBreaking() {
        this.suitableForBlockBreaking = true;
        return this;
    }

    public ToolDefinitionBuilder attacking() {
        this.suitableForAttacking = true;
        return this;
    }

    public ToolDefinitionBuilder crafting() {
        this.suitableForCrafting = true;
        return this;
    }

    public ToolDefinitionBuilder baseDurability(int baseDurability) {
        this.baseDurability = baseDurability;
        return this;
    }

    public ToolDefinitionBuilder baseQuality(int baseQuality) {
        this.baseQuality = baseQuality;
        return this;
    }

    public ToolDefinitionBuilder baseQuality() {
        return this.baseQuality(0);
    }

    public ToolDefinitionBuilder attackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
        return this;
    }

    public ToolDefinitionBuilder cannotAttack() {
        this.attackDamage = Float.MIN_VALUE;
        return this;
    }

    public ToolDefinitionBuilder baseEfficiency(float baseEfficiency) {
        this.baseEfficiency = baseEfficiency;
        return this;
    }

    public ToolDefinitionBuilder efficiencyMultiplier(float efficiencyMultiplier) {
        this.efficiencyMultiplier = efficiencyMultiplier;
        return this;
    }

    public ToolDefinitionBuilder noEnchant() {
        this.isEnchantable = false;
        return this;
    }

    public ToolDefinitionBuilder canApplyEnchantment(BiPredicate<ItemStack, Enchantment> canApplyEnchantment) {
        this.isEnchantable = true;
        this.canApplyEnchantment = canApplyEnchantment;
        return this;
    }

    public ToolDefinitionBuilder canApplyEnchantment(EnumEnchantmentType ... enchantmentTypes) {
        this.isEnchantable = true;
        this.canApplyEnchantment = (stack, enchantment) -> {
            for (EnumEnchantmentType type : enchantmentTypes) {
                if (type != enchantment.field_77351_y) continue;
                return true;
            }
            return false;
        };
        return this;
    }

    public ToolDefinitionBuilder attackSpeed(float attackSpeed) {
        this.attackSpeed = attackSpeed;
        return this;
    }

    public ToolDefinitionBuilder sneakBypassUse() {
        this.sneakBypassUse = true;
        return this;
    }

    public ToolDefinitionBuilder brokenStack(Supplier<ItemStack> brokenStack) {
        this.brokenStack = brokenStack;
        return this;
    }

    public ToolDefinitionBuilder aoe(AoESymmetrical aoeSymmetrical) {
        this.aoeSymmetrical = aoeSymmetrical;
        return this;
    }

    public ToolDefinitionBuilder aoe(int additionalColumns, int additionalRows, int additionalDepth) {
        return this.aoe(AoESymmetrical.of(additionalColumns, additionalRows, additionalDepth));
    }

    public ToolDefinitionBuilder effectiveBlocks(Block ... blocks) {
        Collections.addAll(this.effectiveBlocks, blocks);
        return this;
    }

    public ToolDefinitionBuilder effectiveMaterials(Material ... materials) {
        Collections.addAll(this.effectiveMaterials, materials);
        return this;
    }

    public ToolDefinitionBuilder effectiveStates(Predicate<IBlockState> effectiveStates) {
        this.effectiveStates = effectiveStates;
        return this;
    }

    public IGTToolDefinition build() {
        return new IGTToolDefinition(){
            private final List<IToolBehavior> behaviors;
            private final int damagePerAction;
            private final int damagePerCraftingAction;
            private final boolean suitableForBlockBreaking;
            private final boolean suitableForAttacking;
            private final boolean suitableForCrafting;
            private final int baseDurability;
            private final int baseQuality;
            private final float attackDamage;
            private final float baseEfficiency;
            private final float efficiencyMultiplier;
            private final boolean isEnchantable;
            private final BiPredicate<ItemStack, Enchantment> canApplyEnchantment;
            private final float attackSpeed;
            private final boolean sneakBypassUse;
            private final Supplier<ItemStack> brokenStack;
            private final AoESymmetrical aoeSymmetrical;
            private final Predicate<IBlockState> effectiveStatePredicate;
            {
                this.behaviors = ImmutableList.copyOf((Collection)ToolDefinitionBuilder.this.behaviours);
                this.damagePerAction = ToolDefinitionBuilder.this.damagePerAction;
                this.damagePerCraftingAction = ToolDefinitionBuilder.this.damagePerCraftingAction;
                this.suitableForBlockBreaking = ToolDefinitionBuilder.this.suitableForBlockBreaking;
                this.suitableForAttacking = ToolDefinitionBuilder.this.suitableForAttacking;
                this.suitableForCrafting = ToolDefinitionBuilder.this.suitableForCrafting;
                this.baseDurability = ToolDefinitionBuilder.this.baseDurability;
                this.baseQuality = ToolDefinitionBuilder.this.baseQuality;
                this.attackDamage = ToolDefinitionBuilder.this.attackDamage;
                this.baseEfficiency = ToolDefinitionBuilder.this.baseEfficiency;
                this.efficiencyMultiplier = ToolDefinitionBuilder.this.efficiencyMultiplier;
                this.isEnchantable = ToolDefinitionBuilder.this.isEnchantable;
                this.canApplyEnchantment = ToolDefinitionBuilder.this.canApplyEnchantment;
                this.attackSpeed = ToolDefinitionBuilder.this.attackSpeed;
                this.sneakBypassUse = ToolDefinitionBuilder.this.sneakBypassUse;
                this.brokenStack = ToolDefinitionBuilder.this.brokenStack;
                this.aoeSymmetrical = ToolDefinitionBuilder.this.aoeSymmetrical;
                Set effectiveBlocks = ToolDefinitionBuilder.this.effectiveBlocks;
                Set effectiveMaterials = ToolDefinitionBuilder.this.effectiveMaterials;
                Predicate<Object> effectiveStates = ToolDefinitionBuilder.this.effectiveStates;
                Predicate<Object> effectiveStatePredicate = null;
                if (!effectiveBlocks.isEmpty()) {
                    effectiveStatePredicate = state -> effectiveBlocks.contains(state.func_177230_c());
                }
                if (!effectiveMaterials.isEmpty()) {
                    Predicate<Object> predicate = effectiveStatePredicate = effectiveStatePredicate == null ? state -> effectiveMaterials.contains(state.func_185904_a()) : effectiveStatePredicate.or(state -> effectiveMaterials.contains(state.func_185904_a()));
                }
                if (effectiveStates != null) {
                    effectiveStatePredicate = effectiveStatePredicate == null ? effectiveStates : effectiveStatePredicate.or(effectiveStates);
                }
                this.effectiveStatePredicate = effectiveStatePredicate == null ? state -> false : effectiveStatePredicate;
            }

            @Override
            public List<IToolBehavior> getBehaviors() {
                return this.behaviors;
            }

            @Override
            public boolean isToolEffective(IBlockState state) {
                return this.effectiveStatePredicate.test(state);
            }

            @Override
            public int getDamagePerCraftingAction(ItemStack stack) {
                return this.damagePerCraftingAction;
            }

            @Override
            public int getDamagePerAction(ItemStack stack) {
                return this.damagePerAction;
            }

            @Override
            public boolean isSuitableForBlockBreak(ItemStack stack) {
                return this.suitableForBlockBreaking;
            }

            @Override
            public boolean isSuitableForAttacking(ItemStack stack) {
                return this.suitableForAttacking;
            }

            @Override
            public boolean isSuitableForCrafting(ItemStack stack) {
                return this.suitableForCrafting;
            }

            @Override
            public int getBaseDurability(ItemStack stack) {
                return this.baseDurability;
            }

            @Override
            public int getBaseQuality(ItemStack stack) {
                return this.baseQuality;
            }

            @Override
            public float getBaseDamage(ItemStack stack) {
                return this.attackDamage;
            }

            @Override
            public float getBaseEfficiency(ItemStack stack) {
                return this.baseEfficiency;
            }

            @Override
            public float getEfficiencyMultiplier(ItemStack stack) {
                return this.efficiencyMultiplier;
            }

            @Override
            public boolean isEnchantable(ItemStack stack) {
                return this.isEnchantable;
            }

            @Override
            public boolean canApplyEnchantment(ItemStack stack, Enchantment enchantment) {
                return this.canApplyEnchantment.test(stack, enchantment);
            }

            @Override
            public float getAttackSpeed(ItemStack stack) {
                return this.attackSpeed;
            }

            @Override
            public boolean doesSneakBypassUse() {
                return this.sneakBypassUse;
            }

            @Override
            public ItemStack getBrokenStack() {
                return this.brokenStack.get();
            }

            @Override
            public AoESymmetrical getAoEDefinition(ItemStack stack) {
                return this.aoeSymmetrical;
            }
        };
    }
}

