/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import gregtech.api.items.toolitem.aoe.AoESymmetrical;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;

public interface IGTToolDefinition {
    public List<IToolBehavior> getBehaviors();

    public boolean isToolEffective(IBlockState var1);

    public int getDamagePerAction(ItemStack var1);

    public int getDamagePerCraftingAction(ItemStack var1);

    public boolean isSuitableForBlockBreak(ItemStack var1);

    public boolean isSuitableForAttacking(ItemStack var1);

    public boolean isSuitableForCrafting(ItemStack var1);

    default public int getToolDamagePerBlockBreak(ItemStack stack) {
        int action = this.getDamagePerAction(stack);
        return this.isSuitableForBlockBreak(stack) ? action : action * 2;
    }

    default public int getToolDamagePerAttack(ItemStack stack) {
        int action = this.getDamagePerAction(stack);
        return this.isSuitableForAttacking(stack) ? action : action * 2;
    }

    default public int getToolDamagePerCraft(ItemStack stack) {
        int action = this.getDamagePerCraftingAction(stack);
        return this.isSuitableForCrafting(stack) ? action : action * 2;
    }

    default public int getBaseDurability(ItemStack stack) {
        return 0;
    }

    default public int getBaseQuality(ItemStack stack) {
        return 0;
    }

    default public float getBaseDamage(ItemStack stack) {
        return 1.0f;
    }

    default public float getBaseEfficiency(ItemStack stack) {
        return 1.0f;
    }

    default public float getEfficiencyMultiplier(ItemStack stack) {
        return 1.0f;
    }

    default public float getAttackSpeed(ItemStack stack) {
        return 0.0f;
    }

    default public AoESymmetrical getAoEDefinition(ItemStack stack) {
        return AoESymmetrical.none();
    }

    default public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean canApplyEnchantment(ItemStack var1, Enchantment var2);

    public boolean doesSneakBypassUse();

    default public ItemStack getBrokenStack() {
        return ItemStack.field_190927_a;
    }
}

