/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import appeng.api.implementations.items.IAEWrench;
import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.tool.ITool;
import forestry.api.arboriculture.IToolGrafter;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.impl.CombinedCapabilityProvider;
import gregtech.api.capability.impl.ElectricItem;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.DynamicLabelWidget;
import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.ElectricStats;
import gregtech.api.items.toolitem.IGTToolDefinition;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.aoe.AoESymmetrical;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.ToolChargeBarRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

@Optional.InterfaceList(value={@Optional.Interface(modid="appliedenergistics2", iface="appeng.api.implementations.items.IAEWrench"), @Optional.Interface(modid="buildcraftcore", iface="buildcraft.api.tools.IToolWrench"), @Optional.Interface(modid="cofhcore", iface="cofh.api.item.IToolHammer"), @Optional.Interface(modid="enderio", iface="crazypants.enderio.api.tool.ITool"), @Optional.Interface(modid="forestry", iface="forestry.api.arboriculture.IToolGrafter"), @Optional.Interface(modid="endercore", iface="com.enderio.core.common.interfaces.IOverlayRenderAware")})
public interface IGTTool
extends ItemUIFactory,
IAEWrench,
IToolWrench,
IToolHammer,
ITool,
IToolGrafter,
IOverlayRenderAware {
    public String getDomain();

    public String getId();

    public boolean isElectric();

    public int getElectricTier();

    public IGTToolDefinition getToolStats();

    @Nullable
    public SoundEvent getSound();

    public boolean playSoundOnBlockDestroy();

    @Nullable
    public String getOreDictName();

    @Nullable
    public Supplier<ItemStack> getMarkerItem();

    default public Item get() {
        return (Item)this;
    }

    default public ItemStack getRaw() {
        ItemStack stack = new ItemStack(this.get());
        ToolHelper.getToolTag(stack);
        ToolHelper.getBehaviorsTag(stack);
        return stack;
    }

    default public ItemStack get(Material material) {
        ItemStack stack = new ItemStack(this.get());
        NBTTagCompound stackCompound = GTUtility.getOrCreateNbtCompound(stack);
        stackCompound.func_74757_a("DisallowContainerItem", false);
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        stackCompound.func_74768_a("HideFlags", 2);
        toolTag.func_74778_a("Material", material.toString());
        ToolProperty toolProperty = material.getProperty(PropertyKey.TOOL);
        toolTag.func_74768_a("MaxDurability", toolProperty.getToolDurability());
        toolTag.func_74768_a("Durability", 0);
        if (toolProperty.getUnbreakable()) {
            stackCompound.func_74757_a("Unbreakable", true);
        }
        toolProperty.getEnchantments().forEach((enchantment, level) -> {
            if (stack.func_77973_b().canApplyAtEnchantingTable(stack, enchantment)) {
                stack.func_77966_a(enchantment, level.intValue());
            }
        });
        NBTTagCompound behaviourTag = ToolHelper.getBehaviorsTag(stack);
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.addBehaviorNBT(stack, behaviourTag));
        AoESymmetrical aoeDefinition = this.getToolStats().getAoEDefinition(stack);
        if (aoeDefinition != AoESymmetrical.none()) {
            behaviourTag.func_74768_a("MaxAoEColumn", aoeDefinition.column);
            behaviourTag.func_74768_a("MaxAoERow", aoeDefinition.row);
            behaviourTag.func_74768_a("MaxAoELayer", aoeDefinition.layer);
            behaviourTag.func_74768_a("AoEColumn", aoeDefinition.column);
            behaviourTag.func_74768_a("AoERow", aoeDefinition.row);
            behaviourTag.func_74768_a("AoELayer", aoeDefinition.layer);
        }
        if (toolProperty.isMagnetic()) {
            behaviourTag.func_74757_a("RelocateMinedBlocks", true);
        }
        return stack;
    }

    default public ItemStack get(Material material, long defaultCharge, long defaultMaxCharge) {
        ElectricItem electricItem;
        ItemStack stack = this.get(material);
        if (this.isElectric() && (electricItem = (ElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) != null) {
            electricItem.setMaxChargeOverride(defaultMaxCharge);
            electricItem.setCharge(defaultCharge);
        }
        return stack;
    }

    default public ItemStack get(Material material, long defaultMaxCharge) {
        return this.get(material, defaultMaxCharge, defaultMaxCharge);
    }

    default public Material getToolMaterial(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        String string = toolTag.func_74779_i("Material");
        Material material = GregTechAPI.MaterialRegistry.get(string);
        if (material == null) {
            material = Materials.Neutronium;
            toolTag.func_74778_a("Material", material.toString());
        }
        return material;
    }

    @Nullable
    default public ToolProperty getToolProperty(ItemStack stack) {
        return this.getToolMaterial(stack).getProperty(PropertyKey.TOOL);
    }

    @Nullable
    default public DustProperty getDustProperty(ItemStack stack) {
        return this.getToolMaterial(stack).getProperty(PropertyKey.DUST);
    }

    default public float getMaterialToolSpeed(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getToolSpeed();
    }

    default public float getMaterialAttackDamage(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getToolAttackDamage();
    }

    default public float getMaterialAttackSpeed(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getToolAttackSpeed();
    }

    default public int getMaterialDurability(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getToolDurability();
    }

    default public int getMaterialEnchantability(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getToolEnchantability();
    }

    default public int getMaterialHarvestLevel(ItemStack stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getToolHarvestLevel();
    }

    default public long getMaxCharge(ItemStack stack) {
        NBTTagCompound tag;
        if (this.isElectric() && (tag = stack.func_77978_p()) != null && tag.func_150297_b("MaxCharge", 4)) {
            return tag.func_74763_f("MaxCharge");
        }
        return -1L;
    }

    default public long getCharge(ItemStack stack) {
        NBTTagCompound tag;
        if (this.isElectric() && (tag = stack.func_77978_p()) != null && tag.func_150297_b("Charge", 4)) {
            return tag.func_74763_f("Charge");
        }
        return -1L;
    }

    default public float getTotalToolSpeed(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("ToolSpeed", 5)) {
            return toolTag.func_74760_g("ToolSpeed");
        }
        float toolSpeed = this.getToolStats().getEfficiencyMultiplier(stack) * this.getMaterialToolSpeed(stack) + this.getToolStats().getBaseEfficiency(stack);
        toolTag.func_74776_a("ToolSpeed", toolSpeed);
        return toolSpeed;
    }

    default public float getTotalAttackDamage(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("AttackDamage", 5)) {
            return toolTag.func_74760_g("AttackDamage");
        }
        float baseDamage = this.getToolStats().getBaseDamage(stack);
        float attackDamage = 0.0f;
        if (baseDamage != Float.MIN_VALUE) {
            attackDamage = this.getMaterialAttackDamage(stack) + baseDamage;
        }
        toolTag.func_74776_a("AttackDamage", attackDamage);
        return attackDamage;
    }

    default public float getTotalAttackSpeed(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("AttackSpeed", 5)) {
            return toolTag.func_74760_g("AttackSpeed");
        }
        float attackSpeed = this.getMaterialAttackSpeed(stack) + this.getToolStats().getAttackSpeed(stack);
        toolTag.func_74776_a("AttackSpeed", attackSpeed);
        return attackSpeed;
    }

    default public int getTotalMaxDurability(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("MaxDurability", 3)) {
            return toolTag.func_74762_e("MaxDurability");
        }
        int maxDurability = this.getMaterialDurability(stack) + this.getToolStats().getBaseDurability(stack);
        toolTag.func_74768_a("MaxDurability", maxDurability);
        return maxDurability;
    }

    default public int getTotalEnchantability(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("Enchantability", 3)) {
            return toolTag.func_74762_e("Enchantability");
        }
        int enchantability = this.getMaterialEnchantability(stack);
        toolTag.func_74768_a("Enchantability", enchantability);
        return enchantability;
    }

    default public int getTotalHarvestLevel(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("HarvestLevel", 3)) {
            return toolTag.func_74762_e("HarvestLevel");
        }
        int harvestLevel = this.getMaterialHarvestLevel(stack) + this.getToolStats().getBaseQuality(stack);
        toolTag.func_74768_a("HarvestLevel", harvestLevel);
        return harvestLevel;
    }

    default public AoESymmetrical getMaxAoEDefinition(ItemStack stack) {
        return AoESymmetrical.readMax(ToolHelper.getBehaviorsTag(stack));
    }

    default public AoESymmetrical getAoEDefinition(ItemStack stack) {
        return AoESymmetrical.read(ToolHelper.getToolTag(stack), this.getMaxAoEDefinition(stack));
    }

    default public float definition$getDestroySpeed(ItemStack stack, IBlockState state) {
        float specialValue = ToolHelper.getDestroySpeed(state, this.getToolClasses(stack));
        if (specialValue != -1.0f) {
            return specialValue;
        }
        if (ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
            return this.getTotalToolSpeed(stack);
        }
        return this.getToolStats().isToolEffective(state) ? this.getTotalToolSpeed(stack) : 1.0f;
    }

    default public boolean definition$hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.hitEntity(stack, target, attacker));
        ToolHelper.damageItem(stack, attacker, this.getToolStats().getToolDamagePerAttack(stack));
        return true;
    }

    default public boolean definition$onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockStartBreak(stack, pos, player));
        if (!player.func_70093_af()) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            int result = -1;
            if (ToolHelper.isTool(stack, "shears")) {
                result = ToolHelper.shearBlockRoutine(playerMP, stack, pos);
            }
            if (result != 0) {
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                state = state.func_177230_c().func_176221_a(state, (IBlockAccess)player.field_70170_p, pos);
                boolean effective = false;
                for (String type : this.getToolClasses(stack)) {
                    if (!state.func_177230_c().isToolEffective(type, state)) continue;
                    effective = true;
                    break;
                }
                if (effective |= ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
                    if (ToolHelper.areaOfEffectBlockBreakRoutine(stack, playerMP)) {
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else if (result == -1) {
                        ToolHelper.treeFellingRoutine(playerMP, stack, pos);
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    default public boolean definition$onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K) {
            this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockDestroyed(stack, worldIn, state, pos, entityLiving));
            if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
                ToolHelper.damageItem(stack, entityLiving, this.getToolStats().getToolDamagePerBlockBreak(stack));
            }
            if (entityLiving instanceof EntityPlayer && this.playSoundOnBlockDestroy() && entityLiving.func_70093_af()) {
                this.playSound((EntityPlayer)entityLiving);
            }
        }
        return true;
    }

    default public boolean definition$getIsRepairable(ItemStack toRepair, ItemStack repair) {
        if (toRepair.func_77952_i() == 0) {
            return false;
        }
        if (repair.func_77973_b() instanceof IGTTool) {
            return this.getToolMaterial(toRepair) == ((IGTTool)repair.func_77973_b()).getToolMaterial(repair);
        }
        UnificationEntry entry = OreDictUnifier.getUnificationEntry(repair);
        if (entry == null || entry.material == null) {
            return false;
        }
        if (entry.material == this.getToolMaterial(toRepair)) {
            if (ModHandler.isMaterialWood(entry.material)) {
                return entry.orePrefix == OrePrefix.plank;
            }
            if (entry.orePrefix == OrePrefix.plate) {
                return true;
            }
            if (entry.material.hasProperty(PropertyKey.INGOT)) {
                return entry.orePrefix == OrePrefix.ingot;
            }
            if (entry.material.hasProperty(PropertyKey.GEM)) {
                return entry.orePrefix == OrePrefix.gem;
            }
        }
        return false;
    }

    default public Multimap<String, AttributeModifier> definition$getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(IArmorLogic.ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)this.getTotalAttackDamage(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(IArmorLogic.ATTACK_SPEED_MODIFIER, "Weapon modifier", Math.max(-3.9, (double)this.getTotalAttackSpeed(stack)), 0));
        }
        return multimap;
    }

    default public int definition$getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return this.get().getToolClasses(stack).contains(toolClass) ? this.getTotalHarvestLevel(stack) : -1;
    }

    default public boolean definition$canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return this.getToolStats().getBehaviors().stream().anyMatch(behavior -> behavior.canDisableShield(stack, shield, entity, attacker));
    }

    default public boolean definition$doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.getToolStats().doesSneakBypassUse();
    }

    default public boolean definition$shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77952_i() < newStack.func_77952_i();
    }

    default public boolean definition$hasContainerItem(ItemStack stack) {
        return stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("DisallowContainerItem");
    }

    default public ItemStack definition$getContainerItem(ItemStack stack) {
        if (!this.definition$hasContainerItem(stack)) {
            return ItemStack.field_190927_a;
        }
        stack = stack.func_77946_l();
        EntityPlayer player = ForgeHooks.getCraftingPlayer();
        ToolHelper.damageItemWhenCrafting(stack, (EntityLivingBase)player);
        this.playCraftingSound(player, stack);
        if (stack.func_190926_b()) {
            return this.getToolStats().getBrokenStack();
        }
        return stack;
    }

    default public boolean definition$shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.getCharge(oldStack) != this.getCharge(newStack)) {
            return slotChanged;
        }
        return !oldStack.equals(newStack);
    }

    default public boolean definition$onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onEntitySwing(entityLiving, stack));
        return false;
    }

    default public boolean definition$canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return true;
    }

    default public boolean definition$isDamaged(ItemStack stack) {
        return this.definition$getDamage(stack) > 0;
    }

    default public int definition$getDamage(ItemStack stack) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.func_150297_b("Durability", 3)) {
            return toolTag.func_74762_e("Durability");
        }
        toolTag.func_74768_a("Durability", 0);
        return 0;
    }

    default public int definition$getMaxDamage(ItemStack stack) {
        return this.getTotalMaxDurability(stack);
    }

    default public void definition$setDamage(ItemStack stack, int durability) {
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        toolTag.func_74768_a("Durability", durability);
    }

    default public double definition$getDurabilityForDisplay(ItemStack stack) {
        int damage = stack.func_77973_b().getDamage(stack);
        int maxDamage = stack.func_77973_b().getMaxDamage(stack);
        if (damage == 0) {
            return 1.0;
        }
        return (double)(maxDamage - damage) / (double)maxDamage;
    }

    @Nullable
    default public ICapabilityProvider definition$initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        if (this.isElectric()) {
            providers.add(ElectricStats.createElectricItem(0L, this.getElectricTier()).createProvider(stack));
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            ICapabilityProvider behaviorProvider = behavior.createProvider(stack, nbt);
            if (behaviorProvider == null) continue;
            providers.add(behaviorProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ICapabilityProvider)providers.get(0);
        }
        return new CombinedCapabilityProvider(providers);
    }

    default public EnumActionResult definition$onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUseFirst(player, world, pos, facing, hitX, hitY, hitZ, hand) != EnumActionResult.SUCCESS) continue;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    default public EnumActionResult definition$onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ) != EnumActionResult.SUCCESS) continue;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    default public ActionResult<ItemStack> definition$onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af() && this.getMaxAoEDefinition(stack) != AoESymmetrical.none()) {
            PlayerInventoryHolder.openHandItemUI(player, hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemRightClick(world, player, hand).func_188397_a() != EnumActionResult.SUCCESS) continue;
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    default public void definition$getSubItems(@Nonnull NonNullList<ItemStack> items) {
        if (this.getMarkerItem() != null) {
            items.add((Object)this.getMarkerItem().get());
        } else if (this.isElectric()) {
            items.add((Object)this.get(Materials.Iron, Integer.MAX_VALUE));
        } else {
            items.add((Object)this.get(Materials.Iron));
        }
    }

    @SideOnly(value=Side.CLIENT)
    default public void definition$addInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound behaviorsTag;
        if (!(stack.func_77973_b() instanceof IGTTool)) {
            return;
        }
        IGTTool tool = (IGTTool)stack.func_77973_b();
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        IGTToolDefinition toolStats = tool.getToolStats();
        if (this.isElectric()) {
            tooltip.add(I18n.func_135052_a((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{this.getCharge(stack), this.getMaxCharge(stack), GTValues.VNF[this.getElectricTier()]}));
        }
        if (!tagCompound.func_74767_n("Unbreakable")) {
            int damageRemaining = tool.getTotalMaxDurability(stack) - stack.func_77952_i();
            if (toolStats.isSuitableForCrafting(stack)) {
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.crafting_uses", (Object[])new Object[]{GTUtility.formatNumbers(damageRemaining / Math.max(1, toolStats.getToolDamagePerCraft(stack)))}));
            }
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.general_uses", (Object[])new Object[]{GTUtility.formatNumbers(damageRemaining)}));
        }
        if (toolStats.isSuitableForAttacking(stack)) {
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.attack_damage", (Object[])new Object[]{GTUtility.formatNumbers(2.0f + tool.getTotalAttackDamage(stack))}));
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.attack_speed", (Object[])new Object[]{GTUtility.formatNumbers(4.0f + tool.getTotalAttackSpeed(stack))}));
        }
        if (toolStats.isSuitableForBlockBreak(stack)) {
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.mining_speed", (Object[])new Object[]{GTUtility.formatNumbers(tool.getTotalToolSpeed(stack))}));
            int harvestLevel = tool.getTotalHarvestLevel(stack);
            String harvestName = "item.gt.tool.harvest_level." + harvestLevel;
            if (I18n.func_188566_a((String)harvestName)) {
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.harvest_level_extra", (Object[])new Object[]{harvestLevel, I18n.func_135052_a((String)harvestName, (Object[])new Object[0])}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.harvest_level", (Object[])new Object[]{harvestLevel}));
            }
        }
        boolean addedBehaviorNewLine = false;
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition != AoESymmetrical.none()) {
            addedBehaviorNewLine = tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.aoe_mining", (Object[])new Object[]{aoeDefinition.column * 2 + 1, aoeDefinition.row * 2 + 1, aoeDefinition.layer + 1}));
        }
        if ((behaviorsTag = ToolHelper.getBehaviorsTag(stack)).func_74767_n("RelocateMinedBlocks")) {
            if (!addedBehaviorNewLine) {
                addedBehaviorNewLine = true;
                tooltip.add("");
            }
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.relocate_mining", (Object[])new Object[0]));
        }
        if (!addedBehaviorNewLine && !toolStats.getBehaviors().isEmpty()) {
            tooltip.add("");
        }
        toolStats.getBehaviors().forEach(behavior -> behavior.addInformation(stack, world, tooltip, flag));
        String uniqueTooltip = "item.gt.tool." + this.getId() + ".tooltip";
        if (I18n.func_188566_a((String)uniqueTooltip)) {
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)uniqueTooltip, (Object[])new Object[0]));
        }
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"item.gt.tool.usable_as", (Object[])new Object[]{stack.func_77973_b().getToolClasses(stack).stream().map(GTUtility::convertUnderscoreToSpace).map(WordUtils::capitalize).collect(Collectors.joining(", "))}));
        if (TooltipHelper.isShiftDown()) {
            Material material = this.getToolMaterial(stack);
            String materialName = I18n.func_135052_a((String)this.getToolMaterial(stack).getUnlocalizedName(), (Object[])new Object[0]);
            ArrayList<String> repairItems = new ArrayList<String>();
            if (ModHandler.isMaterialWood(material)) {
                repairItems.add(I18n.func_135052_a((String)"item.material.oreprefix.plank", (Object[])new Object[]{materialName}));
            } else {
                if (material.hasProperty(PropertyKey.INGOT)) {
                    repairItems.add(I18n.func_135052_a((String)"item.material.oreprefix.ingot", (Object[])new Object[]{materialName}));
                } else if (material.hasProperty(PropertyKey.GEM)) {
                    repairItems.add(I18n.func_135052_a((String)"item.material.oreprefix.gem", (Object[])new Object[]{materialName}));
                }
                repairItems.add(I18n.func_135052_a((String)"item.material.oreprefix.plate", (Object[])new Object[]{materialName}));
            }
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.repair_material", (Object[])new Object[]{String.join((CharSequence)", ", repairItems)}));
            if (this.isElectric()) {
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.replace_tool_head", (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.repair_info", (Object[])new Object[0]));
        }
    }

    default public boolean definition$canApplyAtEnchantingTable(@Nonnull ItemStack stack, Enchantment enchantment) {
        if (stack.func_190926_b()) {
            return false;
        }
        switch (enchantment.func_77320_a()) {
            case "enchantment.cofhcore.smashing": {
                return false;
            }
            case "enchantment.autosmelt": 
            case "enchantment.cofhcore.smelting": 
            case "enchantment.as.smelting": {
                return this.getToolStats().getAoEDefinition(stack) == AoESymmetrical.none() && !ToolHelper.getBehaviorsTag(stack).func_74764_b("TreeFelling");
            }
        }
        if (this.isElectric() && (enchantment instanceof EnchantmentMending || enchantment instanceof EnchantmentDurability)) {
            return false;
        }
        if (enchantment.field_77351_y == null) {
            return true;
        }
        switch (enchantment.field_77351_y) {
            case DIGGER: {
                return this.getToolStats().isSuitableForBlockBreak(stack);
            }
            case WEAPON: {
                return this.getToolStats().isSuitableForAttacking(stack);
            }
            case BREAKABLE: {
                return stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("Unbreakable");
            }
            case ALL: {
                return true;
            }
        }
        ToolProperty property = this.getToolProperty(stack);
        if (property == null) {
            return false;
        }
        if (!property.getEnchantments().isEmpty() && property.getEnchantments().containsKey((Object)enchantment)) {
            return true;
        }
        return this.getToolStats().isEnchantable(stack) && this.getToolStats().canApplyEnchantment(stack, enchantment);
    }

    @SideOnly(value=Side.CLIENT)
    default public int getColor(ItemStack stack, int tintIndex) {
        return tintIndex % 2 == 1 ? this.getToolMaterial(stack).getMaterialRGB() : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    default public String getModelPath() {
        return this.getDomain() + ":tools/" + this.getId();
    }

    @SideOnly(value=Side.CLIENT)
    default public ModelResourceLocation getModelLocation() {
        return new ModelResourceLocation(this.getModelPath(), "inventory");
    }

    default public void playCraftingSound(EntityPlayer player, ItemStack stack) {
        if (ConfigHolder.client.toolCraftingSounds && this.getSound() != null && player != null && this.canPlaySound(stack)) {
            this.setLastCraftingSoundTime(stack);
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    default public void setLastCraftingSoundTime(ItemStack stack) {
        ToolHelper.getToolTag(stack).func_74768_a("LastCraftingUse", (int)System.currentTimeMillis());
    }

    default public boolean canPlaySound(ItemStack stack) {
        return Math.abs((int)System.currentTimeMillis() - ToolHelper.getToolTag(stack).func_74762_e("LastCraftingUse")) > 1000;
    }

    default public void playSound(EntityPlayer player) {
        if (ConfigHolder.client.toolUseSounds && this.getSound() != null) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    default public ModularUI createUI(PlayerInventoryHolder holder, EntityPlayer entityPlayer) {
        NBTTagCompound tag = ToolHelper.getBehaviorsTag(holder.getCurrentItem());
        AoESymmetrical defaultDefinition = this.getMaxAoEDefinition(holder.getCurrentItem());
        return ModularUI.builder(GuiTextures.BORDERED_BACKGROUND, 120, 80).label(6, 10, "item.gt.tool.aoe.columns").label(49, 10, "item.gt.tool.aoe.rows").label(79, 10, "item.gt.tool.aoe.layers").widget(new ClickButtonWidget(15, 24, 20, 20, "+", data -> {
            AoESymmetrical.increaseColumn(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget(new ClickButtonWidget(15, 44, 20, 20, "-", data -> {
            AoESymmetrical.decreaseColumn(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget(new ClickButtonWidget(50, 24, 20, 20, "+", data -> {
            AoESymmetrical.increaseRow(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget(new ClickButtonWidget(50, 44, 20, 20, "-", data -> {
            AoESymmetrical.decreaseRow(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget(new ClickButtonWidget(85, 24, 20, 20, "+", data -> {
            AoESymmetrical.increaseLayer(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget(new ClickButtonWidget(85, 44, 20, 20, "-", data -> {
            AoESymmetrical.decreaseLayer(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget(new DynamicLabelWidget(23, 65, () -> Integer.toString(1 + 2 * AoESymmetrical.getColumn(ToolHelper.getBehaviorsTag(holder.getCurrentItem()), defaultDefinition)))).widget(new DynamicLabelWidget(58, 65, () -> Integer.toString(1 + 2 * AoESymmetrical.getRow(ToolHelper.getBehaviorsTag(holder.getCurrentItem()), defaultDefinition)))).widget(new DynamicLabelWidget(93, 65, () -> Integer.toString(1 + AoESymmetrical.getLayer(ToolHelper.getBehaviorsTag(holder.getCurrentItem()), defaultDefinition)))).build(holder, entityPlayer);
    }

    public Set<String> getToolClasses(ItemStack var1);

    default public boolean canWrench(ItemStack wrench, EntityPlayer player, BlockPos pos) {
        return this.get().getToolClasses(wrench).contains("wrench");
    }

    default public boolean canWrench(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        return this.get().getToolClasses(wrench).contains("wrench");
    }

    default public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        ToolHelper.damageItem(player.func_184586_b(hand), (EntityLivingBase)player);
        this.playSound(player);
    }

    default public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        return this.get().getToolClasses(item).contains("wrench");
    }

    default public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        return this.get().getToolClasses(item).contains("wrench");
    }

    default public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
        ToolHelper.damageItem(item, user);
        if (user instanceof EntityPlayer) {
            this.playSound((EntityPlayer)user);
        }
    }

    default public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
        ToolHelper.damageItem(item, user);
    }

    default public boolean canUse(@Nonnull EnumHand hand, @Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
        return this.get().getToolClasses(player.func_184586_b(hand)).contains("wrench");
    }

    default public void used(@Nonnull EnumHand hand, @Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
        ToolHelper.damageItem(player.func_184586_b(hand), (EntityLivingBase)player);
        this.playSound(player);
    }

    default public boolean shouldHideFacades(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return this.get().getToolClasses(stack).contains("wrench");
    }

    default public float getSaplingModifier(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        return this.getToolClasses(stack).contains("grafter") ? 100.0f : 1.0f;
    }

    default public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        ToolChargeBarRenderer.renderBarsTool(this, stack, xPosition, yPosition);
    }
}

