/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ResourceHelper {
    private static final Map<String, ResourceLocation> cachedResources = new HashMap<String, ResourceLocation>();
    public static final String RESOURCE_PREFIX = "gregtech:";

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static ResourceLocation getResource(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(RESOURCE_PREFIX + rs));
        }
        return cachedResources.get(rs);
    }

    public static ResourceLocation getResourceRAW(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(rs));
        }
        return cachedResources.get(rs);
    }

    public static void bindTexture(String rs) {
        ResourceHelper.bindTexture(ResourceHelper.getResource(rs));
    }

    public static boolean isResourceExist(String rs) {
        if (!cachedResources.containsKey(rs)) {
            InputStream inputstream = ResourceHelper.class.getResourceAsStream(String.format("/assets/%s/%s", "gregtech", rs));
            if (inputstream == null) {
                return false;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            cachedResources.put(rs, new ResourceLocation("gregtech", rs));
        }
        return true;
    }

    public static boolean isTextureExist(ResourceLocation textureResource) {
        InputStream inputstream = ResourceHelper.class.getResourceAsStream(String.format("/assets/%s/textures/%s.png", textureResource.func_110624_b(), textureResource.func_110623_a()));
        if (inputstream == null) {
            return false;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return true;
    }
}

