/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import com.google.common.base.Preconditions;
import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ISizeProvider;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.TooltipHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Widget {
    protected transient ModularUI gui;
    protected transient ISizeProvider sizes;
    protected transient WidgetUIAccess uiAccess;
    private transient Position parentPosition = Position.ORIGIN;
    private transient Position selfPosition;
    private transient Position position;
    private transient Size size;
    private transient boolean isVisible;
    private transient boolean isActive;

    public Widget(Position selfPosition, Size size) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.selfPosition = selfPosition;
        this.size = size;
        this.position = this.parentPosition.add(selfPosition);
        this.isVisible = true;
        this.isActive = true;
    }

    public Widget(int x, int y, int width, int height) {
        this(new Position(x, y), new Size(width, height));
    }

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public void setSizes(ISizeProvider sizes) {
        this.sizes = sizes;
    }

    public void setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
    }

    public void setParentPosition(Position parentPosition) {
        Preconditions.checkNotNull((Object)parentPosition, (Object)"parentPosition");
        this.parentPosition = parentPosition;
        this.recomputePosition();
    }

    public void setSelfPosition(Position selfPosition) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        this.selfPosition = selfPosition;
        this.recomputePosition();
    }

    public Position addSelfPosition(int addX, int addY) {
        this.selfPosition = new Position(this.selfPosition.x + addX, this.selfPosition.y + addY);
        this.recomputePosition();
        return this.selfPosition;
    }

    public Position getSelfPosition() {
        return this.selfPosition;
    }

    public void setSize(Size size) {
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.size = size;
        this.onSizeUpdate();
    }

    public final Position getPosition() {
        return this.position;
    }

    public final Size getSize() {
        return this.size;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public Rectangle toRectangleBox() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return new Rectangle(pos.x, pos.y, size.width, size.height);
    }

    protected void recomputePosition() {
        this.position = this.parentPosition.add(this.selfPosition);
        this.onPositionUpdate();
    }

    protected void onPositionUpdate() {
    }

    protected void onSizeUpdate() {
    }

    public boolean isMouseOverElement(int mouseX, int mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && x + width > mouseX && y + height > mouseY;
    }

    public void initWidget() {
    }

    public void detectAndSendChanges() {
    }

    public void updateScreen() {
    }

    public void updateScreenOnFrame() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyTyped(char charTyped, int keyCode) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
    }

    public void handleClientAction(int id, PacketBuffer buffer) {
    }

    public List<INativeWidget> getNativeWidgets() {
        if (this instanceof INativeWidget) {
            return Collections.singletonList((INativeWidget)((Object)this));
        }
        return Collections.emptyList();
    }

    protected void writeUpdateInfo(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null) {
            this.uiAccess.writeClientAction(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorder(int x, int y, int width, int height, int color, int border) {
        Widget.drawSolidRect(x - border, y - border, width + 2 * border, border, color);
        Widget.drawSolidRect(x - border, y + height, width + 2 * border, border, color);
        Widget.drawSolidRect(x - border, y, border, height, color);
        Widget.drawSolidRect(x + width, y, border, height, color);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawHoveringText(ItemStack itemStack, List<String> tooltip, int maxTextWidth, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText((ItemStack)itemStack, tooltip, (int)mouseX, (int)mouseY, (int)this.sizes.getScreenWidth(), (int)this.sizes.getScreenHeight(), (int)maxTextWidth, (FontRenderer)mc.field_71466_p);
        GlStateManager.func_179140_f();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringSized(String text, double x, double y, int color, boolean dropShadow, float scale, boolean center) {
        GlStateManager.func_179094_E();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scaledTextWidth = center ? (double)((float)fontRenderer.func_78256_a(text) * scale) : 0.0;
        GlStateManager.func_179137_b((double)(x - scaledTextWidth / 2.0), (double)y, (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        fontRenderer.func_175065_a(text, 0.0f, 0.0f, color, dropShadow);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringFixedCorner(String text, double x, double y, int color, boolean dropShadow, float scale) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scaledWidth = (float)fontRenderer.func_78256_a(text) * scale;
        double scaledHeight = (float)fontRenderer.field_78288_b * scale;
        Widget.drawStringSized(text, x - scaledWidth, y - scaledHeight, color, dropShadow, scale, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color) {
        Widget.drawText(text, x, y, scale, color, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color, boolean shadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        float sf = 1.0f / scale;
        fontRenderer.func_175065_a(text, x * sf, y * sf, color, shadow);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItemStack(ItemStack itemStack, int x, int y, @Nullable String altTxt) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRender = mc.func_175599_af();
        itemRender.func_180450_b(itemStack, x, y);
        itemRender.func_180453_a(mc.field_71466_p, itemStack, x, y, altTxt);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getItemToolTip(ItemStack itemStack) {
        Minecraft mc = Minecraft.func_71410_x();
        ITooltipFlag.TooltipFlags flag = mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        List tooltip = itemStack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)flag);
        for (int i = 0; i < tooltip.size(); ++i) {
            if (i == 0) {
                tooltip.set(i, itemStack.func_77973_b().getForgeRarity(itemStack).getColor() + (String)tooltip.get(i));
                continue;
            }
            tooltip.set(i, TextFormatting.GRAY + (String)tooltip.get(i));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSelectionOverlay(int x, int y, int width, int height) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Widget.drawGradientRect(x, y, width, height, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSolidRect(int x, int y, int width, int height, int color) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRectShadow(int x, int y, int width, int height, int distance) {
        Widget.drawGradientRect(x + distance, y + height, width - distance, distance, 0x4F000000, 0, false);
        Widget.drawGradientRect(x + width, y + distance, distance, height - distance, 0x4F000000, 0, true);
        float startAlpha = 0.30980393f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(x += width), (double)(y += height), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, startAlpha).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + distance), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(x + distance), (double)(y + distance), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, startAlpha).func_181675_d();
        buffer.func_181662_b((double)(x + distance), (double)(y + distance), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(x + distance), (double)y, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(int x, int y, int width, int height, int startColor, int endColor) {
        Widget.drawGradientRect(x, y, width, height, startColor, endColor, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(float x, float y, float width, float height, int startColor, int endColor, boolean horizontal) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (horizontal) {
            buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            tessellator.func_78381_a();
        } else {
            buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setColor(int color) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawCircle(float x, float y, float r, int color, int segments) {
        if (color == 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Widget.setColor(color);
        bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < segments; ++i) {
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos(Math.PI * -2 * (double)i / (double)segments), (double)y + (double)r * Math.sin(Math.PI * -2 * (double)i / (double)segments), 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSector(float x, float y, float r, int color, int segments, int from, int to) {
        if (from > to || from < 0 || color == 0) {
            return;
        }
        if (to > segments) {
            to = segments;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Widget.setColor(color);
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        for (int i = from; i < to; ++i) {
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos(Math.PI * -2 * (double)i / (double)segments), (double)y + (double)r * Math.sin(Math.PI * -2 * (double)i / (double)segments), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos(Math.PI * -2 * (double)(i + 1) / (double)segments), (double)y + (double)r * Math.sin(Math.PI * -2 * (double)(i + 1) / (double)segments), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTorus(float x, float y, float outer, float inner, int color, int segments, int from, int to) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Widget.setColor(color);
        bufferbuilder.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        for (int i = from; i <= to; ++i) {
            float angle = (float)i / (float)segments * 3.14159f * 2.0f;
            bufferbuilder.func_181662_b((double)x + (double)inner * Math.cos(-angle), (double)y + (double)inner * Math.sin(-angle), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)x + (double)outer * Math.cos(-angle), (double)y + (double)outer * Math.sin(-angle), 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawLines(List<Vec2f> points, int startColor, int endColor, float width) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)width);
        if (startColor == endColor) {
            Widget.setColor(startColor);
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            for (Vec2f point : points) {
                bufferbuilder.func_181662_b((double)point.field_189982_i, (double)point.field_189983_j, 0.0).func_181675_d();
            }
        } else {
            float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
            float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
            float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
            float startBlue = (float)(startColor & 0xFF) / 255.0f;
            float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
            float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
            float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
            float endBlue = (float)(endColor & 0xFF) / 255.0f;
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            int size = points.size();
            for (int i = 0; i < size; ++i) {
                float p = (float)i * 1.0f / (float)size;
                bufferbuilder.func_181662_b((double)points.get((int)i).field_189982_i, (double)points.get((int)i).field_189983_j, 0.0).func_181666_a(startRed + (endRed - startRed) * p, startGreen + (endGreen - startGreen) * p, startBlue + (endBlue - startBlue) * p, startAlpha + (endAlpha - startAlpha) * p).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTextureRect(double x, double y, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<Vec2f> genBezierPoints(Vec2f from, Vec2f to, boolean horizontal, float u) {
        Vec2f c2;
        Vec2f c1;
        if (horizontal) {
            c1 = new Vec2f((from.field_189982_i + to.field_189982_i) / 2.0f, from.field_189983_j);
            c2 = new Vec2f((from.field_189982_i + to.field_189982_i) / 2.0f, to.field_189983_j);
        } else {
            c1 = new Vec2f(from.field_189982_i, (from.field_189983_j + to.field_189983_j) / 2.0f);
            c2 = new Vec2f(to.field_189982_i, (from.field_189983_j + to.field_189983_j) / 2.0f);
        }
        Vec2f[] controlPoint = new Vec2f[]{from, c1, c2, to};
        int n = controlPoint.length - 1;
        ArrayList<Vec2f> bezierPoints = new ArrayList<Vec2f>();
        u = 0.0f;
        while (u <= 1.0f) {
            int i;
            Vec2f[] p = new Vec2f[n + 1];
            for (i = 0; i <= n; ++i) {
                p[i] = new Vec2f(controlPoint[i].field_189982_i, controlPoint[i].field_189983_j);
            }
            for (int r = 1; r <= n; ++r) {
                for (i = 0; i <= n - r; ++i) {
                    p[i] = new Vec2f((1.0f - u) * p[i].field_189982_i + u * p[i + 1].field_189982_i, (1.0f - u) * p[i].field_189983_j + u * p[i + 1].field_189983_j);
                }
            }
            bezierPoints.add(p[0]);
            u = (float)((double)u + 0.01);
        }
        return bezierPoints;
    }

    @SideOnly(value=Side.CLIENT)
    protected void playButtonClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isShiftDown() {
        return TooltipHelper.isShiftDown();
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isCtrlDown() {
        return TooltipHelper.isCtrlDown();
    }

    public boolean isRemote() {
        return this.gui.holder.isRemote();
    }

    protected static boolean isClientSide() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static final class WheelData {
        public final int wheelDelta;
        public final boolean isShiftClick;
        public final boolean isCtrlClick;
        public final boolean isClient;

        public WheelData(int wheelDelta, boolean isShiftClick, boolean isCtrlClick) {
            this.wheelDelta = wheelDelta;
            this.isShiftClick = isShiftClick;
            this.isCtrlClick = isCtrlClick;
            this.isClient = false;
        }

        public WheelData(int wheelDelta, boolean isShiftClick, boolean isCtrlClick, boolean isClient) {
            this.wheelDelta = wheelDelta;
            this.isShiftClick = isShiftClick;
            this.isCtrlClick = isCtrlClick;
            this.isClient = isClient;
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.func_150787_b(this.wheelDelta);
            buf.writeBoolean(this.isShiftClick);
            buf.writeBoolean(this.isCtrlClick);
            buf.writeBoolean(this.isClient);
        }

        public static WheelData readFromBuf(PacketBuffer buf) {
            int button = buf.func_150792_a();
            boolean shiftClick = buf.readBoolean();
            boolean ctrlClick = buf.readBoolean();
            boolean isClient = buf.readBoolean();
            return new WheelData(button, shiftClick, ctrlClick, isClient);
        }
    }

    public static final class ClickData {
        public final int button;
        public final boolean isShiftClick;
        public final boolean isCtrlClick;
        public final boolean isClient;

        public ClickData(int button, boolean isShiftClick, boolean isCtrlClick) {
            this.button = button;
            this.isShiftClick = isShiftClick;
            this.isCtrlClick = isCtrlClick;
            this.isClient = false;
        }

        public ClickData(int button, boolean isShiftClick, boolean isCtrlClick, boolean isClient) {
            this.button = button;
            this.isShiftClick = isShiftClick;
            this.isCtrlClick = isCtrlClick;
            this.isClient = isClient;
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.func_150787_b(this.button);
            buf.writeBoolean(this.isShiftClick);
            buf.writeBoolean(this.isCtrlClick);
            buf.writeBoolean(this.isClient);
        }

        public static ClickData readFromBuf(PacketBuffer buf) {
            int button = buf.func_150792_a();
            boolean shiftClick = buf.readBoolean();
            boolean ctrlClick = buf.readBoolean();
            boolean isClient = buf.readBoolean();
            return new ClickData(button, shiftClick, ctrlClick, isClient);
        }
    }
}

