/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.fluids.fluidType.FluidTypes;
import gregtech.api.unification.material.Material;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTUtility;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MaterialFluid
extends Fluid {
    private final Material material;
    private final FluidType fluidType;

    public MaterialFluid(String fluidName, @Nonnull Material material, @Nonnull FluidType fluidType, ResourceLocation texture) {
        super(fluidName, texture, texture, GTUtility.convertRGBtoOpaqueRGBA_MC(material.getMaterialRGB()));
        this.material = material;
        this.fluidType = fluidType;
    }

    public void registerFluidTooltip() {
        FluidTooltipUtil.registerTooltip((Fluid)this, FluidTooltipUtil.getMaterialTooltip(this.material, this.getTemperature(), this.fluidType.equals(FluidTypes.PLASMA)));
    }

    @Nonnull
    public Material getMaterial() {
        return this.material;
    }

    @Nonnull
    public FluidType getFluidType() {
        return this.fluidType;
    }

    public String getUnlocalizedName() {
        return this.material.getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName(FluidStack stack) {
        String localizedName = I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        if (this.fluidType != null) {
            return I18n.func_135052_a((String)this.fluidType.getLocalization(), (Object[])new Object[]{localizedName});
        }
        return localizedName;
    }
}

