/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IMaintenanceHatch;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.common.ConfigHolder;
import javax.annotation.Nonnull;

public class MultiblockFuelRecipeLogic
extends MultiblockRecipeLogic {
    protected long totalContinuousRunningTime;

    public MultiblockFuelRecipeLogic(RecipeMapMultiblockController tileEntity) {
        super(tileEntity);
    }

    @Override
    protected int[] runOverclockingLogic(@Nonnull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int recipeDuration, int amountOC) {
        IMaintenanceHatch hatch;
        double durationMultiplier;
        MultiblockWithDisplayBase displayBase = this.metaTileEntity instanceof MultiblockWithDisplayBase ? (MultiblockWithDisplayBase)this.metaTileEntity : null;
        int numMaintenanceProblems = displayBase == null ? 0 : displayBase.getNumMaintenanceProblems();
        int[] overclock = null;
        if (displayBase != null && ConfigHolder.machines.enableMaintenance && displayBase.hasMaintenanceMechanics() && (durationMultiplier = (hatch = displayBase.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0)).getDurationMultiplier()) != 1.0) {
            overclock = new int[]{recipeEUt * -1, (int)Math.round((double)recipeDuration / durationMultiplier)};
        }
        if (overclock == null) {
            overclock = new int[]{recipeEUt * -1, recipeDuration};
        }
        overclock[1] = (int)((double)overclock[1] * (1.0 - 0.1 * (double)numMaintenanceProblems));
        return overclock;
    }

    @Override
    @Nonnull
    public Enum<ParallelLogicType> getParallelLogicType() {
        return ParallelLogicType.MULTIPLY;
    }

    @Override
    protected boolean hasEnoughPower(@Nonnull int[] resultOverclock) {
        return true;
    }

    @Override
    public void applyParallelBonus(@Nonnull RecipeBuilder<?> builder) {
        builder.EUt(builder.getEUt());
    }

    @Override
    public void update() {
        super.update();
        this.totalContinuousRunningTime = this.workingEnabled && this.isActive && this.progressTime > 0 ? ++this.totalContinuousRunningTime : 0L;
    }

    @Override
    public int getParallelLimit() {
        return Integer.MAX_VALUE;
    }

    protected long boostProduction(long production) {
        return production;
    }

    @Override
    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        long euToDraw = this.boostProduction(recipeEUt);
        long resultEnergy = this.getEnergyStored() - euToDraw;
        if (resultEnergy >= 0L && resultEnergy <= this.getEnergyCapacity()) {
            if (!simulate) {
                this.getEnergyContainer().changeEnergy(-euToDraw);
            }
            return true;
        }
        return false;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.totalContinuousRunningTime = 0L;
    }
}

