/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.difficultylock.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="difficultylock")
@Config.LangKey(value="Difficulty Lock Config")
public class ModConfig {
    @Config.Comment(value={"Priority 1: Sets the difficulty in any world to peaceful when enabled."})
    public static boolean forcePeaceful = false;
    @Config.Comment(value={"Priority 2: Sets the difficulty in any world to easy when enabled."})
    public static boolean forceEasy = false;
    @Config.Comment(value={"Priority 3: Sets the difficulty in any world to normal when enabled."})
    public static boolean forceNormal = false;
    @Config.Comment(value={"Priority 4: Sets the difficulty in any world to hard when enabled."})
    public static boolean forceHard = true;
    @Config.Comment(value={"When enabled, locks the difficulty in any world so it cannot be changed."})
    public static boolean shouldLockDifficulty = true;
    @Config.Comment(value={"When enabled, also sets the difficulty in worlds where it has already been locked."})
    public static boolean shouldChangeDifficultyWhenAlreadyLocked = false;

    @Mod.EventBusSubscriber(modid="difficultylock")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("difficultylock")) {
                ConfigManager.sync((String)"difficultylock", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

