/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.common.machines;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.zook.devtech.common.machines.SteamMachineData;
import com.zook.devtech.common.machines.recipeLogic.BoilerRecipeLogic;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableFilteredFluidHandler;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import java.util.HashSet;
import java.util.function.DoubleSupplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class SimpleSteamBoiler
extends MetaTileEntity {
    private final SteamMachineData data;
    private final RecipeMap<?> recipeMap;
    private final ICubeRenderer overlayRenderer;
    private BoilerRecipeLogic workable;
    private IFluidTank waterTank;
    private IFluidTank steamTank;

    public SimpleSteamBoiler(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, SteamMachineData data) {
        super(metaTileEntityId);
        this.data = data;
        this.recipeMap = recipeMap;
        this.overlayRenderer = renderer;
        if (data.progressBar == null) {
            data.progressBar = GuiTextures.PROGRESS_BAR_ARROW_STEAM.get(data.highPressure);
        }
        if (data.moveType == null) {
            data.moveType = ProgressWidget.MoveType.HORIZONTAL;
        }
        if (data.steamOutput < 0) {
            int n = data.steamOutput = data.highPressure ? 240 : 100;
        }
        if (data.cooldownInterval < 0) {
            int n = data.cooldownInterval = data.highPressure ? 40 : 45;
        }
        if (data.cooldownRate < 0) {
            data.cooldownRate = 1;
        }
        this.initializeInventory();
        this.workable = new BoilerRecipeLogic(this, recipeMap, data.highPressure, data.steamOutput, data.cooldownInterval, data.cooldownRate, this.steamTank, this.waterTank);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new SimpleSteamBoiler(this.metaTileEntityId, this.recipeMap, this.overlayRenderer, this.data);
    }

    @SideOnly(value=Side.CLIENT)
    protected SimpleSidedCubeRenderer getBaseRenderer() {
        if (this.data.highPressure) {
            return this.data.bricked ? Textures.STEAM_BRICKED_CASING_STEEL : Textures.STEAM_CASING_STEEL;
        }
        return this.data.bricked ? Textures.STEAM_BRICKED_CASING_BRONZE : Textures.STEAM_CASING_BRONZE;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
        this.overlayRenderer.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.workable.isActive(), this.workable.isWorkingEnabled());
    }

    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    public ModularUI.Builder createUITemplate(EntityPlayer player) {
        RecipeMap workableRecipeMap = this.workable.getRecipeMap();
        int yOffset = 0;
        if (workableRecipeMap.getMaxInputs() >= 6 || workableRecipeMap.getMaxFluidInputs() >= 7 || workableRecipeMap.getMaxOutputs() >= 6 || workableRecipeMap.getMaxFluidOutputs() >= 6) {
            yOffset = 9;
        }
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND_STEAM.get(this.data.highPressure), (int)176, (int)(166 + yOffset)).label(5, 5, this.getMetaFullName()).widget((Widget)new TankWidget(this.waterTank, 83, 46, 10, 34).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.data.highPressure)})).widget((Widget)new TankWidget(this.steamTank, 70, 46, 10, 34).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.data.highPressure)})).widget((Widget)new ProgressWidget(this.workable::getTemperaturePercent, 96, 46, 10, 34).setProgressBar(GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.data.highPressure), GuiTextures.PROGRESS_BAR_BOILER_HEAT, ProgressWidget.MoveType.VERTICAL)).bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT_STEAM.get(this.data.highPressure), yOffset);
        this.buildRecipeUI(builder, () -> ((BoilerRecipeLogic)this.workable).getProgressPercent(), this.getImportItems(), this.getExportItems(), this.getImportFluids(), this.getExportFluids(), yOffset);
        return builder;
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.recipeMap == null) {
            return new ItemStackHandler(0);
        }
        return new NotifiableItemStackHandler(this.recipeMap.getMaxInputs(), (MetaTileEntity)this, false);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        if (this.recipeMap == null) {
            return new ItemStackHandler(0);
        }
        return new NotifiableItemStackHandler(this.recipeMap.getMaxOutputs(), (MetaTileEntity)this, true);
    }

    public FluidTankList createImportFluidHandler() {
        if (this.recipeMap == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        this.waterTank = new FilteredFluidHandler(16000).setFillPredicate(ModHandler::isWater);
        FilteredFluidHandler[] fluidImports = new FilteredFluidHandler[this.recipeMap.getMaxFluidInputs() + 1];
        fluidImports[0] = (FilteredFluidHandler)this.waterTank;
        for (int i = 1; i < fluidImports.length; ++i) {
            NotifiableFilteredFluidHandler filteredFluidHandler = new NotifiableFilteredFluidHandler(this.data.tankSize, (MetaTileEntity)this, false);
            filteredFluidHandler.setFillPredicate(this::canInputFluid);
            fluidImports[i] = filteredFluidHandler;
        }
        return new FluidTankList(false, (IFluidTank[])fluidImports);
    }

    protected FluidTankList createExportFluidHandler() {
        if (this.recipeMap == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        this.steamTank = new FilteredFluidHandler(16000).setFillPredicate(ModHandler::isSteam);
        FluidTank[] fluidExports = new FluidTank[this.recipeMap.getMaxFluidOutputs() + 1];
        fluidExports[0] = (FluidTank)this.steamTank;
        for (int i = 0; i < fluidExports.length; ++i) {
            fluidExports[i] = new NotifiableFluidTank(this.data.tankSize, (MetaTileEntity)this, true);
        }
        return new FluidTankList(false, (IFluidTank[])fluidExports);
    }

    protected boolean canInputFluid(FluidStack inputFluid) {
        if (this.recipeMap.canInputFluidForce(inputFluid.getFluid())) {
            return true;
        }
        HashSet<Recipe> matchingRecipes = null;
        for (IFluidTank fluidTank : this.importFluids) {
            FluidStack fluidInTank = fluidTank.getFluid();
            if (fluidInTank == null) continue;
            if (matchingRecipes == null) {
                matchingRecipes = new HashSet<Recipe>(this.recipeMap.getRecipesForFluid(fluidInTank));
                continue;
            }
            matchingRecipes.removeIf(recipe -> !recipe.hasInputFluid(fluidInTank));
        }
        if (matchingRecipes == null) {
            return !this.recipeMap.getRecipesForFluid(inputFluid).isEmpty();
        }
        return matchingRecipes.stream().anyMatch(recipe -> recipe.hasInputFluid(inputFluid));
    }

    public void buildRecipeUI(ModularUI.Builder builder, DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        builder.widget((Widget)new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.data.progressBar, this.data.moveType, this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
    }

    public void buildRecipeUI(ModularUI.Builder builder, DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, int yOffset) {
        builder.widget((Widget)new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.data.progressBar, this.data.moveType, this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, this.importFluids, false, yOffset);
    }

    protected void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        block11: {
            int i;
            boolean wasGroup;
            int itemInputsCount = itemHandler.getSlots();
            int fluidInputsCount = fluidHandler.getTanks() - 1;
            boolean invertFluids = false;
            if (itemInputsCount == 0) {
                int tmp = itemInputsCount;
                itemInputsCount = fluidInputsCount;
                fluidInputsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = SimpleSteamBoiler.determineSlotsGrid(itemInputsCount);
            int itemSlotsToLeft = inputSlotGrid[0];
            int itemSlotsToDown = inputSlotGrid[1];
            int startInputsX = isOutputs ? 106 : 70 - itemSlotsToLeft * 18;
            int startInputsY = 33 - (int)((double)itemSlotsToDown / 2.0 * 18.0) + yOffset;
            boolean bl = wasGroup = itemHandler.getSlots() + fluidInputsCount == 12;
            if (wasGroup) {
                startInputsY -= 9;
            } else if (itemHandler.getSlots() >= 6 && fluidInputsCount >= 2 && !isOutputs) {
                startInputsY -= 9;
            }
            for (int i2 = 0; i2 < itemSlotsToDown; ++i2) {
                int slotIndex;
                for (int j = 0; j < itemSlotsToLeft && (slotIndex = i2 * itemSlotsToLeft + j) < itemInputsCount; ++j) {
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (wasGroup) {
                startInputsY += 2;
            }
            if (fluidInputsCount <= 0 && !invertFluids) break block11;
            if (itemSlotsToDown >= fluidInputsCount && itemSlotsToLeft < 3) {
                int startSpecX = isOutputs ? startInputsX + itemSlotsToLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int y = startInputsY + 18 * i;
                    this.addSlot(builder, startSpecX, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemSlotsToDown * 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemSlotsToLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isFluid) {
            builder.widget((Widget)new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, false, slotIndex == itemHandler.getSlots() - 1)));
        } else {
            builder.widget((Widget)new TankWidget(fluidHandler.getTankAt(++slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, true, slotIndex == fluidHandler.getTanks() - 1)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast) {
        TextureArea base = isFluid ? GuiTextures.SLOT_STEAM.get(this.data.highPressure) : GuiTextures.SLOT_STEAM.get(this.data.highPressure);
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.data.slotOverlays.containsKey(overlayKey)) {
            return new TextureArea[]{base, (TextureArea)this.data.slotOverlays.get(overlayKey)};
        }
        return new TextureArea[]{base};
    }

    protected static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }
}

