/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.common.machines;

import com.zook.devtech.api.machines.IMachineBuilder;
import com.zook.devtech.api.machines.IMachineRenderer;
import com.zook.devtech.api.machines.IMoveType;
import com.zook.devtech.api.machines.ITankScalingFunction;
import com.zook.devtech.common.machines.MachineRenderer;
import com.zook.devtech.common.machines.SimpleSteamBoiler;
import com.zook.devtech.common.machines.SimpleSteamMachine;
import com.zook.devtech.common.machines.SteamMachineData;
import crafttweaker.CraftTweakerAPI;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IICubeRenderer;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.ITextureArea;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.SimpleGeneratorMetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class CTMachineBuilder
implements IMachineBuilder {
    public static final Map<String, IMachineRenderer> RENDERER_MAP = new HashMap<String, IMachineRenderer>();
    private final String name;
    private final int id;
    private RecipeMap<?> recipeMap;
    private IMachineRenderer renderer;
    private final Set<Integer> tiers = new HashSet<Integer>();
    private boolean hasFrontFacing;
    private boolean canHandleOutputs;
    private Function<Integer, Integer> tankScalingFunction;
    private boolean generator;
    private SteamMachineData bronzeMachineData;
    private SteamMachineData steelMachineData;

    public CTMachineBuilder(int id, String name) {
        this.name = name;
        this.id = id;
    }

    @Override
    public IMachineBuilder setRecipeMap(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
        return this;
    }

    @Override
    public IMachineBuilder setRenderer(String renderer) {
        this.renderer = RENDERER_MAP.get(renderer);
        if (this.renderer == null) {
            CraftTweakerAPI.logError((String)("Could not find renderer with name " + renderer));
        }
        return this;
    }

    @Override
    public IMachineBuilder setRenderer(IMachineRenderer machineRenderer) {
        this.renderer = machineRenderer;
        return this;
    }

    @Override
    public IMachineBuilder setRenderer(IICubeRenderer machineRenderer) {
        this.renderer = new MachineRenderer((ICubeRenderer)machineRenderer);
        return this;
    }

    @Override
    public IMachineBuilder setRenderer(String basePath, String ... faces) {
        this.renderer = IMachineRenderer.create(basePath, faces);
        return this;
    }

    @Override
    public IMachineBuilder addTier(int ... tier) {
        for (int t : tier) {
            if (t > 14) {
                CraftTweakerAPI.logError((String)("Can't add tiers above 14 (MAX). Machine ID: " + this.name + ", " + this.id));
                continue;
            }
            if (t < 0) {
                CraftTweakerAPI.logError((String)("Can't add tiers below 0. Machine ID: " + this.name + ", " + this.id));
                continue;
            }
            this.tiers.add(t);
        }
        return this;
    }

    @Override
    public IMachineBuilder addTierRange(int minTier, int maxTier) {
        if (maxTier > 14) {
            CraftTweakerAPI.logError((String)("Can't add tiers above 14 (MAX). Machine ID: " + this.name + ", " + this.id));
            return this;
        }
        if (minTier < 0) {
            CraftTweakerAPI.logError((String)("Can't add tiers below 0. Machine ID: " + this.name + ", " + this.id));
            return this;
        }
        ++maxTier;
        for (int i = minTier; i < maxTier; ++i) {
            this.tiers.add(i);
        }
        return this;
    }

    @Override
    public IMachineBuilder addSteamTier(boolean highPressure, boolean bricked) {
        this.checkSteamData((boolean)highPressure).bricked = bricked;
        return this;
    }

    @Override
    public IMachineBuilder setGenerator() {
        this.generator = true;
        return this;
    }

    @Override
    public IMachineBuilder setMachine() {
        this.generator = false;
        return this;
    }

    private SteamMachineData checkSteamData(boolean highPressure) {
        if (!highPressure) {
            if (this.bronzeMachineData == null) {
                this.bronzeMachineData = new SteamMachineData();
                this.bronzeMachineData.highPressure = false;
            }
            return this.bronzeMachineData;
        }
        if (this.steelMachineData == null) {
            this.steelMachineData = new SteamMachineData();
            this.steelMachineData.highPressure = true;
        }
        return this.steelMachineData;
    }

    @Override
    public IMachineBuilder setTankScalingFunction(ITankScalingFunction tankScalingFunction) {
        this.tankScalingFunction = tankScalingFunction;
        return this;
    }

    @Override
    public IMachineBuilder setHasFrontFacing(boolean hasFrontFacing) {
        this.hasFrontFacing = hasFrontFacing;
        return this;
    }

    @Override
    public IMachineBuilder setCanHandleOutputs(boolean canHandleOutputs) {
        this.canHandleOutputs = canHandleOutputs;
        return this;
    }

    @Override
    public IMachineBuilder setSteamProgressBar(boolean highPressure, String path, IMoveType moveType) {
        this.checkSteamData((boolean)highPressure).progressBar = TextureArea.fullImage((String)path);
        this.checkSteamData((boolean)highPressure).moveType = moveType.moveType;
        return this;
    }

    @Override
    public IMachineBuilder setSteamProgressBar(boolean highPressure, ITextureArea textureArea, IMoveType moveType) {
        this.checkSteamData((boolean)highPressure).progressBar = textureArea.getInternal();
        this.checkSteamData((boolean)highPressure).moveType = moveType.moveType;
        return this;
    }

    @Override
    public IMachineBuilder setSteamConversionRate(boolean highPressure, double conversionRate) {
        this.checkSteamData((boolean)highPressure).conversionRate = conversionRate;
        return this;
    }

    @Override
    public IMachineBuilder setBoilerValues(boolean highPressure, int steamOutput, int coolDownInterval, int coolDownRate) {
        this.checkSteamData((boolean)highPressure).steamOutput = steamOutput;
        this.checkSteamData((boolean)highPressure).cooldownInterval = coolDownInterval;
        this.checkSteamData((boolean)highPressure).cooldownRate = coolDownRate;
        return this;
    }

    @Override
    public IMachineBuilder setSteamTankSize(boolean highPressure, int tankSize) {
        this.checkSteamData((boolean)highPressure).tankSize = tankSize;
        return this;
    }

    @Override
    public IMachineBuilder setSlotOverlay(boolean highPressure, String path, boolean isOutput, boolean isFluid, boolean isLast) {
        this.checkSteamData(highPressure).setSlotOverlay(isOutput, isFluid, isLast, TextureArea.fullImage((String)path));
        return this;
    }

    @Override
    public IMachineBuilder setSlotOverlay(boolean highPressure, ITextureArea textureArea, boolean isOutput, boolean isFluid, boolean isLast) {
        this.checkSteamData(highPressure).setSlotOverlay(isOutput, isFluid, isLast, textureArea.getInternal());
        return this;
    }

    @Override
    public void buildAndRegister() {
        if (this.recipeMap == null) {
            CraftTweakerAPI.logError((String)("Can't create Machine with null RecipeMap. Machine ID: " + this.name + ", " + this.id));
            return;
        }
        if (this.renderer == null) {
            CraftTweakerAPI.logError((String)("Can't create Machine with null Renderer. Machine ID: " + this.name + ", " + this.id));
            return;
        }
        if (this.generator) {
            if (this.tankScalingFunction == null) {
                this.tankScalingFunction = GTUtility.genericGeneratorTankSizeFunction;
            }
            for (int tier : this.tiers) {
                this.registerGenerator(tier);
            }
            if (this.bronzeMachineData != null) {
                this.registerSteamBoiler(false);
            }
            if (this.steelMachineData != null) {
                this.registerSteamBoiler(true);
            }
        } else {
            if (this.tankScalingFunction == null) {
                this.tankScalingFunction = GTUtility.defaultTankSizeFunction;
            }
            for (int tier : this.tiers) {
                this.registerMachine(tier);
            }
            if (this.bronzeMachineData != null) {
                this.registerSteamMachine(false);
            }
            if (this.steelMachineData != null) {
                this.registerSteamMachine(true);
            }
        }
    }

    private void registerMachine(int tier) {
        ResourceLocation rl = new ResourceLocation("devtech", this.name + "." + GTValues.VN[tier].toLowerCase());
        SimpleMachineMetaTileEntity mte = new SimpleMachineMetaTileEntity(rl, this.recipeMap, this.renderer.getActualRenderer(), tier, this.hasFrontFacing, this.tankScalingFunction);
        GregTechAPI.MTE_REGISTRY.register(this.id + tier + 2, (Object)rl, (Object)mte);
    }

    private void registerGenerator(int tier) {
        ResourceLocation rl = new ResourceLocation("devtech", this.name + "." + GTValues.VN[tier].toLowerCase());
        SimpleGeneratorMetaTileEntity mte = new SimpleGeneratorMetaTileEntity(rl, this.recipeMap, this.renderer.getActualRenderer(), tier, this.tankScalingFunction, this.canHandleOutputs);
        GregTechAPI.MTE_REGISTRY.register(this.id + tier + 2, (Object)rl, (Object)mte);
    }

    private void registerSteamMachine(boolean highPressure) {
        ResourceLocation rl = new ResourceLocation("devtech", this.name + "." + (highPressure ? "steel" : "bronze"));
        SimpleSteamMachine mte = new SimpleSteamMachine(rl, this.recipeMap, this.renderer.getActualRenderer(), highPressure ? this.steelMachineData : this.bronzeMachineData);
        GregTechAPI.MTE_REGISTRY.register(this.id + (highPressure ? 1 : 0), (Object)rl, (Object)mte);
    }

    private void registerSteamBoiler(boolean highPressure) {
        ResourceLocation rl = new ResourceLocation("devtech", this.name + "." + (highPressure ? "steel" : "bronze"));
        SimpleSteamBoiler mte = new SimpleSteamBoiler(rl, this.recipeMap, this.renderer.getActualRenderer(), highPressure ? this.steelMachineData : this.bronzeMachineData);
        GregTechAPI.MTE_REGISTRY.register(this.id + (highPressure ? 1 : 0), (Object)rl, (Object)mte);
    }

    static {
        for (Map.Entry entry : Textures.CUBE_RENDERER_REGISTRY.entrySet()) {
            RENDERER_MAP.put((String)entry.getKey(), new MachineRenderer((ICubeRenderer)entry.getValue()));
        }
    }
}

