/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.blocks;

import com.teamacronymcoders.base.blocks.BlockFluidBase;
import com.teamacronymcoders.base.blocks.IHasBlockStateMapper;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.materialsystem.blocks.FluidMaterial;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockMaterialFluid
extends BlockFluidBase
implements IHasBlockStateMapper,
IHasGeneratedModel {
    private MaterialPart materialPart;

    public BlockMaterialFluid(MaterialPart materialPart) {
        super(materialPart.getUnlocalizedName(), BlockMaterialFluid.createFluid(materialPart), Material.field_151587_i);
        this.materialPart = materialPart;
    }

    private static Fluid createFluid(MaterialPart materialPart) {
        Part part = materialPart.getPart();
        ResourceLocation texture = new ResourceLocation(part.getOwnerId(), "fluids/" + part.getShortUnlocalizedName());
        FluidMaterial fluid = new FluidMaterial(materialPart, texture);
        MaterialPartData data = materialPart.getData();
        if (data.containsDataPiece("density")) {
            fluid.setDensity(Integer.parseInt(data.getDataPiece("density")));
        }
        if (data.containsDataPiece("viscosity")) {
            fluid.setViscosity(Integer.parseInt(data.getDataPiece("viscosity")));
        }
        if (data.containsDataPiece("temperature")) {
            fluid.setTemperature(Integer.parseInt(data.getDataPiece("temperature")));
        }
        if (data.containsDataPiece("vaporize")) {
            fluid.setVaporize(Boolean.parseBoolean(data.getDataPiece("vaporize")));
        }
        fluid.setLuminosity(data.getValue("luminosity", 0, Integer::parseInt));
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return fluid;
    }

    @Override
    protected String getModelPrefix() {
        return "materials/";
    }

    @Override
    public ResourceLocation getResourceLocation(IBlockState blockState) {
        return new ResourceLocation(this.materialPart.getMaterialUser().getId(), "materials/" + this.materialPart.getUnlocalizedName());
    }
}

