/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.dimension.realmofinsanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sofodev.armorplus.common.dimension.realmofinsanity.NormalTerrainGenerator;
import com.sofodev.armorplus.common.registry.entities.mobs.EntityEnderDragonZombie;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class RealmChunkGenerator
implements IChunkGenerator {
    private final World world;
    private Random random;
    private Biome[] biomesForGeneration;
    private List<Biome.SpawnListEntry> mobs = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityEnderDragonZombie.class, 100, 1, 1)});
    private MapGenBase caveGenerator = new MapGenCaves();
    private NormalTerrainGenerator terraingen = new NormalTerrainGenerator();

    public RealmChunkGenerator(World world) {
        this.world = world;
        long seed = world.func_72905_C();
        this.random = new Random((seed + 516L) * 314L);
        this.terraingen.setup(world, this.random);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.terraingen.setBiomesForGeneration(this.biomesForGeneration);
        this.terraingen.generate(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.terraingen.replaceBiomeBlocks(x, z, chunkprimer, this, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        int xChunk = x * 16;
        int zChunk = z * 16;
        BlockPos blockpos = new BlockPos(xChunk, 0, zChunk);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        biome.func_180624_a(this.world, this.random, blockpos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(xChunk + 8), (int)(zChunk + 8), (int)16, (int)16, (Random)this.random);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            return this.mobs;
        }
        return ImmutableList.of();
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

