/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.tinkers;

import com.google.common.eventbus.Subscribe;
import com.sofodev.armorplus.common.compat.tinkers.modifiers.TiCModifiers;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.TinkerTraits;

public final class TiCMaterials
extends AbstractToolPulse {
    public static final Material INFUSED_LAVA_CRYSTAL = TiCMaterials.mat("infused_lava_crystal", 11742464);
    public static final Material COMPRESSED_OBSIDIAN = TiCMaterials.mat("compressed_obsidian", 21888);
    public static final Material LAVA_INFUSED_OBSIDIAN = TiCMaterials.mat("lava_infused_obsidian", 6493958);

    private static Material mat(String name, int color) {
        Material mat = new Material(name, color);
        TinkerMaterials.materials.add(mat);
        return mat;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerMaterialRendering() {
        INFUSED_LAVA_CRYSTAL.setRenderInfo(11742464).setTextureSuffix("contrast");
        INFUSED_LAVA_CRYSTAL.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Default(11742464));
        INFUSED_LAVA_CRYSTAL.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.MultiColor(11742464, 14514724, 16229930));
        COMPRESSED_OBSIDIAN.setRenderInfo(21888).setTextureSuffix("contrast");
        COMPRESSED_OBSIDIAN.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Default(21888));
        COMPRESSED_OBSIDIAN.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.BlockTexture(Utils.setRL("blocks/compressed_obsidian")));
        LAVA_INFUSED_OBSIDIAN.setRenderInfo(6493958).setTextureSuffix("contrast");
        LAVA_INFUSED_OBSIDIAN.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Default(6493958));
        LAVA_INFUSED_OBSIDIAN.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.BlockTexture(Utils.setRL("blocks/compressed_obsidian")));
    }

    @Subscribe
    public void setupMaterialStats(FMLPreInitializationEvent event) {
        this.registerToolMaterialStats();
    }

    @Subscribe
    public void setupMaterials(FMLInitializationEvent event) {
        INFUSED_LAVA_CRYSTAL.addItem(ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1), 2, 144);
        INFUSED_LAVA_CRYSTAL.addItem("gemInfusedLavaCrystal", 2, 144);
        INFUSED_LAVA_CRYSTAL.addItem((Block)ModBlocks.blockInfusedLavaCrystal, 1296);
        INFUSED_LAVA_CRYSTAL.addItem("blockInfusedLavaCrystal", 2, 1296);
        INFUSED_LAVA_CRYSTAL.addTrait((ITrait)TiCModifiers.infusedLavaCrystalModifier, "head").addTrait((ITrait)TinkerTraits.flammable, "head").addTrait((ITrait)TinkerTraits.autosmelt);
        COMPRESSED_OBSIDIAN.addItem((Block)ModBlocks.blockCompressedObsidian, 144);
        COMPRESSED_OBSIDIAN.addTrait((ITrait)TinkerTraits.duritos);
        LAVA_INFUSED_OBSIDIAN.addItem((Block)ModBlocks.blockLavaInfusedObsidian, 144);
        LAVA_INFUSED_OBSIDIAN.addTrait((ITrait)TinkerTraits.duritos).addTrait((ITrait)TinkerTraits.autosmelt, "handle");
        this.setupMaterialBasics(INFUSED_LAVA_CRYSTAL);
        this.setupMaterialBasics(COMPRESSED_OBSIDIAN);
        this.setupMaterialBasics(LAVA_INFUSED_OBSIDIAN);
        this.setRepresentativeItems(INFUSED_LAVA_CRYSTAL, ModBlocks.blockInfusedLavaCrystal);
        this.setRepresentativeItems(COMPRESSED_OBSIDIAN, ModBlocks.blockCompressedObsidian);
        this.setRepresentativeItems(LAVA_INFUSED_OBSIDIAN, ModBlocks.blockLavaInfusedObsidian);
    }

    private void setupMaterialBasics(Material material) {
        material.setCraftable(true);
    }

    private void setRepresentativeItems(Material material, Object representative) {
        if (representative instanceof ItemStack || representative instanceof Item || representative instanceof Block) {
            material.setRepresentativeItem(ItemStackUtils.getItemStack((Object)representative));
        } else {
            LogHelper.info((Object)("couldn't determine the type of " + representative));
        }
    }

    public void registerToolMaterialStats() {
        TinkerRegistry.addMaterialStats((Material)INFUSED_LAVA_CRYSTAL, (IMaterialStats)new HeadMaterialStats(110, 9.0f, 4.2f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 100), new ExtraMaterialStats(100)});
        TinkerRegistry.addMaterialStats((Material)COMPRESSED_OBSIDIAN, (IMaterialStats)new HeadMaterialStats(139, 7.07f, 2.2f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 20), new ExtraMaterialStats(90)});
        TinkerRegistry.addMaterialStats((Material)LAVA_INFUSED_OBSIDIAN, (IMaterialStats)new HeadMaterialStats(153, 8.0f, 2.35f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 80), new ExtraMaterialStats(100)});
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (Utils.isNull(TinkerTools.shard)) {
            return;
        }
        TinkerRegistry.getAllMaterials().forEach(material -> {
            ItemStack shard = TinkerTools.shard.getItemstackWithMaterial(material);
            material.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(72, new ItemStack[]{shard}));
            if (!material.getShard().func_190926_b()) {
                material.setShard(shard);
            }
        });
    }
}

