/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.caps.abilities;

import com.sofodev.armorplus.api.caps.abilities.AbilityData;
import com.sofodev.armorplus.api.caps.abilities.ISpecialItem;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AbilityDataHandler {
    @CapabilityInject(value=IAbilityHandler.class)
    public static final Capability<IAbilityHandler> CAPABILITY_ABILITIES = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IAbilityHandler.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
        MinecraftForge.EVENT_BUS.register((Object)new AbilityDataHandler());
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (ModConfig.Experimental.enableExperimentalMode && ((ItemStack)event.getObject()).func_77973_b() instanceof ISpecialItem) {
            event.addCapability(Utils.setRL("abilities"), (ICapabilityProvider)new Provider());
        }
    }

    public static IAbilityHandler getHandler(ItemStack stack) {
        if (ModConfig.Experimental.enableExperimentalMode && stack.func_77973_b() instanceof ISpecialItem) {
            return stack.hasCapability(CAPABILITY_ABILITIES, null) ? (IAbilityHandler)stack.getCapability(CAPABILITY_ABILITIES, null) : null;
        }
        return null;
    }

    public static class Factory
    implements Callable<IAbilityHandler> {
        @Override
        public IAbilityHandler call() throws Exception {
            return new DefaultAbilityData();
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        IAbilityHandler instance = (IAbilityHandler)CAPABILITY_ABILITIES.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability.equals(CAPABILITY_ABILITIES);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_ABILITIES.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_ABILITIES.getStorage().writeNBT(CAPABILITY_ABILITIES, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_ABILITIES.getStorage().readNBT(CAPABILITY_ABILITIES, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IAbilityHandler> {
        public NBTBase writeNBT(Capability<IAbilityHandler> capability, IAbilityHandler instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            if (instance != null) {
                NBTTagList tagList = new NBTTagList();
                List<AbilityData> abilityDataList = instance.getAbilities();
                List ability = abilityDataList.stream().map(AbilityData::getSafeName).collect(Collectors.toList());
                ability.stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
                tag.func_74782_a("abilityList", (NBTBase)tagList);
                tag.func_74774_a("limit", instance.getLimit());
            }
            return tag;
        }

        public void readNBT(Capability<IAbilityHandler> capability, IAbilityHandler instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            NBTTagList tagList = tag.func_150295_c("abilityList", 8);
            List<AbilityData> abilityDataList = IntStream.range(0, tagList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)tagList).func_150307_f(arg_0)).map(AbilityData::getData).collect(Collectors.toList());
            instance.setAbilities(abilityDataList);
            instance.setLimit(tag.func_74771_c("limit"));
        }
    }

    public static class DefaultAbilityData
    extends IForgeRegistryEntry.Impl<DefaultAbilityData>
    implements IAbilityHandler {
        private byte limit = 0;
        private ArrayList<AbilityData> abilityList = new ArrayList();

        @Override
        public byte getLimit() {
            return this.limit;
        }

        @Override
        public void setLimit(byte limit) {
            this.limit = limit;
        }

        @Override
        public List<AbilityData> getAbilities() {
            return this.abilityList;
        }

        @Override
        public void setAbilities(List<AbilityData> abilities) {
            this.abilityList.clear();
            this.abilityList.addAll(abilities);
        }

        @Override
        public void addAbility(AbilityData ability) {
            if (this.abilityList.size() < this.limit && !this.abilityList.contains((Object)ability)) {
                this.abilityList.add(ability);
            }
        }

        @Override
        public void removeAbility(AbilityData ability) {
            if (!this.abilityList.isEmpty()) {
                this.abilityList.remove((Object)ability);
            }
        }
    }

    public static interface IAbilityHandler {
        public byte getLimit();

        public void setLimit(byte var1);

        public List<AbilityData> getAbilities();

        public void setAbilities(List<AbilityData> var1);

        public void addAbility(AbilityData var1);

        public void removeAbility(AbilityData var1);
    }
}

