/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.utils;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class InventoryUtils {
    public static InventorySide inventorySide(IInventory base, EnumFacing side) {
        if (base instanceof ISidedInventory) {
            return new SidedInventorySide((ISidedInventory)base, side);
        }
        return new UnsidedInventorySide(base);
    }

    public static class SidedInventorySide
    extends InventorySide {
        ISidedInventory base;
        EnumFacing side;
        int[] slots;

        public SidedInventorySide(ISidedInventory base, EnumFacing side) {
            this.base = base;
            this.side = side;
            this.slots = base.func_180463_a(side);
            this.size = this.slots.length;
        }

        @Override
        public ItemStack get(int i) {
            return this.base.func_70301_a(this.slots[i]);
        }

        @Override
        public boolean set(int i, ItemStack stack) {
            int slot = this.slots[i];
            if (this.base.func_180462_a(slot, stack, this.side)) {
                this.base.func_70299_a(slot, stack);
                return true;
            }
            return false;
        }

        @Override
        public ItemStack extract(int i) {
            int slot = this.slots[i];
            ItemStack stack = this.base.func_70301_a(slot);
            if (this.base.func_180461_b(slot, stack, this.side)) {
                return stack;
            }
            return ItemStack.field_190927_a;
        }
    }

    public static class UnsidedInventorySide
    extends InventorySide {
        IInventory base;

        public UnsidedInventorySide(IInventory base) {
            this.base = base;
            this.size = base.func_70302_i_();
        }

        @Override
        public ItemStack get(int slot) {
            return this.base.func_70301_a(slot);
        }

        @Override
        public boolean set(int slot, ItemStack stack) {
            this.base.func_70299_a(slot, stack);
            return true;
        }

        @Override
        public ItemStack extract(int slot) {
            return this.get(slot);
        }
    }

    public static abstract class InventorySide {
        public int size;

        public abstract ItemStack get(int var1);

        public abstract boolean set(int var1, ItemStack var2);

        public abstract ItemStack extract(int var1);
    }
}

