/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.export;

import appeng.services.export.CheckType;
import appeng.services.export.Checker;
import appeng.services.export.ExportConfig;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.codec.digest.DigestUtils;

final class ModListChecker
implements Checker<List<ModContainer>> {
    private final String configHashValue;
    @Nonnull
    private final ExportConfig config;

    ModListChecker(@Nonnull ExportConfig config) {
        this.config = (ExportConfig)Preconditions.checkNotNull((Object)config);
        this.configHashValue = (String)Preconditions.checkNotNull((Object)config.getCache());
    }

    @Override
    @Nonnull
    public CheckType isEqual(@Nonnull List<ModContainer> modContainers) {
        Preconditions.checkNotNull(modContainers);
        StringBuilder builder = new StringBuilder();
        for (ModContainer container : modContainers) {
            builder.append(container.getModId());
            builder.append(container.getVersion());
        }
        String allModsAndVersions = builder.toString();
        String hex = DigestUtils.md5Hex((String)allModsAndVersions);
        if (hex.equals(this.configHashValue)) {
            return CheckType.EQUAL;
        }
        this.config.setCache(hex);
        return CheckType.UNEQUAL;
    }
}

