/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInformPlayer;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingJob;
import appeng.crafting.CraftingTreeProcess;
import appeng.crafting.MECraftingInventory;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class CraftingTreeNode {
    private final int slot;
    private final CraftingJob job;
    private final IItemList<IAEItemStack> used = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final CraftingTreeProcess parent;
    private final World world;
    private final IAEItemStack what;
    private final ArrayList<CraftingTreeProcess> nodes = new ArrayList();
    private final ICraftingGrid cc;
    private final int depth;
    private int bytes = 0;
    private boolean canEmit = false;
    private long missing = 0L;
    private long howManyEmitted = 0L;
    private boolean exhausted = false;

    public CraftingTreeNode(ICraftingGrid cc, CraftingJob job, IAEItemStack wat, CraftingTreeProcess par, int slot, int depth) {
        this.what = wat;
        this.parent = par;
        this.slot = slot;
        this.world = job.getWorld();
        this.job = job;
        this.cc = cc;
        this.depth = depth;
        this.canEmit = cc.canEmitFor(this.what);
    }

    public void addNode() {
        if (!this.nodes.isEmpty()) {
            return;
        }
        if (this.canEmit) {
            return;
        }
        for (ICraftingPatternDetails details : this.cc.getCraftingFor(this.what, this.parent == null ? null : this.parent.details, this.slot, this.world)) {
            if (this.parent != null && (!this.notRecursive(details) || this.parent.details == details)) continue;
            this.nodes.add(new CraftingTreeProcess(this.cc, this.job, details, this, this.depth + 1));
        }
    }

    IAEItemStack request(MECraftingInventory inv, long l, IActionSource src) throws CraftBranchFailure, InterruptedException {
        this.addNode();
        this.job.handlePausing();
        if (this.canEmit) {
            IAEItemStack wat = this.what.copy();
            wat.setStackSize(l);
            this.howManyEmitted = wat.getStackSize();
            this.bytes = (int)((long)this.bytes + wat.getStackSize());
            return wat;
        }
        IItemList<IAEItemStack> inventoryList = inv.getItemList();
        ArrayList<IAEItemStack> thingsUsed = new ArrayList<IAEItemStack>();
        this.what.setStackSize(l);
        if (this.getSlot() >= 0 && this.parent != null && this.parent.details.isCraftable()) {
            boolean damageableItem;
            ArrayList<IAEItemStack> itemList = new ArrayList<IAEItemStack>();
            boolean bl = damageableItem = this.what.getItem().func_77645_m() || Platform.isGTDamageableItem(this.what.getItem());
            if (this.parent.details.canSubstitute()) {
                for (IAEItemStack subs : this.parent.details.getSubstituteInputs(this.slot)) {
                    if (damageableItem) {
                        itemList.addAll(inventoryList.findFuzzy(subs, FuzzyMode.IGNORE_ALL));
                    }
                    if ((subs = inventoryList.findPrecise(subs)) == null) continue;
                    itemList.add(subs);
                }
            } else if (damageableItem) {
                itemList.addAll(inventoryList.findFuzzy(this.what, FuzzyMode.IGNORE_ALL));
            } else {
                IAEItemStack item = inventoryList.findPrecise(this.what);
                if (item != null) {
                    itemList.add(item);
                }
            }
            for (IAEItemStack fuzz : itemList) {
                IAEItemStack is;
                if (!this.parent.details.isValidItemForSlot(this.getSlot(), fuzz.copy().getCachedItemStack(1L), this.world)) continue;
                fuzz = fuzz.copy();
                fuzz.setStackSize(l);
                IAEItemStack available = inv.extractItems(fuzz, Actionable.MODULATE, src);
                if (available == null) continue;
                if (!this.exhausted && (is = this.job.checkUse(available)) != null) {
                    thingsUsed.add(is.copy());
                    this.used.add(is);
                }
                this.bytes = (int)((long)this.bytes + available.getStackSize());
                if ((l -= available.getStackSize()) != 0L) continue;
                return available;
            }
        } else {
            IAEItemStack available = inv.extractItems(this.what, Actionable.MODULATE, src);
            if (available != null) {
                IAEItemStack is;
                if (!this.exhausted && (is = this.job.checkUse(available)) != null) {
                    thingsUsed.add(is.copy());
                    this.used.add(is);
                }
                this.bytes = (int)((long)this.bytes + available.getStackSize());
                if ((l -= available.getStackSize()) == 0L) {
                    return available;
                }
            }
        }
        this.exhausted = true;
        if (this.nodes.size() == 1) {
            CraftingTreeProcess pro = this.nodes.get(0);
            while (pro.possible && l > 0L) {
                IAEItemStack madeWhat = pro.getAmountCrafted(this.what);
                pro.request(inv, pro.getTimes(l, madeWhat.getStackSize()), src);
                madeWhat.setStackSize(l);
                IAEItemStack available = inv.extractItems(madeWhat, Actionable.MODULATE, src);
                if (available != null) {
                    this.bytes = (int)((long)this.bytes + available.getStackSize());
                    if ((l -= available.getStackSize()) > 0L) continue;
                    return available;
                }
                pro.possible = false;
            }
        } else if (this.nodes.size() > 1) {
            for (CraftingTreeProcess pro : this.nodes) {
                try {
                    while (pro.possible && l > 0L) {
                        MECraftingInventory subInv = new MECraftingInventory(inv, true, true, true);
                        pro.request(subInv, 1L, src);
                        this.what.setStackSize(l);
                        IAEItemStack available = subInv.extractItems(this.what, Actionable.MODULATE, src);
                        if (available != null) {
                            if (!subInv.commit(src)) {
                                throw new CraftBranchFailure(this.what, l);
                            }
                            this.bytes = (int)((long)this.bytes + available.getStackSize());
                            if ((l -= available.getStackSize()) > 0L) continue;
                            return available;
                        }
                        pro.possible = false;
                    }
                }
                catch (CraftBranchFailure fail) {
                    pro.possible = true;
                }
            }
        }
        if (this.job.isSimulation()) {
            this.bytes = (int)((long)this.bytes + l);
            this.missing += l;
            IAEItemStack rv = this.what.copy();
            rv.setStackSize(l);
            return rv;
        }
        for (IAEItemStack o : thingsUsed) {
            this.job.refund(o.copy());
            o.setStackSize(-o.getStackSize());
            this.used.add(o);
        }
        throw new CraftBranchFailure(this.what, l);
    }

    boolean notRecursive(ICraftingPatternDetails details) {
        if (this.parent == null) {
            return true;
        }
        if (this.parent.details == details) {
            return false;
        }
        return this.parent.notRecursive(details);
    }

    void dive(CraftingJob job) {
        if (this.missing > 0L) {
            job.addMissing(this.getStack(this.missing));
        }
        job.addBytes(this.bytes);
        for (CraftingTreeProcess pro : this.nodes) {
            pro.dive(job);
        }
    }

    IAEItemStack getStack(long size) {
        IAEItemStack is = this.what.copy();
        is.setStackSize(size);
        return is;
    }

    void setSimulate() {
        this.missing = 0L;
        this.bytes = 0;
        this.used.resetStatus();
        this.exhausted = false;
        for (CraftingTreeProcess pro : this.nodes) {
            pro.setSimulate();
        }
    }

    public void setJob(MECraftingInventory storage, CraftingCPUCluster craftingCPUCluster, IActionSource src) throws CraftBranchFailure {
        for (IAEItemStack i : this.used) {
            IAEItemStack actuallyExtracted = storage.extractItems(i, Actionable.MODULATE, src);
            if (actuallyExtracted == null || actuallyExtracted.getStackSize() != i.getStackSize()) {
                if (src.player().isPresent()) {
                    try {
                        if (actuallyExtracted == null) {
                            NetworkHandler.instance().sendTo(new PacketInformPlayer(i, null, PacketInformPlayer.InfoType.NO_ITEMS_EXTRACTED), (EntityPlayerMP)src.player().get());
                        } else {
                            NetworkHandler.instance().sendTo(new PacketInformPlayer(i, actuallyExtracted, PacketInformPlayer.InfoType.PARTIAL_ITEM_EXTRACTION), (EntityPlayerMP)src.player().get());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw new CraftBranchFailure(i, i.getStackSize());
            }
            craftingCPUCluster.addStorage(actuallyExtracted);
        }
        if (this.howManyEmitted > 0L) {
            IAEItemStack i = (IAEItemStack)this.what.copy().reset();
            i.setStackSize(this.howManyEmitted);
            craftingCPUCluster.addEmitable(i);
        }
        for (CraftingTreeProcess pro : this.nodes) {
            pro.setJob(storage, craftingCPUCluster, src);
        }
    }

    void getPlan(IItemList<IAEItemStack> plan) {
        if (this.missing > 0L) {
            IAEItemStack o = this.what.copy();
            o.setStackSize(this.missing);
            plan.add(o);
        }
        if (this.howManyEmitted > 0L) {
            IAEItemStack i = this.what.copy();
            i.setCountRequestable(this.howManyEmitted);
            plan.addRequestable(i);
        }
        for (IAEItemStack i : this.used) {
            plan.add(i.copy());
        }
        for (CraftingTreeProcess pro : this.nodes) {
            pro.getPlan(plan);
        }
    }

    int getSlot() {
        return this.slot;
    }
}

