/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final Optional<Item> item;

    public ItemDefinition(String registryName, Item item) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)registryName) ? 1 : 0) != 0, (Object)"registryName");
        this.identifier = registryName;
        this.item = Optional.ofNullable(item);
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    public final Optional<Item> maybeItem() {
        return this.item;
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        return this.item.map(item -> new ItemStack(item, stackSize));
    }

    @Override
    public boolean isEnabled() {
        return this.item.isPresent();
    }

    @Override
    public final boolean isSameAs(ItemStack comparableStack) {
        return this.isEnabled() && Platform.itemComparisons().isEqualItemType(comparableStack, this.maybeStack(1).get());
    }
}

