/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class FacadeConfig {
    private static final String CONFIG_VERSION = "1";
    private static final String CONFIG_COMMON_KEY = "common";
    private static final String CONFIG_COMMON_COMMENT = "Settings applied to all facades.\n\nBy default full blocks with no tile entity and a model do not need whitelisting.\nThis will only be read once during client startup.";
    private static final String CONFIG_COMMON_ALLOW_TILEENTITIES_KEY = "allowTileEntityFacades";
    private static final String CONFIG_COMMON_ALLOW_TILEENTITIES_COMMENT = "Unsupported: Allows whitelisting TileEntity as facades. Could work, have render issues, or corrupt your world. USE AT YOUR OWN RISK.";
    private static final String CONFIG_FACADES_KEY = "facades";
    private static final String CONFIG_FACADES_COMMENT = "A way to explicitly handle certain blocks as facades.\n\nBlocks can be added by their resource location under the following rules.\n - One category per domain like minecraft or appliedenergistics2\n - One key per id. E.g. glass in case of minecraft:glass\n - An integer value ranging from 0 to 16 representing the metadata 0-15 and 16 as wildcard for all - Multiple entries for the same id but different metadata are possible when needed";
    private static FacadeConfig instance;
    private final boolean allowTileEntityFacades;
    private final Object2IntMap<ResourceLocation> whiteList;

    private FacadeConfig(boolean allowTileEntityFacades, Object2IntMap<ResourceLocation> whiteList) {
        this.allowTileEntityFacades = allowTileEntityFacades;
        this.whiteList = whiteList;
    }

    public static void init(File configFile) {
        Configuration configurartion = FacadeConfig.migrate(new Configuration(configFile, CONFIG_VERSION));
        boolean allowTileEntityFacades = configurartion.get(CONFIG_COMMON_KEY, CONFIG_COMMON_ALLOW_TILEENTITIES_KEY, false, CONFIG_COMMON_ALLOW_TILEENTITIES_COMMENT).setRequiresMcRestart(true).setShowInGui(false).getBoolean();
        Object2IntArrayMap configWhiteList = new Object2IntArrayMap();
        Set whitelist = configurartion.getCategory(CONFIG_FACADES_KEY).getChildren();
        for (ConfigCategory configCategory : whitelist) {
            String domain = configCategory.getName();
            Map values = configCategory.getValues();
            for (Map.Entry entry : values.entrySet()) {
                configWhiteList.put((Object)new ResourceLocation(domain, (String)entry.getKey()), ((Property)entry.getValue()).getInt());
            }
        }
        if (configurartion.hasChanged()) {
            configurartion.save();
        }
        instance = new FacadeConfig(allowTileEntityFacades, (Object2IntMap<ResourceLocation>)configWhiteList);
    }

    private static Configuration migrate(Configuration configurartion) {
        if (configurartion.getLoadedConfigVersion() == null) {
            for (String category : configurartion.getCategoryNames()) {
                ConfigCategory c = configurartion.getCategory(category);
                configurartion.removeCategory(c);
            }
        }
        if (!configurartion.hasCategory(CONFIG_COMMON_KEY)) {
            configurartion.getCategory(CONFIG_COMMON_KEY).setComment(CONFIG_COMMON_COMMENT);
        }
        if (!configurartion.hasCategory(CONFIG_FACADES_KEY)) {
            ConfigCategory category = configurartion.getCategory(CONFIG_FACADES_KEY);
            category.setComment(CONFIG_FACADES_COMMENT);
            ConfigCategory minecraft = new ConfigCategory("minecraft", category);
            minecraft.put("glass", new Property("glass", "16", Property.Type.INTEGER));
            minecraft.put("stained_glass", new Property("stained_glass", "16", Property.Type.INTEGER));
            ConfigCategory appliedenergistics = new ConfigCategory("appliedenergistics2", category);
            appliedenergistics.put("quartz_glass", new Property("quartz_glass", "16", Property.Type.INTEGER));
            appliedenergistics.put("quartz_vibrant_glass", new Property("quartz_vibrant_glass", "16", Property.Type.INTEGER));
        }
        return configurartion;
    }

    public static FacadeConfig instance() {
        return instance;
    }

    public boolean allowTileEntityFacades() {
        return this.allowTileEntityFacades;
    }

    public boolean isWhiteListed(Block block, int metadata) {
        Integer entry = (Integer)this.whiteList.get((Object)block.getRegistryName());
        if (entry != null) {
            return entry == metadata || entry == 16;
        }
        return false;
    }
}

