/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones;

import info.tehnut.xtones.Tone;
import info.tehnut.xtones.block.FlatLampBlock;
import info.tehnut.xtones.block.XtoneBlock;
import info.tehnut.xtones.item.XtoneBlockItem;
import info.tehnut.xtones.item.XtonesCreativeTab;
import info.tehnut.xtones.network.XtonesNetwork;
import info.tehnut.xtones.support.ChiselSupport;
import info.tehnut.xtones.support.ChiselsAndBitsSupport;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Mod(modid="xtones", acceptedMinecraftVersions="[1.12.2]", useMetadata=true)
@Mod.EventBusSubscriber(modid="xtones")
public final class Xtones {
    public static final String ID = "xtones";
    public static final String NAME = "Xtones";
    private static final Map<Tone, Block> BLOCKS = new EnumMap<Tone, Block>(Tone.class);
    private static final Map<Tone, Item> ITEMS = new EnumMap<Tone, Item>(Tone.class);
    private static final String BASE = "base";
    private static final String LAMP = "lamp_flat";
    private static @MonotonicNonNull Block baseBlock;
    private static @MonotonicNonNull Block lampBlock;
    private static @MonotonicNonNull Item baseItem;
    private static @MonotonicNonNull Item lampItem;

    public static Stream<Block> blocks() {
        return BLOCKS.values().stream();
    }

    public static Stream<Item> items() {
        return ITEMS.values().stream();
    }

    public static Block block(Tone tone) {
        return BLOCKS.get((Object)tone);
    }

    public static Item item(Tone tone) {
        return ITEMS.get((Object)tone);
    }

    public static Block baseBlock() {
        return baseBlock;
    }

    public static Block lampBlock() {
        return lampBlock;
    }

    public static Item baseItem() {
        return baseItem;
    }

    public static Item lampItem() {
        return lampItem;
    }

    @Mod.EventHandler
    static void init(FMLInitializationEvent event) {
        XtonesNetwork.init();
        if (Loader.isModLoaded((String)"chisel")) {
            ChiselSupport.init();
        }
        if (Loader.isModLoaded((String)"chiselsandbits")) {
            ChiselsAndBitsSupport.init();
        }
    }

    @SubscribeEvent
    static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        baseBlock = ((Block)new Block(Material.field_151576_e).setRegistryName(ID, BASE)).func_149663_c("xtones.base").func_149647_a(XtonesCreativeTab.instance()).func_149752_b(3.0f).func_149711_c(3.0f);
        lampBlock = ((Block)new FlatLampBlock().setRegistryName(ID, LAMP)).func_149663_c("xtones.lamp_flat").func_149647_a(XtonesCreativeTab.instance()).func_149711_c(0.5f);
        registry.registerAll((IForgeRegistryEntry[])new Block[]{baseBlock, lampBlock});
        for (Tone tone : Tone.values()) {
            Block block = ((Block)new XtoneBlock(tone).setRegistryName(ID, tone.toString())).func_149663_c("xtones." + (Object)((Object)tone)).func_149647_a(XtonesCreativeTab.instance()).func_149752_b(3.0f).func_149711_c(3.0f);
            registry.register((IForgeRegistryEntry)block);
            BLOCKS.put(tone, block);
        }
    }

    @SubscribeEvent
    static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        baseItem = (Item)new ItemBlock(Xtones.baseBlock()).setRegistryName(ID, BASE);
        lampItem = (Item)new ItemBlock(Xtones.lampBlock()).setRegistryName(ID, LAMP);
        registry.registerAll((IForgeRegistryEntry[])new Item[]{baseItem, lampItem});
        for (Tone tone : Tone.values()) {
            Item item = (Item)new XtoneBlockItem(Xtones.block(tone)).setRegistryName(ID, tone.toString());
            registry.register((IForgeRegistryEntry)item);
            ITEMS.put(tone, item);
        }
    }

    public String toString() {
        return NAME;
    }
}

