/*
 * Decompiled with CFR 0.152.
 */
package com.filostorm.ulvcovers.covers;

import com.filostorm.ulvcovers.items.ULVCoverMetaItems;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import java.util.function.BiFunction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CoverBehaviors {
    public static void init() {
        CoverBehaviors.registerBehavior(104, new ResourceLocation("ulv_covers", "pump.ulv"), ULVCoverMetaItems.ELECTRIC_PUMP_ULV, (tile, side) -> new CoverPump(tile, side, 0, 320));
        CoverBehaviors.registerBehavior(105, new ResourceLocation("ulv_covers", "conveyor.ulv"), ULVCoverMetaItems.CONVEYOR_MODULE_ULV, (tile, side) -> new CoverConveyor(tile, side, 0, 4));
        CoverBehaviors.registerBehavior(106, new ResourceLocation("ulv_covers", "robot.arm.ulv"), ULVCoverMetaItems.ROBOT_ARM_ULV, (tile, side) -> new CoverRoboticArm(tile, side, 0, 4));
    }

    public static void registerBehavior(int coverNetworkId, ResourceLocation coverId, MetaItem.MetaValueItem placerItem, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        placerItem.addComponents(new IItemComponent[]{new CoverPlaceBehavior(CoverBehaviors.registerCover(coverNetworkId, coverId, placerItem, behaviorCreator))});
    }

    public static CoverDefinition registerCover(int coverNetworkId, ResourceLocation coverId, MetaItem.MetaValueItem itemStack, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        CoverDefinition coverDefinition = new CoverDefinition(coverId, behaviorCreator, itemStack.getStackForm());
        GregTechAPI.COVER_REGISTRY.register(coverNetworkId, (Object)coverId, (Object)coverDefinition);
        return coverDefinition;
    }
}

