/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.thermalfoundation.init.TFFluids;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RefineryManager {
    private static Int2ObjectOpenHashMap<RefineryRecipe> recipeMap = new Int2ObjectOpenHashMap();
    private static Int2ObjectOpenHashMap<RefineryRecipe> recipeMapPotion = new Int2ObjectOpenHashMap();
    private static Set<String> bioFluids = new ObjectOpenHashSet();
    private static Set<String> fossilFluids = new ObjectOpenHashSet();
    public static final int DEFAULT_ENERGY = 5000;

    public static RefineryRecipe getRecipe(FluidStack input) {
        return input == null ? null : (RefineryRecipe)recipeMap.get(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static RefineryRecipe getRecipePotion(FluidStack input) {
        return input == null ? null : (RefineryRecipe)recipeMapPotion.get(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static boolean recipeExists(FluidStack input) {
        return RefineryManager.getRecipe(input) != null;
    }

    public static boolean recipeExistsPotion(FluidStack input) {
        return RefineryManager.getRecipePotion(input) != null;
    }

    public static RefineryRecipe[] getRecipeList() {
        return (RefineryRecipe[])recipeMap.values().toArray((Object[])new RefineryRecipe[0]);
    }

    public static RefineryRecipe[] getRecipeListPotion() {
        return (RefineryRecipe[])recipeMapPotion.values().toArray((Object[])new RefineryRecipe[0]);
    }

    public static boolean isFossilFuel(FluidStack fluid) {
        return fluid != null && fossilFluids.contains(fluid.getFluid().getName());
    }

    public static boolean isBioFuel(FluidStack fluid) {
        return fluid != null && bioFluids.contains(fluid.getFluid().getName());
    }

    public static void initialize() {
        int min = 2;
        int max = 4;
        RefineryManager.addStrongPotionRecipes("leaping", min, max);
        RefineryManager.addStrongPotionRecipes("swiftness", min, max);
        RefineryManager.addStrongPotionRecipes("healing", min, max);
        RefineryManager.addStrongPotionRecipes("harming", min, max);
        RefineryManager.addStrongPotionRecipes("poison", min, max);
        RefineryManager.addStrongPotionRecipes("regeneration", min, max);
        RefineryManager.addStrongPotionRecipes("strength", min, max);
        RefineryManager.addStrongPotionRecipes("haste", min, max);
        RefineryManager.addStrongPotionRecipes("resistance", min, max);
        RefineryManager.addStrongPotionRecipes("absorption", min, max);
        RefineryManager.addStrongPotionRecipes("luck", min, max);
        RefineryManager.addStrongPotionRecipes("unluck", min, max);
        RefineryManager.addStrongPotionRecipes("wither", min, max);
        min = 1;
        max = 3;
        RefineryManager.addStrongPotionRecipes("leaping", min, max, "+");
        RefineryManager.addStrongPotionRecipes("swiftness", min, max, "+");
        RefineryManager.addStrongPotionRecipes("poison", min, max, "+");
        RefineryManager.addStrongPotionRecipes("regeneration", min, max, "+");
        RefineryManager.addStrongPotionRecipes("strength", min, max, "+");
        RefineryManager.addStrongPotionRecipes("haste", min, max, "+");
        RefineryManager.addStrongPotionRecipes("resistance", min, max, "+");
        RefineryManager.addStrongPotionRecipes("absorption", min, max, "+");
        RefineryManager.addStrongPotionRecipes("luck", min, max, "+");
        RefineryManager.addStrongPotionRecipes("unluck", min, max, "+");
        RefineryManager.addStrongPotionRecipes("wither", min, max, "+");
    }

    public static void refresh() {
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid, ItemStack outputItem, int chance) {
        if (input == null || outputFluid == null || energy <= 0 || RefineryManager.recipeExists(input)) {
            return null;
        }
        if (outputItem.func_190926_b()) {
            chance = 0;
        }
        RefineryRecipe recipe = new RefineryRecipe(input, outputFluid, outputItem, energy, chance);
        recipeMap.put(FluidHelper.getFluidHash((FluidStack)input), (Object)recipe);
        return recipe;
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid, ItemStack outputItem) {
        return RefineryManager.addRecipe(energy, input, outputFluid, outputItem, 100);
    }

    public static RefineryRecipe addRecipe(int energy, FluidStack input, FluidStack outputFluid) {
        return RefineryManager.addRecipe(energy, input, outputFluid, ItemStack.field_190927_a, 0);
    }

    public static RefineryRecipe addRecipePotion(int energy, FluidStack input, FluidStack outputFluid) {
        if (input == null || outputFluid == null || energy <= 0 || RefineryManager.recipeExistsPotion(input)) {
            return null;
        }
        RefineryRecipe recipe = new RefineryRecipe(input, outputFluid, ItemStack.field_190927_a, energy, 0);
        recipeMapPotion.put(FluidHelper.getFluidHash((FluidStack)input), (Object)recipe);
        return recipe;
    }

    public static RefineryRecipe removeRecipe(FluidStack input) {
        if (input == null) {
            return null;
        }
        return (RefineryRecipe)recipeMap.remove(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static RefineryRecipe removeRecipePotion(FluidStack input) {
        if (input == null) {
            return null;
        }
        return (RefineryRecipe)recipeMapPotion.remove(FluidHelper.getFluidHash((FluidStack)input));
    }

    public static void addBioFuel(Fluid fluid) {
        if (!FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            return;
        }
        bioFluids.add(fluid.getName());
    }

    public static void addFossilFuel(Fluid fluid) {
        if (!FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            return;
        }
        fossilFluids.add(fluid.getName());
    }

    public static void addStrongPotionRecipes(String baseName, int minRank, int maxRank) {
        RefineryManager.addStrongPotionRecipes(baseName, minRank, maxRank, "");
    }

    public static void addStrongPotionRecipes(String baseName, int minRank, int maxRank, String postfix) {
        int baseAmount = 50;
        for (int i = maxRank; i > minRank; --i) {
            int outputAmount = baseAmount * (5 + minRank - i);
            int inputAmount = outputAmount + baseAmount;
            PotionType inputType = RefineryManager.getPotionType(baseName, i - 1, postfix);
            PotionType outputType = RefineryManager.getPotionType(baseName, i, postfix);
            if (inputType == PotionTypes.field_185229_a || outputType == PotionTypes.field_185229_a) continue;
            FluidStack inputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotion, inputAmount), (PotionType)inputType);
            FluidStack outputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotion, outputAmount), (PotionType)outputType);
            RefineryManager.addRecipePotion(2500, inputPotion, outputPotion);
            inputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionSplash, inputAmount), (PotionType)inputType);
            outputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionSplash, outputAmount), (PotionType)outputType);
            RefineryManager.addRecipePotion(2500, inputPotion, outputPotion);
            inputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionLingering, inputAmount), (PotionType)inputType);
            outputPotion = TFFluids.addPotionToFluidStack((FluidStack)new FluidStack(TFFluids.fluidPotionLingering, outputAmount), (PotionType)outputType);
            RefineryManager.addRecipePotion(2500, inputPotion, outputPotion);
        }
    }

    public static PotionType getPotionType(String baseName, int rank, String postfix) {
        PotionType ret;
        switch (rank) {
            case 1: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + postfix));
                if (ret != PotionTypes.field_185229_a) break;
                ret = PotionType.func_185168_a((String)("long_" + baseName));
                break;
            }
            case 2: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + 2 + postfix));
                if (ret != PotionTypes.field_185229_a) break;
                ret = PotionType.func_185168_a((String)("strong_" + baseName));
                break;
            }
            default: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + rank + postfix));
            }
        }
        return ret;
    }

    public static class RefineryRecipe {
        final FluidStack input;
        final FluidStack outputFluid;
        final ItemStack outputItem;
        final int energy;
        final int chance;

        RefineryRecipe(FluidStack input, FluidStack outputFluid, ItemStack outputItem, int energy, int chance) {
            this.input = input;
            this.outputFluid = outputFluid;
            this.outputItem = outputItem;
            this.energy = energy;
            this.chance = chance;
        }

        public FluidStack getInput() {
            return this.input;
        }

        public FluidStack getOutputFluid() {
            return this.outputFluid;
        }

        public ItemStack getOutputItem() {
            return this.outputItem;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

