/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.collect.Streams;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;

public class InventoryPackager
extends InventoryTileBase {
    public static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    public final TilePackager tile;

    public InventoryPackager(TilePackager tile) {
        super(tile, 12);
        this.tile = tile;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (!(index >= 9 || this.tile.func_145831_w().field_72995_K || !this.tile.isWorking || this.func_70301_a(index).func_190926_b() || !stack.func_190926_b() && stack.func_77969_a(this.func_70301_a(index)) && this.tile.isInputValid())) {
            this.tile.endProcess();
        }
        super.func_70299_a(index, stack);
        if (index == 10) {
            this.updatePatternList();
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        if (index < 9 && !this.tile.func_145831_w().field_72995_K && this.tile.isWorking && !this.func_70301_a(index).func_190926_b() && this.tile.isWorking && (this.func_70301_a(index).func_190926_b() || !this.tile.isInputValid())) {
            this.tile.endProcess();
        }
        if (index == 10) {
            this.updatePatternList();
        }
        return stack;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 9: {
                return false;
            }
            case 10: {
                return stack.func_77973_b() instanceof IRecipeListItem || stack.func_77973_b() instanceof IPackageItem;
            }
            case 11: {
                return stack.hasCapability(CapabilityEnergy.ENERGY, null);
            }
        }
        return this.tile.isWorking ? !this.func_70301_a(index).func_190926_b() : true;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.tile.remainingProgress;
            }
            case 1: {
                return this.tile.isWorking ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.tile.remainingProgress = value;
                break;
            }
            case 1: {
                this.tile.isWorking = value != 0;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.updatePatternList();
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index < 9;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 9 || direction == EnumFacing.UP && index != 10 && index != 11;
    }

    public void updatePatternList() {
        this.tile.patternList.clear();
        ItemStack listStack = this.func_70301_a(10);
        if (listStack.func_77973_b() instanceof IRecipeListItem) {
            ((IRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList().forEach(recipe -> recipe.getPatterns().forEach(this.tile.patternList::add));
        } else if (listStack.func_77973_b() instanceof IPackageItem) {
            IPackageItem packageItem = (IPackageItem)listStack.func_77973_b();
            this.tile.patternList.add(packageItem.getRecipeInfo(listStack).getPatterns().get(packageItem.getIndex(listStack)));
        }
        if (TilePackager.forceDisjoint) {
            this.tile.disjoint = true;
        } else if (TilePackager.checkDisjoint) {
            this.tile.disjoint = MiscUtil.arePatternsDisjoint(this.tile.patternList);
        }
        if (this.tile.func_145831_w() != null && !this.tile.func_145831_w().field_72995_K && this.tile.hostHelper != null) {
            this.tile.hostHelper.postPatternChange();
        }
        if (this.tile.func_145831_w() != null) {
            Streams.stream((Iterable)BlockPos.func_177980_a((BlockPos)this.tile.func_174877_v().func_177982_a(-1, -1, -1), (BlockPos)this.tile.func_174877_v().func_177982_a(1, 1, 1))).map(arg_0 -> ((World)this.tile.func_145831_w()).func_175625_s(arg_0)).filter(t -> t instanceof TilePackagerExtension).map(t -> (TilePackagerExtension)t).forEach(t -> t.updatePatternList());
        }
    }
}

