/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.oredict.OreDictionary;

public class PressurizerRecipes
extends ProcessorRecipeHandler {
    public PressurizerRecipes() {
        super("pressurizer", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addRecipe("dustGraphite", "coal", 1.0, 1.0);
        this.addRecipe("dustDiamond", "gemDiamond", 1.0, 1.0);
        this.addRecipe("dustRhodochrosite", "gemRhodochrosite", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dustQuartz", "dustNetherQuartz"}), "gemQuartz", 1.0, 1.0);
        this.addRecipe(PressurizerRecipes.oreStack("dustObsidian", 4), Blocks.field_150343_Z, 1.5, 1.5);
        this.addRecipe("dustBoronNitride", "gemBoronNitride", 1.0, 1.0);
        this.addRecipe("dustFluorite", "gemFluorite", 1.0, 1.0);
        this.addRecipe("dustVilliaumite", "gemVilliaumite", 1.0, 1.0);
        this.addRecipe("dustCarobbiite", "gemCarobbiite", 1.0, 1.0);
        this.addRecipe(PressurizerRecipes.oreStack("ingotGraphite", 64), "gemDiamond", 3.0, 1.5);
        this.addRecipe(PressurizerRecipes.oreStackList(Lists.newArrayList((Object[])new String[]{"dustWheat", "foodFlour"}), 2), NCItems.graham_cracker, 0.25, 0.5);
        this.addRecipe(PressurizerRecipes.oreStack("dustClay", 4), "dustSiliconDioxide", 1.0, 1.0);
        this.addRecipe(RegistryHelper.itemStackFromRegistry("techreborn:part:34"), RegistryHelper.itemStackFromRegistry("techreborn:plates:2"), 1.0, 1.0);
        this.addRecipe("dustEnder", Items.field_151079_bi, 1.0, 1.0);
        this.addPlatePressingRecipes();
    }

    public void addPlatePressingRecipes() {
        for (String ore : OreDictionary.getOreNames()) {
            String plate;
            if (ore.startsWith("plate")) {
                String ingot = "ingot" + ore.substring(5);
                String gem = "gem" + ore.substring(5);
                if (OreDictHelper.oreExists(ingot)) {
                    this.addRecipe(ingot, ore, 1.0, 1.0);
                } else if (OreDictHelper.oreExists(gem)) {
                    this.addRecipe(gem, ore, 1.0, 1.0);
                }
            }
            if (!ore.startsWith("plateDense") || !OreDictHelper.oreExists(plate = "plate" + ore.substring(10))) continue;
            this.addRecipe(PressurizerRecipes.oreStack(plate, 9), ore, 2.0, 2.0);
        }
    }
}

