/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.heatExchanger.HeatExchanger;
import nc.multiblock.heatExchanger.HeatExchangerTubeSetting;
import nc.multiblock.heatExchanger.HeatExchangerTubeType;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerPartBase;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerVent;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.tile.processor.IFluidProcessor;
import nc.util.GasHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileHeatExchangerTube
extends TileHeatExchangerPartBase
implements IFluidProcessor,
ITileFluid {
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(NCConfig.heat_exchanger_tube_tank_capacity[0], NCRecipes.heat_exchanger_valid_fluids.get(0)), new Tank(NCConfig.heat_exchanger_tube_tank_capacity[1], new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON, TankSorption.NON}));
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private GasTileWrapper gasWrapper;
    @Nonnull
    private HeatExchangerTubeSetting[] tubeSettings = new HeatExchangerTubeSetting[]{HeatExchangerTubeSetting.DISABLED, HeatExchangerTubeSetting.DISABLED, HeatExchangerTubeSetting.DISABLED, HeatExchangerTubeSetting.DISABLED, HeatExchangerTubeSetting.DISABLED, HeatExchangerTubeSetting.DISABLED};
    public final int fluidInputSize = 1;
    public final int fluidOutputSize = 1;
    public final int defaultProcessTime = 16000;
    public double baseProcessTime = 16000.0;
    public double time;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public double speedMultiplier = 0.0;
    public int inputTemperature = 0;
    public int outputTemperature = 0;
    public EnumFacing flowDir = null;
    public static final ProcessorRecipeHandler RECIPE_HANDLER = NCRecipes.heat_exchanger;
    protected RecipeInfo<ProcessorRecipe> recipeInfo;
    public final double conductivity;
    protected int tubeCount;

    private TileHeatExchangerTube(HeatExchangerTubeType tubeType) {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
        this.conductivity = tubeType.getConductivity();
    }

    @Override
    public void onMachineAssembled(HeatExchanger controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    public int[] checkPosition() {
        boolean canProcess = this.isMultiblockAssembled() && this.canProcessInputs;
        int adjRealCount = 0;
        int adjMaxCount = 0;
        double speedCount = 0.0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            SpeedMultiplierInfo info = this.getTubeSpeedMultiplier(dir);
            speedCount += info.multiplier;
            if (info.multiplier > 0.0) {
                ++adjRealCount;
            }
            if (!info.contributeMax) continue;
            ++adjMaxCount;
        }
        this.speedMultiplier = canProcess ? speedCount : 0.0;
        return new int[]{canProcess ? adjRealCount : 0, adjMaxCount};
    }

    private SpeedMultiplierInfo getTubeSpeedMultiplier(EnumFacing dir) {
        boolean tubeActive;
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileHeatExchangerTube)) {
            return new SpeedMultiplierInfo(0.0, false);
        }
        TileHeatExchangerTube tube = (TileHeatExchangerTube)tile;
        boolean bl = tubeActive = tube.canProcessInputs && (!this.requiresContraflow(tube) || this.isContraflow(tube));
        if (!this.canConnectFluid(dir) || !tube.canConnectFluid(dir.func_176734_d())) {
            return new SpeedMultiplierInfo(tubeActive ? this.conductivityMult() * this.getRawTubeSpeedMultiplier(tube) : 0.0, true);
        }
        return new SpeedMultiplierInfo(0.0, false);
    }

    private double getRawTubeSpeedMultiplier(TileHeatExchangerTube tube) {
        return this.isHeating() != tube.isHeating() ? (double)tube.getAbsRecipeTempDiff() : (this.isHeating() ? (double)(-this.getAbsInputTempDiff(tube)) : 0.0);
    }

    private boolean isContraflow(TileHeatExchangerTube tube) {
        if (this.flowDir == null || tube.flowDir == null) {
            return !(this.flowDir == null ^ tube.flowDir == null);
        }
        return this.flowDir.func_176745_a() != tube.flowDir.func_176745_a();
    }

    private boolean requiresContraflow(TileHeatExchangerTube tube) {
        return this.inputTemperature > tube.inputTemperature ^ this.outputTemperature > tube.outputTemperature;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateTube();
    }

    public void updateTube() {
        if (!this.field_145850_b.field_72995_K) {
            this.setIsHeatExchangerOn();
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            this.tickTube();
            if (this.isProcessing) {
                this.process();
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
            }
            if (this.tubeCount == 0) {
                this.pushFluid();
                this.refreshRecipe();
                this.refreshActivity();
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickTube() {
        ++this.tubeCount;
        this.tubeCount %= NCConfig.machine_update_rate / 4;
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = RECIPE_HANDLER.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    private int getAbsRecipeTempDiff() {
        return Math.abs(this.inputTemperature - this.outputTemperature);
    }

    private int getAbsInputTempDiff(TileHeatExchangerTube tube) {
        return Math.abs(this.inputTemperature - tube.inputTemperature);
    }

    private double conductivityMult() {
        return this.isHeating() ? this.conductivity : 1.0 / this.conductivity;
    }

    private boolean isHeating() {
        return this.inputTemperature < this.outputTemperature;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = 16000.0;
            this.inputTemperature = 0;
            this.outputTemperature = 0;
            return false;
        }
        this.baseProcessTime = this.recipeInfo.getRecipe().getHeatExchangerProcessTime(16000.0);
        this.inputTemperature = this.recipeInfo.getRecipe().getHeatExchangerInputTemperature();
        this.outputTemperature = this.recipeInfo.getRecipe().getHeatExchangerOutputTemperature();
        return true;
    }

    public boolean isProcessing() {
        return this.readyToProcess() && this.isHeatExchangerOn;
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.isMultiblockAssembled();
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.tanks.get(j + 1).isEmpty()) continue;
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.tanks.get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.tanks.get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time = Math.max(0.0, this.time + this.getSpeedMultiplier());
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = !this.setRecipeStats() ? 0.0 : MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        if (this.recipeInfo == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int fluidIngredientStackSize = this.getFluidIngredients().get(fluidInputOrder.get(i)).getMaxStackSize(this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (fluidIngredientStackSize > 0) {
                this.tanks.get(i).changeFluidAmount(-fluidIngredientStackSize);
            }
            if (this.tanks.get(i).getFluidAmount() > 0) continue;
            this.tanks.get(i).setFluidStored(null);
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (this.tanks.get(j + 1).isEmpty()) {
                this.tanks.get(j + 1).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.tanks.get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
    }

    @Override
    public List<Tank> getFluidInputs() {
        return this.tanks.subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().fluidProducts();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Nonnull
    public HeatExchangerTubeSetting[] getTubeSettings() {
        return this.tubeSettings;
    }

    public void setTubeSettings(@Nonnull HeatExchangerTubeSetting[] settings) {
        this.tubeSettings = settings;
    }

    public HeatExchangerTubeSetting getTubeSetting(@Nonnull EnumFacing side) {
        return this.tubeSettings[side.func_176745_a()];
    }

    public void setTubeSetting(@Nonnull EnumFacing side, @Nonnull HeatExchangerTubeSetting setting) {
        this.tubeSettings[side.func_176745_a()] = setting;
    }

    public void toggleTubeSetting(@Nonnull EnumFacing side) {
        this.setTubeSetting(side, this.getTubeSetting(side).next());
        this.refreshFluidConnections(side);
        this.updateFlowDir();
        this.markDirtyAndNotify();
    }

    public void refreshFluidConnections(@Nonnull EnumFacing side) {
        switch (this.getTubeSetting(side)) {
            case DISABLED: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            case DEFAULT: {
                this.setTankSorption(side, 0, TankSorption.IN);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            case PRODUCT_OUT: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.OUT);
                break;
            }
            case INPUT_SPREAD: {
                this.setTankSorption(side, 0, TankSorption.OUT);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            default: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.NON);
            }
        }
    }

    public void updateFlowDir() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            HeatExchangerTubeSetting thisSetting = this.getTubeSetting(side);
            if (thisSetting == HeatExchangerTubeSetting.DISABLED) continue;
            TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
            if (tile instanceof TileHeatExchangerVent && thisSetting == HeatExchangerTubeSetting.PRODUCT_OUT) {
                this.flowDir = side;
                return;
            }
            if (!(tile instanceof TileHeatExchangerTube)) continue;
            TileHeatExchangerTube tube = (TileHeatExchangerTube)tile;
            HeatExchangerTubeSetting tubeSetting = tube.getTubeSetting(side.func_176734_d());
            if ((thisSetting != HeatExchangerTubeSetting.INPUT_SPREAD || tubeSetting != HeatExchangerTubeSetting.DEFAULT) && (thisSetting != HeatExchangerTubeSetting.PRODUCT_OUT || tubeSetting != HeatExchangerTubeSetting.DEFAULT && tubeSetting != HeatExchangerTubeSetting.INPUT_SPREAD)) continue;
            this.flowDir = side;
            return;
        }
        this.flowDir = null;
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        block8: {
            TileEntity tile;
            HeatExchangerTubeSetting thisSetting;
            block5: {
                HeatExchangerTubeSetting tubeSetting;
                TileHeatExchangerTube tube;
                block6: {
                    block7: {
                        thisSetting = this.getTubeSetting(side);
                        if (thisSetting == HeatExchangerTubeSetting.DISABLED) {
                            return;
                        }
                        tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
                        if (!(tile instanceof TileHeatExchangerTube)) break block5;
                        tube = (TileHeatExchangerTube)tile;
                        tubeSetting = tube.getTubeSetting(side.func_176734_d());
                        if (thisSetting != HeatExchangerTubeSetting.INPUT_SPREAD) break block6;
                        if (tubeSetting != HeatExchangerTubeSetting.DEFAULT) break block7;
                        this.pushInputFluid(tube);
                        this.pushProduct(tube);
                        break block8;
                    }
                    if (tubeSetting != HeatExchangerTubeSetting.PRODUCT_OUT) break block8;
                    this.pushInputFluid(tube);
                    break block8;
                }
                if (thisSetting != HeatExchangerTubeSetting.PRODUCT_OUT || tubeSetting != HeatExchangerTubeSetting.DEFAULT && tubeSetting != HeatExchangerTubeSetting.INPUT_SPREAD) break block8;
                this.pushProduct(tube);
                break block8;
            }
            if (thisSetting == HeatExchangerTubeSetting.PRODUCT_OUT) {
                IFluidHandler adjStorage;
                if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
                    return;
                }
                IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                if (adjStorage == null) {
                    return;
                }
                for (int i = 0; i < this.getTanks().size(); ++i) {
                    if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) continue;
                    this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
                }
            }
        }
    }

    public void pushInputFluid(TileHeatExchangerTube other) {
        int diff = this.getTanks().get(0).getFluidAmount() - other.getTanks().get(0).getFluidAmount();
        if (diff > 1) {
            this.getTanks().get(0).drain(other.getTanks().get(0).fillInternal(this.getTanks().get(0).drain((int)((double)diff * NCConfig.heat_exchanger_tube_spread_ratio), false), true), true);
        }
    }

    public void pushProduct(TileHeatExchangerTube other) {
        this.getTanks().get(1).drain(other.getTanks().get(1).fillInternal(this.getTanks().get(1).drain(this.getTanks().get(1).getCapacity(), false), true), true);
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public NBTTagCompound writeTubeSettings(NBTTagCompound nbt) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            settingsTag.func_74768_a("setting" + side.func_176745_a(), this.getTubeSetting(side).ordinal());
        }
        nbt.func_74782_a("tubeSettings", (NBTBase)settingsTag);
        return nbt;
    }

    public void readTubeSettings(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidConnections0")) {
            block6: for (EnumFacing side : EnumFacing.field_82609_l) {
                TankSorption sorption = TankSorption.values()[nbt.func_74762_e("fluidConnections" + side.func_176745_a())];
                switch (sorption) {
                    case NON: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setTubeSetting(side, HeatExchangerTubeSetting.DISABLED);
                        continue block6;
                    }
                    case BOTH: {
                        this.setTankSorption(side, 0, TankSorption.IN);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setTubeSetting(side, HeatExchangerTubeSetting.DEFAULT);
                        continue block6;
                    }
                    case IN: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.OUT);
                        this.setTubeSetting(side, HeatExchangerTubeSetting.PRODUCT_OUT);
                        continue block6;
                    }
                    case OUT: {
                        this.setTankSorption(side, 0, TankSorption.OUT);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setTubeSetting(side, HeatExchangerTubeSetting.INPUT_SPREAD);
                        continue block6;
                    }
                    default: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setTubeSetting(side, HeatExchangerTubeSetting.DISABLED);
                    }
                }
            }
        } else {
            NBTTagCompound settingsTag = nbt.func_74775_l("tubeSettings");
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.setTubeSetting(side, HeatExchangerTubeSetting.values()[settingsTag.func_74762_e("setting" + side.func_176745_a())]);
                this.refreshFluidConnections(side);
            }
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeTubeSettings(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74780_a("speedMultiplier", this.speedMultiplier);
        nbt.func_74768_a("inputTemperature", this.inputTemperature);
        nbt.func_74768_a("outputTemperature", this.outputTemperature);
        nbt.func_74768_a("flowDir", this.flowDir == null ? -1 : this.flowDir.func_176745_a());
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readTubeSettings(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.speedMultiplier = nbt.func_74769_h("speedMultiplier");
        this.inputTemperature = nbt.func_74762_e("inputTemperature");
        this.outputTemperature = nbt.func_74762_e("outputTemperature");
        this.flowDir = nbt.func_74762_e("flowDir") == -1 ? null : EnumFacing.field_82609_l[nbt.func_74762_e("flowDir")];
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    private static class SpeedMultiplierInfo {
        final double multiplier;
        final boolean contributeMax;

        SpeedMultiplierInfo(double multiplier, boolean contributeMax) {
            this.multiplier = multiplier;
            this.contributeMax = contributeMax;
        }
    }

    public static class Thermoconducting
    extends TileHeatExchangerTube {
        public Thermoconducting() {
            super(HeatExchangerTubeType.THERMOCONDUCTING);
        }
    }

    public static class HardCarbon
    extends TileHeatExchangerTube {
        public HardCarbon() {
            super(HeatExchangerTubeType.HARD_CARBON);
        }
    }

    public static class Copper
    extends TileHeatExchangerTube {
        public Copper() {
            super(HeatExchangerTubeType.COPPER);
        }
    }
}

