/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.tooltip;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionMessage {
    private static HashMap<Class, ActionMessageObjectType> typeClasses = new HashMap();
    private static List<ActionMessageObjectType> types = new ArrayList<ActionMessageObjectType>();
    public String text;
    public Object[] objects;

    public static void registerType(ActionMessageObjectType type) {
        type.index = ActionMessage.types.size();
        typeClasses.put(type.clazz, type);
        types.add(type);
    }

    public static ActionMessageObjectType getType(int index) {
        return types.get(index);
    }

    public static ActionMessageObjectType getType(Object object) {
        ActionMessageObjectType type = typeClasses.get(object.getClass());
        if (type == null) {
            throw new RuntimeException("Invalid object in action message " + object + " clazz: " + object.getClass());
        }
        return type;
    }

    public ActionMessage(String text, Object[] objects) {
        this.text = text;
        this.objects = objects;
    }

    static {
        ActionMessage.registerType(new ActionMessageObjectType<ItemStack>(ItemStack.class){

            @Override
            public void write(ItemStack object, ByteBuf buf) {
                CreativeCorePacket.writeItemStack((ByteBuf)buf, (ItemStack)object);
            }

            @Override
            public ItemStack read(ByteBuf buf) {
                return CreativeCorePacket.readItemStack((ByteBuf)buf);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public int width(ItemStack object, GuiRenderHelper helper) {
                return 20;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void render(ItemStack object, GuiRenderHelper helper, int color, float alpha) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                helper.drawItemStack(object, 2, -4, 16, 16, 0, color);
            }
        });
    }

    public static abstract class ActionMessageObjectType<T> {
        public final Class<T> clazz;
        private int index;

        public ActionMessageObjectType(Class<T> clazz) {
            this.clazz = clazz;
        }

        public int index() {
            return this.index;
        }

        public abstract void write(T var1, ByteBuf var2);

        public abstract T read(ByteBuf var1);

        @SideOnly(value=Side.CLIENT)
        public abstract int width(T var1, GuiRenderHelper var2);

        @SideOnly(value=Side.CLIENT)
        public abstract void render(T var1, GuiRenderHelper var2, int var3, float var4);
    }
}

