/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesNoOverlap;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.ShapeRegistry;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleShape {
    public final int pointsBeforePlacing;

    public LittleShape(int pointsBeforePlacing) {
        this.pointsBeforePlacing = pointsBeforePlacing;
    }

    public String getKey() {
        return ShapeRegistry.getShapeName(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return GuiControl.translateOrDefault((String)("shape." + this.getKey()), (String)this.getKey());
    }

    public int maxAllowed() {
        return -1;
    }

    protected abstract void addBoxes(LittleBoxes var1, ShapeSelection var2, boolean var3);

    public LittleBoxes getBoxes(ShapeSelection selection, boolean lowResolution) {
        LittleBoxes boxes = this.requiresNoOverlap() ? new LittleBoxesNoOverlap(selection.getPos(), selection.getContext()) : new LittleBoxesSimple(selection.getPos(), selection.getContext());
        this.addBoxes(boxes, selection, lowResolution);
        return boxes;
    }

    public boolean requiresNoOverlap() {
        return false;
    }

    public abstract void addExtraInformation(NBTTagCompound var1, List<String> var2);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1, LittleGridContext var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2, LittleGridContext var3);

    public abstract void rotate(NBTTagCompound var1, Rotation var2);

    public abstract void flip(NBTTagCompound var1, EnumFacing.Axis var2);
}

