/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.DragShapeBox;
import com.creativemd.littletiles.common.util.shape.DragShapeCylinder;
import com.creativemd.littletiles.common.util.shape.DragShapeLine;
import com.creativemd.littletiles.common.util.shape.DragShapePyramid;
import com.creativemd.littletiles.common.util.shape.DragShapeSliced;
import com.creativemd.littletiles.common.util.shape.DragShapeSphere;
import com.creativemd.littletiles.common.util.shape.DragShapeWall;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DragShape {
    private static LinkedHashMap<String, DragShape> shapes = new LinkedHashMap();
    public static final DragShape box = new DragShapeBox();
    public static final DragShape sphere = new DragShapeSphere();
    public static final DragShape cylinder = new DragShapeCylinder();
    public static final DragShape wall = new DragShapeWall();
    public static final DragShape line = new DragShapeLine();
    public static final DragShape slice = new DragShapeSliced();
    public static final DragShape pyramid = new DragShapePyramid();
    public static final DragShape defaultShape = box;
    public final String key;

    public static Collection<DragShape> shapes() {
        return shapes.values();
    }

    public static Set<String> keys() {
        return shapes.keySet();
    }

    public static void registerDragShape(DragShape shape) {
        shapes.put(shape.key, shape);
    }

    public static DragShape getShape(String name) {
        DragShape shape = shapes.get(name);
        return shape == null ? defaultShape : shape;
    }

    public DragShape(String name) {
        this.key = name;
    }

    public abstract LittleBoxes getBoxes(LittleBoxes var1, LittleVec var2, LittleVec var3, EntityPlayer var4, NBTTagCompound var5, boolean var6, LittleAbsoluteVec var7, LittleAbsoluteVec var8);

    public abstract void addExtraInformation(NBTTagCompound var1, List<String> var2);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1, LittleGridContext var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2, LittleGridContext var3);

    public abstract void rotate(NBTTagCompound var1, Rotation var2);

    public abstract void flip(NBTTagCompound var1, EnumFacing.Axis var2);

    static {
        DragShape.registerDragShape(box);
        DragShape.registerDragShape(sphere);
        DragShape.registerDragShape(cylinder);
        DragShape.registerDragShape(wall);
        DragShape.registerDragShape(line);
        DragShape.registerDragShape(slice);
        DragShape.registerDragShape(pyramid);
    }
}

