/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.registry;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.littletiles.client.gui.controls.IAnimationControl;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiSignalEvents;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleStructureGuiParser
implements IAnimationControl {
    public final GuiParent parent;
    public final AnimationGuiHandler handler;

    public LittleStructureGuiParser(GuiParent parent, AnimationGuiHandler handler) {
        this.parent = parent;
        this.handler = handler;
    }

    @SideOnly(value=Side.CLIENT)
    public void create(LittlePreviews previews, @Nullable LittleStructure structure) {
        this.createControls(previews, structure);
        this.parent.controls.add(new SubGuiSignalEvents.GuiSignalEventsButton("signal", 0, 122, previews, structure, this.getStructureType()));
    }

    @SideOnly(value=Side.CLIENT)
    public LittleStructure parse(LittlePreviews previews) {
        LittleStructure structure = this.parseStructure(previews);
        SubGuiSignalEvents.GuiSignalEventsButton button = (SubGuiSignalEvents.GuiSignalEventsButton)this.parent.get("signal");
        button.setEventsInStructure(structure);
        return structure;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void createControls(LittlePreviews var1, @Nullable LittleStructure var2);

    @SideOnly(value=Side.CLIENT)
    protected abstract LittleStructure parseStructure(LittlePreviews var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract LittleStructureType getStructureType();

    public <T extends LittleStructure> T createStructure(Class<T> structureClass, StructureTileList parent) {
        LittleStructureType type = LittleStructureRegistry.getStructureType(structureClass);
        if (type == null) {
            throw new RuntimeException("Could find structure for " + structureClass);
        }
        return (T)type.createStructure(parent);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onLoaded(AnimationPreview animationPreview) {
    }

    public static abstract class LittleStructureGuiParserNotFoundHandler {
        @SideOnly(value=Side.CLIENT)
        public abstract LittleStructureGuiParser create(LittleStructure var1, GuiParent var2, AnimationGuiHandler var3);
    }
}

