/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureConnection;
import com.creativemd.littletiles.common.structure.connection.IWorldPositionProvider;
import com.creativemd.littletiles.common.structure.connection.StructureChildFromSubWorldConnection;
import com.creativemd.littletiles.common.structure.connection.StructureChildToSubWorldConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.CorruptedLinkException;
import com.creativemd.littletiles.common.structure.exception.MissingBlockException;
import com.creativemd.littletiles.common.structure.exception.MissingStructureException;
import com.creativemd.littletiles.common.structure.exception.MissingWorldException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.outdated.connection.StructureLink;
import com.creativemd.littletiles.common.world.LittleNeighborUpdateCollector;
import java.security.InvalidParameterException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class StructureChildConnection
implements IStructureConnection {
    public final IWorldPositionProvider parent;
    public final boolean isChild;
    public final int childId;
    public final boolean dynamic;
    private final int structureIndex;
    private final int attribute;
    private final BlockPos relativePos;
    private TileEntityLittleTiles cachedTe;

    public StructureChildConnection(IWorldPositionProvider parent, boolean isChild, boolean dynamic, int childId, BlockPos relative, int index, int attribute) {
        this.parent = parent;
        this.isChild = isChild;
        this.childId = childId;
        this.structureIndex = index;
        this.attribute = attribute;
        this.relativePos = relative;
        this.dynamic = dynamic;
    }

    public StructureChildConnection(IWorldPositionProvider parent, boolean isChild, NBTTagCompound nbt) {
        this.parent = parent;
        this.isChild = isChild;
        this.childId = nbt.func_74762_e("child");
        this.attribute = nbt.func_74762_e("type");
        this.structureIndex = nbt.func_74762_e("index");
        this.dynamic = nbt.func_74767_n("dynamic");
        int[] array = nbt.func_74759_k("coord");
        if (array.length != 3) {
            throw new InvalidParameterException("No valid coord given " + nbt);
        }
        this.relativePos = new BlockPos(array[0], array[1], array[2]);
    }

    public boolean isChild() {
        return this.isChild;
    }

    public int getChildId() {
        return this.childId;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("child", this.childId);
        nbt.func_74783_a("coord", new int[]{this.relativePos.func_177958_n(), this.relativePos.func_177956_o(), this.relativePos.func_177952_p()});
        nbt.func_74768_a("type", this.attribute);
        nbt.func_74768_a("index", this.structureIndex);
        if (this.dynamic) {
            nbt.func_74757_a("dynamic", this.dynamic);
        }
        return nbt;
    }

    public void destroyStructure(LittleNeighborUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        if (!this.isChild()) {
            this.getStructure().removeStructure(neighbor);
        }
    }

    public EntityAnimation getAnimation() {
        return null;
    }

    @Override
    public BlockPos getStructurePosition() {
        return this.relativePos.func_177971_a((Vec3i)this.parent.getPos());
    }

    @Override
    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        TileEntityLittleTiles te = this.getTileEntity();
        if (!te.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureTileList structure = te.getStructure(this.structureIndex);
        if (structure != null) {
            return structure.getStructure();
        }
        throw new MissingStructureException(te.func_174877_v());
    }

    protected World getWorld() throws CorruptedConnectionException, NotYetConnectedException {
        return this.parent.getWorld();
    }

    protected TileEntityLittleTiles getTileEntity() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.cachedTe != null && !this.cachedTe.func_145837_r() && !this.cachedTe.unloaded()) {
            return this.cachedTe;
        }
        if (this.relativePos == null) {
            throw new CorruptedLinkException();
        }
        World world = this.getWorld();
        if (world == null) {
            throw new MissingWorldException();
        }
        BlockPos absoluteCoord = this.getStructurePosition();
        Chunk chunk = world.func_175726_f(absoluteCoord);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk)) {
            TileEntity te = world.func_175625_s(absoluteCoord);
            if (te instanceof TileEntityLittleTiles) {
                this.cachedTe = (TileEntityLittleTiles)te;
                return this.cachedTe;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    @Override
    public int getIndex() {
        return this.structureIndex;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    public static StructureChildConnection loadFromNBT(IWorldPositionProvider structure, NBTTagCompound nbt, boolean isChild) {
        if (nbt.func_74764_b("childID")) {
            return StructureLink.loadFromNBTOld(structure, nbt, isChild);
        }
        if (nbt.func_74764_b("entity")) {
            return new StructureChildToSubWorldConnection(structure, nbt);
        }
        if (nbt.func_74767_n("subWorld")) {
            return new StructureChildFromSubWorldConnection(structure, nbt);
        }
        return new StructureChildConnection(structure, isChild, nbt);
    }
}

