/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.gui.SubGuiHammer;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiGridSelector;
import com.creativemd.littletiles.client.render.overlay.PreviewRenderer;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.api.ILittleEditor;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.IMarkMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.selection.selector.TileSelector;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeRegistry;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import com.creativemd.littletiles.common.util.tooltip.IItemTooltip;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLittleHammer
extends Item
implements ILittleEditor,
IItemTooltip {
    private static boolean activeFilter = false;
    private static TileSelector currentFilter = null;
    public static ShapeSelection selection;

    public static boolean isFiltered() {
        return activeFilter;
    }

    public static void setFilter(boolean active, TileSelector filter) {
        activeFilter = active;
        currentFilter = filter;
    }

    public static TileSelector getFilter() {
        return currentFilter;
    }

    public ItemLittleHammer() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("can be used to chisel blocks");
        LittleShape shape = ItemLittleHammer.getShape(stack);
        tooltip.add("mode: " + shape.getKey());
        shape.addExtraInformation(stack.func_77978_p(), tooltip);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public LittleBoxes getBoxes(World world, ItemStack stack, EntityPlayer player, PlacementPosition pos, RayTraceResult result) {
        if (selection == null) {
            selection = new ShapeSelection(stack, true);
        }
        selection.setLast(player, stack, pos, result);
        return selection.getBoxes(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClickBlock(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (LittleAction.isUsingSecondMode(player)) {
            selection = null;
            PreviewRenderer.marked = null;
        } else if (selection != null && selection.addAndCheckIfPlace(player, position, result)) {
            if (ItemLittleHammer.isFiltered()) {
                new LittleActionDestroyBoxes.LittleActionDestroyBoxesFiltered(selection.getBoxes(false), ItemLittleHammer.getFilter()).execute();
            } else {
                new LittleActionDestroyBoxes(selection.getBoxes(false)).execute();
            }
            selection = null;
            PreviewRenderer.marked = null;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRightClick(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (selection != null) {
            selection.click(player);
        }
        return true;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @Override
    public void onDeselect(World world, ItemStack stack, EntityPlayer player) {
        selection = null;
    }

    @Override
    public boolean hasCustomBoxes(World world, ItemStack stack, EntityPlayer player, IBlockState state, PlacementPosition pos, RayTraceResult result) {
        return LittleAction.isBlockValid(state) || world.func_175625_s(result.func_178782_a()) instanceof TileEntityLittleTiles;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return new SubGuiHammer(stack);
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @Override
    public void rotate(EntityPlayer player, ItemStack stack, Rotation rotation, boolean client) {
        if (client && selection != null) {
            selection.rotate(player, stack, rotation);
        } else {
            new ShapeSelection(stack, false).rotate(player, stack, rotation);
        }
    }

    @Override
    public void flip(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis, boolean client) {
        if (client && selection != null) {
            selection.flip(player, stack, axis);
        } else {
            new ShapeSelection(stack, false).flip(player, stack, axis);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMarkMode onMark(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result, PlacementPreview previews) {
        if (selection != null) {
            selection.toggleMark();
        }
        return selection;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiGridSelector(stack, ItemMultiTiles.currentContext, ItemLittleHammer.isFiltered(), ItemLittleHammer.getFilter()){

            @Override
            public void saveConfiguration(LittleGridContext context, boolean activeFilter, TileSelector selector) {
                ItemLittleHammer.setFilter(activeFilter, selector);
                if (selection != null) {
                    selection.convertTo(context);
                }
                ItemMultiTiles.currentContext = context;
            }
        };
    }

    public static LittleShape getShape(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return ShapeRegistry.getShape(stack.func_77978_p().func_74779_i("shape"));
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{ItemLittleHammer.getShape(stack).getLocalizedName(), LittleTilesClient.mark.getDisplayName(), LittleTilesClient.configure.getDisplayName(), LittleTilesClient.configureAdvanced.getDisplayName()};
    }
}

